/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryHierarchyImpl;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryHierarchy;
import java.util.HashMap;
import java.util.Map;

public class QueryHierarchyProvider {
    private final WITContext context;
    private final Object lock = new Object();
    private final Map<Integer, QueryHierarchy> projectQueryHierarchies = new HashMap<Integer, QueryHierarchy>();

    public QueryHierarchyProvider(WITContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHierarchy getQueryHierarchy(Project project) {
        Object object = this.lock;
        synchronized (object) {
            Integer projectIdKey = new Integer(project.getID());
            QueryHierarchy hierarchy = this.projectQueryHierarchies.get(projectIdKey);
            if (hierarchy == null) {
                hierarchy = new QueryHierarchyImpl(project);
                this.projectQueryHierarchies.put(projectIdKey, hierarchy);
            }
            return hierarchy;
        }
    }

    public boolean supportsFolders() {
        return this.context.getServerInfo().isSupported("QueryFolders");
    }

    public boolean supportsPermissions() {
        return this.context.getServerInfo().isSupported("QueryFolderPermissions");
    }
}

