/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules;

import com.microsoft.tfs.core.clients.workitem.WorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.fields.FieldStatus;
import com.microsoft.tfs.core.clients.workitem.internal.IWITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.ServerComputedFieldType;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IConstantSet;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.SpecialConstantIDs;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IFieldPickListSupport;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IRuleTarget;
import com.microsoft.tfs.core.clients.workitem.internal.rules.IRuleTargetField;
import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import com.microsoft.tfs.core.clients.workitem.internal.rules.UnhandledRuleStateException;
import com.microsoft.tfs.core.clients.workitem.internal.rules.UnhandledSpecialConstantIDException;
import com.microsoft.tfs.core.clients.workitem.internal.rules.cache.RuleCache;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleEngine {
    private static final Log log = LogFactory.getLog(RuleEngine.class);
    private static final Object SERVERCOMPUTED_CURRENT_USER_SET_VALUE_OPERATION = new Object();
    private static final Object SERVERCOMPUTED_DATETIME_SET_VALUE_OPERATION = new Object();
    private static final Object SERVERCOMPUTED_RANDOM_GUID_SET_VALUE_OPERATION = new Object();
    private final IRuleTarget target;
    private final IWITContext witContext;
    private final Map<Integer, Object> setValueOperations = new HashMap<Integer, Object>();

    public RuleEngine(IRuleTarget target, IWITContext witContext) {
        this.target = target;
        this.witContext = witContext;
    }

    public void open() {
        int id = this.target.getID();
        boolean isNew = id == 0;
        log.trace((Object)MessageFormat.format("opening target: {0}", Integer.toString(id)));
        this.runRulesOnOpen(isNew, 0);
        this.runRulesOnOpen(isNew, this.target.getAreaID());
    }

    public void runRulesOnOpen(boolean isNew, int areaId) {
        log.trace((Object)("Run rules for area " + areaId + " on OPEN ***************"));
        RuleCache.RuleCacheResults results = this.witContext.getRuleCache().getRules(areaId);
        this.preProcessFields(results.affectedFieldIds);
        this.runDefaultRules(results.defaultRules);
        if (isNew) {
            log.trace((Object)"re-running default rules for new target");
            this.runDefaultRules(results.defaultRules);
        }
        this.runNonDefaultRules(results.nonDefaultRules);
        this.postProcessFields(results.affectedFieldIds);
        log.trace((Object)("Done running rules for area " + areaId + " on OPEN ***************"));
    }

    public boolean fieldChanged(int changedFieldId) {
        HashSet<Integer> affectedFieldIDs = new HashSet<Integer>();
        this.fieldChanged(changedFieldId, 2, affectedFieldIDs);
        this.postProcessFields(affectedFieldIDs);
        return affectedFieldIDs.contains(new Integer(changedFieldId));
    }

    private void fieldChanged(int changedFieldId, int recursive, Set<Integer> allAffectedFieldIDs) {
        log.trace((Object)MessageFormat.format("field [{0}] changed for work item: {1}", Integer.toString(changedFieldId), Integer.toString(this.target.getID())));
        RuleCache.RuleCacheResults resultsGlobal = this.witContext.getRuleCache().getRules(0, changedFieldId);
        RuleCache.RuleCacheResults resultsArea = this.witContext.getRuleCache().getRules(this.target.getAreaID(), changedFieldId);
        HashSet<Integer> affectedFieldIDs = new HashSet<Integer>();
        affectedFieldIDs.addAll(resultsGlobal.affectedFieldIds);
        affectedFieldIDs.addAll(resultsArea.affectedFieldIds);
        allAffectedFieldIDs.addAll(affectedFieldIDs);
        this.preProcessFields(affectedFieldIDs);
        this.runDefaultRules(resultsGlobal.defaultRules);
        this.runNonDefaultRules(resultsGlobal.nonDefaultRules);
        this.runDefaultRules(resultsArea.defaultRules);
        this.runNonDefaultRules(resultsArea.nonDefaultRules);
        if (recursive > 0) {
            for (Integer affectedFieldId : affectedFieldIDs) {
                this.fieldChanged(affectedFieldId, recursive - 1, allAffectedFieldIDs);
            }
        }
    }

    private void preProcessFields(Set<Integer> fieldIds) {
        for (Integer fieldId : fieldIds) {
            IRuleTargetField field = this.target.getRuleTargetField(fieldId);
            field.getPickListSupport().reset();
            field.setStatus(FieldStatus.VALID);
            field.setReadOnly(false);
        }
    }

    private void postProcessFields(Set<Integer> fieldIds) {
        if (log.isTraceEnabled()) {
            log.trace((Object)MessageFormat.format("post processing: {0}", fieldIds));
        }
        for (Integer fieldId : fieldIds) {
            IRuleTargetField field = this.target.getRuleTargetField(fieldId);
            field.postProcessAfterRuleRun();
        }
    }

    private void runNonDefaultRules(List<Rule> nonDefaultRules) {
        for (Rule rule : nonDefaultRules) {
            if (!this.isRuleInScope(rule)) continue;
            this.runNonDefaultRule(rule);
        }
    }

    private void runDefaultRules(List<Rule> defaultRules) {
        for (Rule rule : defaultRules) {
            if (!this.isRuleInScope(rule)) continue;
            this.runDefaultRule(rule);
        }
        for (Integer fieldId : this.setValueOperations.keySet()) {
            Object valueToSet = this.setValueOperations.get(fieldId);
            IRuleTargetField field = this.target.getRuleTargetField(fieldId);
            if (valueToSet == SERVERCOMPUTED_CURRENT_USER_SET_VALUE_OPERATION) {
                field.setServerComputed(ServerComputedFieldType.CURRENT_USER);
                continue;
            }
            if (valueToSet == SERVERCOMPUTED_DATETIME_SET_VALUE_OPERATION) {
                field.setServerComputed(ServerComputedFieldType.DATE_TIME);
                continue;
            }
            if (valueToSet == SERVERCOMPUTED_RANDOM_GUID_SET_VALUE_OPERATION) {
                field.setServerComputed(ServerComputedFieldType.RANDOM_GUID);
                continue;
            }
            field.setValueFromRule(valueToSet);
        }
        this.setValueOperations.clear();
    }

    private void runDefaultRule(Rule rule) {
        int thenConst = rule.getThenConstID();
        int thenFldID = rule.getThenFldID();
        if (-14 == thenFldID) {
            return;
        }
        Integer setValueOperationkey = new Integer(thenFldID);
        String traceOutput = MessageFormat.format("applying VP rule [{0}] in area [{1}] to field [{2}]: ", Integer.toString(rule.getRuleID()), Integer.toString(rule.getAreaID()), this.getFieldNameForTrace(thenFldID));
        if (SpecialConstantIDs.isSpecialConstantID(thenConst)) {
            switch (thenConst) {
                case -10002: {
                    String currentUserDisplayName = this.witContext.getCurrentUserDisplayName();
                    log.trace((Object)MessageFormat.format("{0}ConstCurrentUser ({1})", traceOutput, currentUserDisplayName));
                    this.setValueOperations.put(setValueOperationkey, currentUserDisplayName);
                    break;
                }
                case -10012: {
                    if (rule.getIf2ConstID() != -10012) {
                        throw new UnhandledRuleStateException(rule, MessageFormat.format("default ConstOldValueInOtherField rule with If2ConstID={0}", Integer.toString(rule.getIf2ConstID())));
                    }
                    int otherFieldID = rule.getIf2FldID();
                    if (otherFieldID == 0) {
                        throw new UnhandledRuleStateException(rule, MessageFormat.format("default ConstOldValueInOtherField with If2FldID={0}", Integer.toString(rule.getIf2FldID())));
                    }
                    Object oldValue = this.target.getRuleTargetField(otherFieldID).getOriginalValue();
                    log.trace((Object)MessageFormat.format("{0}ConstOldValueInOtherField ({1})", traceOutput, oldValue));
                    this.setValueOperations.put(setValueOperationkey, oldValue);
                    break;
                }
                case -10000: {
                    this.setValueOperations.put(setValueOperationkey, null);
                    log.trace((Object)MessageFormat.format("{0}ConstEmptyValue", traceOutput));
                    break;
                }
                case -10026: {
                    log.trace((Object)MessageFormat.format("{0}ConstServerCurrentUser", traceOutput));
                    this.setValueOperations.put(setValueOperationkey, SERVERCOMPUTED_CURRENT_USER_SET_VALUE_OPERATION);
                    break;
                }
                case -10013: {
                    log.trace((Object)MessageFormat.format("{0}ConstServerDateTime", traceOutput));
                    this.setValueOperations.put(setValueOperationkey, SERVERCOMPUTED_DATETIME_SET_VALUE_OPERATION);
                    break;
                }
                case -10031: {
                    log.trace((Object)MessageFormat.format("{0}ConstServerRandomGuid", traceOutput));
                    this.setValueOperations.put(setValueOperationkey, SERVERCOMPUTED_RANDOM_GUID_SET_VALUE_OPERATION);
                    break;
                }
                case -10028: {
                    log.trace((Object)MessageFormat.format("{0}ConstUtcDateTime", traceOutput));
                    this.setValueOperations.put(setValueOperationkey, new Date());
                    break;
                }
                default: {
                    throw new UnhandledSpecialConstantIDException(thenConst, rule, "value providing rule ThenConstID");
                }
            }
        } else {
            String value = this.witContext.getMetadata().getConstantsTable().getConstantByID(thenConst);
            log.trace((Object)MessageFormat.format("{0}constant {1} ({2})", traceOutput, thenConst, value));
            this.setValueOperations.put(setValueOperationkey, value);
        }
    }

    private void runNonDefaultRule(Rule rule) {
        if (rule.getThenFldID() == 0) {
            return;
        }
        if (rule.isFlagDenyWrite()) {
            this.runDenyWriteRule(rule);
        } else if (rule.isFlagSuggestion()) {
            this.runSuggestionRule(rule);
        } else if (rule.isFlagThenHelptext()) {
            this.runHelpTextRule(rule);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runDenyWriteRule(Rule rule) {
        String logRuleEffect;
        block38: {
            boolean allowedValues;
            boolean unless;
            boolean not;
            IRuleTargetField field;
            block37: {
                field = this.target.getRuleTargetField(rule.getThenFldID());
                not = rule.isFlagThenNot();
                unless = rule.isFlagUnless();
                logRuleEffect = "no effect";
                if (!SpecialConstantIDs.isSpecialConstantID(rule.getThenConstID())) break block37;
                switch (rule.getThenConstID()) {
                    case -10000: {
                        boolean empty;
                        boolean bl = empty = field.getValue() == null && field.getServerComputedType() == null;
                        if (not != unless) {
                            if (!empty) {
                                field.setValueFromRule(null);
                                field.setReadOnly(true);
                                logRuleEffect = "cleared value and set readonly true";
                                break;
                            }
                            field.setReadOnly(true);
                            logRuleEffect = "set readonly true";
                            break;
                        }
                        if (not == unless && empty) {
                            this.setInvalidStatus(field, FieldStatus.INVALID_EMPTY);
                            logRuleEffect = "INVALID_EMTPY";
                            break;
                        }
                        break block38;
                    }
                    case -10001: {
                        if (not == unless) throw new UnhandledRuleStateException(rule, "unless==thennot for denywrite ConstSameAsOldValue");
                        field.setReadOnly(true);
                        field.unsetNewValue();
                        logRuleEffect = "unset new value and set readonly true";
                        break;
                    }
                    case -10022: {
                        boolean wasEmpty = field.getOriginalValue() == null;
                        boolean sameAsOldValue = this.isSameAsOldValue(field);
                        boolean wasEmptyOrSameAsOldValue = wasEmpty | sameAsOldValue;
                        if (not == unless) throw new UnhandledRuleStateException(rule, "unless==thennot for denywrite ConstWasEmptyOrSameAsOldValue");
                        if (!wasEmptyOrSameAsOldValue) {
                            this.setInvalidStatus(field, FieldStatus.INVALID_NOT_EMPTY_OR_OLD_VALUE);
                            logRuleEffect = "INVALID_NOT_EMPTY_OR_OLD_VALUE";
                            break;
                        }
                        break block38;
                    }
                    case -10002: {
                        break;
                    }
                    case -10003: {
                        break;
                    }
                    case -10013: {
                        if (field.getValue() == null && field.getServerComputedType() == null) {
                            field.setServerComputed(ServerComputedFieldType.DATE_TIME);
                            break;
                        }
                        break block38;
                    }
                    case -10025: {
                        if (rule.getIf2ConstID() != -10025) {
                            throw new UnhandledRuleStateException(rule, MessageFormat.format("denywrite ConstValueInOtherField rule with If2ConstID={0}", Integer.toString(rule.getIf2ConstID())));
                        }
                        int otherFieldID = rule.getIf2FldID();
                        if (otherFieldID == 0) {
                            throw new UnhandledRuleStateException(rule, MessageFormat.format("denywrite ConstValueInOtherField with If2FldID={0}", Integer.toString(rule.getIf2FldID())));
                        }
                        Object otherFieldValue = this.target.getRuleTargetField(otherFieldID).getValue();
                        Object targetFieldValue = field.getValue();
                        boolean fieldValuesEqual = this.fieldValuesEqual(targetFieldValue, otherFieldValue);
                        if (unless != not) throw new UnhandledRuleStateException(rule, "unless!=thennot for denywrite ConstValueInOtherField");
                        if (fieldValuesEqual) {
                            this.setInvalidStatus(field, FieldStatus.INVALID_VALUE_IN_OTHER_FIELD);
                            logRuleEffect = "INVALID_VALUE_IN_OTHER_FIELD (" + otherFieldID + ")";
                            break;
                        }
                        break block38;
                    }
                    case -10026: {
                        break;
                    }
                    case -10031: {
                        break;
                    }
                    case -10030: {
                        break;
                    }
                    case -10016: {
                        break;
                    }
                    case -10017: {
                        break;
                    }
                    case -10032: {
                        break;
                    }
                    default: {
                        throw new UnhandledSpecialConstantIDException(rule.getThenConstID(), rule, "deny write rule ThenConstID");
                    }
                }
                break block38;
            }
            IConstantSet constantSet = this.getConstantSetFromThenFields(rule);
            boolean bl = allowedValues = unless != not;
            if (!rule.isFlagThenLike()) {
                Set<String> listValues = constantSet.getValues();
                IFieldPickListSupport pickList = field.getPickListSupport();
                if (allowedValues) {
                    pickList.addAllowedValues(listValues);
                    logRuleEffect = "allowed values (" + listValues.size() + ")";
                } else {
                    field.getPickListSupport().addProhibitedValues(listValues);
                    logRuleEffect = "prohibited values (" + listValues.size() + ")";
                }
            }
            if (rule.isFlagThenImplicitEmpty() && field.getValue() == null) {
                logRuleEffect = logRuleEffect + " (no denywrite - ThenImplicitEmpty)";
            } else if (rule.isFlagThenImplicitUnchanged() && this.isSameAsOldValue(field)) {
                logRuleEffect = logRuleEffect + " (no denywrite - ThenImplicitUnchanged)";
            } else if (rule.isFlagThenLike()) {
                if (!allowedValues) {
                    throw new UnhandledRuleStateException(rule, "pattern match unless=" + unless + " thennot=" + not);
                }
                boolean matches = constantSet.patternMatch(field.getValue(), "ruleid:" + rule.getRuleID() + ",fldid:" + rule.getThenFldID());
                if (!matches) {
                    this.setInvalidStatus(field, FieldStatus.INVALID_FORMAT);
                    logRuleEffect = "INVALID_FORMAT";
                } else {
                    logRuleEffect = logRuleEffect + " (pattern matches)";
                }
            } else {
                boolean valueInList;
                Object fieldValue = field.getValue();
                String fieldValueAsString = this.translateFieldValueIntoString(field.getValue());
                boolean bl2 = valueInList = fieldValue != null && fieldValueAsString != null && constantSet.contains(fieldValueAsString);
                if (allowedValues && !valueInList || !allowedValues && valueInList) {
                    this.setInvalidStatus(field, FieldStatus.INVALID_LIST_VALUE);
                    logRuleEffect = logRuleEffect + ", INVALID_LIST_VALUE";
                } else {
                    logRuleEffect = logRuleEffect + " (no denywrite effect - value " + (valueInList ? "is" : "is not") + " in list)";
                }
            }
        }
        log.trace((Object)MessageFormat.format("applied DW rule [{0}] in area [{1}] to field [{2}]: {3}", Integer.toString(rule.getRuleID()), Integer.toString(rule.getAreaID()), this.getFieldNameForTrace(rule.getThenFldID()), logRuleEffect));
    }

    private void runSuggestionRule(Rule rule) {
        IRuleTargetField field = this.target.getRuleTargetField(rule.getThenFldID());
        IConstantSet constantSet = this.getConstantSetFromThenFields(rule);
        field.getPickListSupport().addSuggestedValues(constantSet.getValues());
        log.trace((Object)MessageFormat.format("applied SG rule [{0}] to field [{1}]", Integer.toString(rule.getRuleID()), Integer.toString(rule.getThenFldID())));
    }

    private void runHelpTextRule(Rule rule) {
        try {
            int fieldId = rule.getThenFldID();
            int constId = rule.getThenConstID();
            String helpText = this.witContext.getMetadata().getConstantsTable().getConstantByID(constId);
            log.trace((Object)MessageFormat.format("applying HelpText rule [{0}] to field [{1}]", Integer.toString(rule.getRuleID()), this.getFieldNameForTrace(fieldId)));
            IRuleTargetField field = this.target.getRuleTargetField(fieldId);
            field.setHelpText(helpText);
        }
        catch (Exception e) {
            log.error((Object)"Exception running help-text rule", (Throwable)e);
        }
    }

    private boolean isRuleInScope(Rule rule) {
        return this.passesConditionTest(rule.getFld1ID(), rule.getFld1IsConstID(), rule.getFld1WasConstID(), rule, "Fld1") && this.passesConditionTest(rule.getFld2ID(), rule.getFld2IsConstID(), rule.getFld2WasConstID(), rule, "Fld2") && this.passesConditionTest(rule.getFld3ID(), rule.getFld3IsConstID(), rule.getFld3WasConstID(), rule, "Fld3") && this.passesConditionTest(rule.getFld4ID(), rule.getFld4IsConstID(), rule.getFld4WasConstID(), rule, "Fld4") && this.passesIf1Test(rule.getIfFldID(), rule.getIfConstID(), rule.isFlagIfNot(), rule) && this.passesIf2Test(rule.getIf2FldID(), rule.getIf2ConstID(), rule.isFlagIf2Not(), rule);
    }

    private boolean passesConditionTest(int fieldId, int isConstid, int wasConstId, Rule rule, String type) {
        if (fieldId == 0) {
            return true;
        }
        IRuleTargetField field = this.target.getRuleTargetField(fieldId);
        if (isConstid != 0) {
            Object fieldValue = field.getValue();
            Integer setValueOperationsId = new Integer(fieldId);
            if (this.setValueOperations.containsKey(setValueOperationsId)) {
                fieldValue = this.setValueOperations.get(setValueOperationsId);
            }
            if (!this.passesIsOrWasConditionTest(fieldValue, isConstid, rule, type + "IsConstID")) {
                return false;
            }
        }
        return wasConstId == 0 || this.passesIsOrWasConditionTest(field.getOriginalValue(), wasConstId, rule, type + "WasConstID");
    }

    private boolean passesIsOrWasConditionTest(Object fieldValue, int constId, Rule rule, String type) {
        block6: {
            block5: {
                if (!SpecialConstantIDs.isSpecialConstantID(constId)) break block5;
                switch (constId) {
                    case -10000: {
                        if (fieldValue != null) {
                            return false;
                        }
                        break block6;
                    }
                    default: {
                        throw new UnhandledSpecialConstantIDException(constId, rule, type);
                    }
                }
            }
            if (!this.fieldValueEqualToConstant(fieldValue, constId)) {
                return false;
            }
        }
        return true;
    }

    private boolean passesIf2Test(int fieldId, int constId, boolean not, Rule rule) {
        block9: {
            block8: {
                if (fieldId == 0) {
                    return true;
                }
                IRuleTargetField field = this.target.getRuleTargetField(fieldId);
                if (!SpecialConstantIDs.isSpecialConstantID(constId)) break block8;
                switch (constId) {
                    case -10000: {
                        boolean empty;
                        boolean bl = empty = field.getValue() == null;
                        if (not == empty) {
                            return false;
                        }
                        break block9;
                    }
                    case -10006: {
                        boolean empty2;
                        boolean bl = empty2 = field.getOriginalValue() == null;
                        if (not == empty2) {
                            return false;
                        }
                        break block9;
                    }
                    case -10025: 
                    case -10012: {
                        break;
                    }
                    default: {
                        throw new UnhandledSpecialConstantIDException(constId, rule, "If2ConstId");
                    }
                }
                break block9;
            }
            throw new UnhandledRuleStateException(rule, "If2 with a non special constant id (" + constId + ")");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean passesIf1Test(int fieldId, int constId, boolean not, Rule rule) {
        if (fieldId == 0) {
            return true;
        }
        IRuleTargetField field = this.target.getRuleTargetField(fieldId);
        if (SpecialConstantIDs.isSpecialConstantID(constId)) {
            switch (constId) {
                case -10001: {
                    boolean sameAsOldValue = this.isSameAsOldValue(field);
                    if (not != sameAsOldValue) return true;
                    return false;
                }
                case -10000: {
                    boolean empty;
                    boolean bl = empty = field.getValue() == null;
                    if (not != empty) return true;
                    return false;
                }
                case -10014: {
                    boolean becameNonEmpty;
                    if (field.getOriginalValue() != null) return true;
                    boolean bl = becameNonEmpty = field.getValue() != null;
                    if (not != becameNonEmpty) return true;
                    return false;
                }
                case -10015: {
                    boolean remainedNonEmpty;
                    if (field.getOriginalValue() == null) return false;
                    boolean bl = remainedNonEmpty = field.getValue() != null;
                    if (not != remainedNonEmpty) return true;
                    return false;
                }
                case -10006: {
                    boolean empty2;
                    boolean bl = empty2 = field.getOriginalValue() == null;
                    if (not != empty2) return true;
                    return false;
                }
                default: {
                    throw new UnhandledSpecialConstantIDException(constId, rule, "IfConstId");
                }
            }
        }
        boolean equal = this.fieldValueEqualToConstant(field.getValue(), constId);
        if (not != equal) return true;
        return false;
    }

    private boolean fieldValueEqualToConstant(Object fieldValue, int constantId) {
        if (fieldValue == null) {
            return false;
        }
        String fieldValueAsString = this.translateFieldValueIntoString(fieldValue);
        if (fieldValueAsString == null) {
            return false;
        }
        String constantValue = this.witContext.getMetadata().getConstantsTable().getConstantByID(constantId);
        return constantValue.equalsIgnoreCase(fieldValueAsString);
    }

    private boolean fieldValuesEqual(Object fieldValue1, Object fieldValue2) {
        if (fieldValue1 == null) {
            return fieldValue2 == null;
        }
        if (fieldValue1 instanceof String && fieldValue2 instanceof String) {
            String s1 = (String)fieldValue1;
            String s2 = (String)fieldValue2;
            return s1.equalsIgnoreCase(s2);
        }
        return fieldValue1.equals(fieldValue2);
    }

    private String translateFieldValueIntoString(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof Integer) {
            return ((Integer)input).toString();
        }
        if (input instanceof Double) {
            return WorkItemUtils.doubleToString((Double)input);
        }
        if (input instanceof GUID) {
            return ((GUID)input).getGUIDString();
        }
        return null;
    }

    private boolean isSameAsOldValue(IRuleTargetField field) {
        boolean sameAsOldValue;
        boolean bl = sameAsOldValue = !field.isNewValueSet();
        if (!sameAsOldValue && field.getServerComputedType() == null) {
            sameAsOldValue = this.fieldValuesEqual(field.getOriginalValue(), field.getValue());
        }
        return sameAsOldValue;
    }

    private IConstantSet getConstantSetFromThenFields(Rule rule) {
        return this.witContext.getMetadata().getConstantHandler().getConstantSet(rule.getThenConstID(), rule.isFlagThenOneLevel(), rule.isFlagThenTwoPlusLevels(), rule.isFlagThenLeaf(), rule.isFlagThenInterior(), true);
    }

    private void setInvalidStatus(IRuleTargetField field, FieldStatus status) {
        if (field.isEditable()) {
            field.setStatus(status);
        }
    }

    private String getFieldNameForTrace(Integer fieldId) {
        try {
            return ((FieldImpl)this.target.getRuleTargetField(fieldId)).getReferenceName();
        }
        catch (Exception e) {
            return fieldId.toString();
        }
    }
}

