/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools.internal;

import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PlistHandler
extends DefaultHandler {
    private static final String APPLE_PLIST_ID = "http://www.apple.com/DTDs/PropertyList-1.0.dtd";
    private static final String APPLE_PLIST_DTD = "<!ENTITY % plistObject \"(array | data | date | dict | real | integer | string | true | false )\" ><!ELEMENT plist %plistObject;><!ATTLIST plist version CDATA \"1.0\" ><!ELEMENT array (%plistObject;)*><!ELEMENT dict (key, %plistObject;)*><!ELEMENT key (#PCDATA)><!ELEMENT string (#PCDATA)><!ELEMENT data (#PCDATA)><!ELEMENT date (#PCDATA)><!ELEMENT true EMPTY><!ELEMENT false EMPTY><!ELEMENT real (#PCDATA)><!ELEMENT integer (#PCDATA)>";
    private Object plist;
    protected ArrayList currentHierarchy = new ArrayList();
    private String currentTag;
    private StringBuffer currentData;
    private String currentKey;

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (qualifiedName.equals("plist")) {
            if (this.plist != null) {
                throw new SAXException("Invalid plist (second plist tag)");
            }
            this.currentData = null;
        } else if (qualifiedName.equals("dict")) {
            HashMap dict = new HashMap();
            if (this.plist == null) {
                this.plist = dict;
            }
            this.currentHierarchy.add(dict);
            this.currentData = null;
        } else if (qualifiedName.equals("array")) {
            ArrayList array = new ArrayList();
            if (this.plist == null) {
                this.plist = array;
            }
            this.currentHierarchy.add(array);
            this.currentData = null;
        } else if (qualifiedName.equals("key") || qualifiedName.equals("string") || qualifiedName.equals("integer") || qualifiedName.equals("real")) {
            this.currentData = new StringBuffer();
        } else if (qualifiedName.equals("true") || qualifiedName.equals("false")) {
            this.currentData = null;
        } else {
            throw new SAXException(MessageFormat.format("Unknown type: {0}", qualifiedName));
        }
        this.currentTag = qualifiedName;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        this.endElementSanityCheck(qualifiedName);
        if (!qualifiedName.equals("plist")) {
            if (qualifiedName.equals("key")) {
                this.currentKey = this.currentData.toString();
            } else {
                if (qualifiedName.equals("array") || qualifiedName.equals("dict")) {
                    this.currentHierarchy.remove(this.currentHierarchy.size() - 1);
                } else if (qualifiedName.equals("true")) {
                    this.add(Boolean.TRUE);
                } else if (qualifiedName.equals("false")) {
                    this.add(Boolean.FALSE);
                } else {
                    String data = this.currentData.toString();
                    if (qualifiedName.equals("string")) {
                        this.add(data);
                    } else if (qualifiedName.equals("integer")) {
                        this.add(new Integer(Integer.parseInt(data)));
                    } else if (qualifiedName.equals("real")) {
                        this.add(new Float(Float.parseFloat(data)));
                    }
                }
                this.currentKey = null;
            }
        }
        this.currentTag = null;
        this.currentData = null;
    }

    private void endElementSanityCheck(String element) throws SAXException {
        if (element.equals("array")) {
            Object current = this.currentHierarchy.get(this.currentHierarchy.size() - 1);
            if (!(current instanceof List)) {
                throw new SAXException(MessageFormat.format("Unexpected end element: {0}", element));
            }
        } else if (element.equals("dict")) {
            Object dict = this.currentHierarchy.get(this.currentHierarchy.size() - 1);
            if (!(dict instanceof Map)) {
                throw new SAXException(MessageFormat.format("Unexpected end element: {0}", element));
            }
        } else if (element.equals("key") || element.equals("string") || element.equals("integer") || element.equals("real")) {
            if (!this.currentTag.equals(element) || this.currentData == null) {
                throw new SAXException(MessageFormat.format("Unexpected end element: {0}", element));
            }
        } else if (!(!element.equals("true") && !element.equals("false") || this.currentTag.equals(element) && this.currentData == null)) {
            throw new SAXException(MessageFormat.format("Unexpected element: {0}", element));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentData == null) {
            throw new SAXException(MessageFormat.format("Unexpected character data in {0} tag", this.currentTag));
        }
        for (int i = start; i < start + length; ++i) {
            this.currentData.append(ch[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void add(Object obj) throws SAXException {
        if (this.currentHierarchy.size() > 0) {
            Object struct = this.currentHierarchy.get(this.currentHierarchy.size() - 1);
            if (struct instanceof List) {
                ((List)struct).add(obj);
                return;
            } else {
                if (!(struct instanceof Map)) throw new SAXException(MessageFormat.format("Attempt to add to simple structure: {0}", obj.toString()));
                ((Map)struct).put(this.currentKey, obj);
            }
            return;
        } else {
            this.plist = obj;
        }
    }

    public Object getPlist() {
        return this.plist;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (APPLE_PLIST_ID.equals(systemId)) {
            return new InputSource(new StringReader(APPLE_PLIST_DTD));
        }
        return null;
    }
}

