/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.CircularRedirectException;
import com.microsoft.tfs.core.httpclient.ConnectMethod;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HostConfiguration;
import com.microsoft.tfs.core.httpclient.HttpConnection;
import com.microsoft.tfs.core.httpclient.HttpConnectionManager;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.HttpMethodBase;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.InvalidRedirectLocationException;
import com.microsoft.tfs.core.httpclient.JwtCredentials;
import com.microsoft.tfs.core.httpclient.RedirectException;
import com.microsoft.tfs.core.httpclient.URI;
import com.microsoft.tfs.core.httpclient.URIException;
import com.microsoft.tfs.core.httpclient.auth.AuthChallengeException;
import com.microsoft.tfs.core.httpclient.auth.AuthChallengeParser;
import com.microsoft.tfs.core.httpclient.auth.AuthChallengeProcessor;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthState;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.CredentialsNotAvailableException;
import com.microsoft.tfs.core.httpclient.auth.CredentialsProvider;
import com.microsoft.tfs.core.httpclient.auth.JwtAuthScheme;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import com.microsoft.tfs.core.httpclient.auth.PreemptiveBasicScheme;
import com.microsoft.tfs.core.httpclient.params.HttpClientParams;
import com.microsoft.tfs.core.httpclient.params.HttpParams;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HttpMethodDirector {
    private static final Log LOG = LogFactory.getLog(HttpMethodDirector.class);
    private ConnectMethod connectMethod;
    private final HttpState state;
    private final HostConfiguration hostConfiguration;
    private final HttpConnectionManager connectionManager;
    private final HttpClientParams params;
    private HttpConnection conn;
    private boolean releaseConnection = false;
    private AuthChallengeProcessor authProcessor = null;
    private Set redirectLocations = null;

    public HttpMethodDirector(HttpConnectionManager connectionManager, HostConfiguration hostConfiguration, HttpClientParams params, HttpState state) {
        this.connectionManager = connectionManager;
        this.hostConfiguration = hostConfiguration;
        this.params = params;
        this.state = state;
        this.authProcessor = new AuthChallengeProcessor(this.params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMethod(HttpMethod method) throws IOException, HttpException {
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        this.hostConfiguration.getParams().setDefaults(this.params);
        method.getParams().setDefaults(this.hostConfiguration.getParams());
        Collection defaults = (Collection)this.hostConfiguration.getParams().getParameter("http.default-headers");
        if (defaults != null) {
            Iterator i = defaults.iterator();
            while (i.hasNext()) {
                method.addRequestHeader((Header)i.next());
            }
        }
        try {
            int maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
            int redirectCount = 0;
            while (true) {
                if (this.conn != null && !this.hostConfiguration.hostEquals(this.conn)) {
                    this.conn.setLocked(false);
                    this.conn.releaseConnection();
                    this.conn = null;
                }
                if (this.conn == null) {
                    this.conn = this.connectionManager.getConnectionWithTimeout(this.hostConfiguration, this.params.getConnectionManagerTimeout());
                    this.conn.setLocked(true);
                    Credentials preemptiveCredentials = this.getPreemptiveCredentials(this.conn.getHost(), this.conn.getPort());
                    if (preemptiveCredentials != null && method.getDoAuthentication()) {
                        method.getHostAuthState().setPreemptive(preemptiveCredentials);
                        method.getHostAuthState().setAuthAttempted(true);
                        if (preemptiveCredentials instanceof JwtCredentials) {
                            method.getHostAuthState().setAuthScheme(new JwtAuthScheme());
                        } else {
                            method.getHostAuthState().setAuthScheme(new PreemptiveBasicScheme());
                        }
                    }
                }
                if (method.getDoAuthentication()) {
                    this.authenticate(method);
                }
                this.executeWithRetry(method);
                if (this.connectMethod != null) {
                    this.fakeResponse(method);
                    break;
                }
                boolean retry = false;
                if (this.isRedirectNeeded(method) && this.processRedirectResponse(method)) {
                    retry = true;
                    if (++redirectCount >= maxRedirects) {
                        LOG.error((Object)"Narrowly avoided an infinite loop in execute");
                        throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Execute redirect " + redirectCount + " of " + maxRedirects));
                    }
                }
                if (this.isAuthenticationNeeded(method) && this.processAuthenticationResponse(method)) {
                    LOG.debug((Object)"Retry authentication");
                    retry = true;
                }
                if (!retry) {
                    break;
                }
                if (method.getResponseBodyAsStream() == null) continue;
                method.getResponseBodyAsStream().close();
            }
        }
        finally {
            this.cleanupHostAndProxyAuthState(method);
            if (this.conn != null) {
                this.conn.setLocked(false);
            }
            if ((this.releaseConnection || method.getResponseBodyAsStream() == null) && this.conn != null) {
                this.conn.releaseConnection();
            }
        }
    }

    private void cleanupHostAndProxyAuthState(HttpMethod method) {
        this.cleanupAuthState(method.getHostAuthState());
        this.cleanupAuthState(method.getProxyAuthState());
    }

    private void cleanupAuthState(AuthState authState) {
        if (authState != null) {
            authState.invalidate();
        }
    }

    private Credentials getPreemptiveCredentials(String host, int port) {
        if (host == null) {
            return null;
        }
        Class[] preemptiveTypes = this.params.getPreemptiveAuthenticationTypes();
        if (preemptiveTypes == null) {
            return null;
        }
        AuthScope authScope = new AuthScope(host, port);
        LOG.debug((Object)("Examining preemptive credentials for " + host + ":" + port));
        Credentials credentials = this.state.getCredentials(authScope);
        if (credentials == null) {
            return null;
        }
        for (int i = 0; i < preemptiveTypes.length; ++i) {
            if (!preemptiveTypes[i].isInstance(credentials)) continue;
            return credentials;
        }
        return null;
    }

    private void authenticate(HttpMethod method) {
        try {
            if (this.conn.isProxied() && !this.conn.isSecure()) {
                this.authenticateProxy(method);
            }
            this.authenticateHost(method);
        }
        catch (AuthenticationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean cleanAuthHeaders(HttpMethod method, String name) {
        Header[] authheaders = method.getRequestHeaders(name);
        boolean clean = true;
        for (int i = 0; i < authheaders.length; ++i) {
            Header authheader = authheaders[i];
            if (authheader.isAutogenerated()) {
                method.removeRequestHeader(authheader);
                continue;
            }
            clean = false;
        }
        return clean;
    }

    private void authenticateHost(HttpMethod method) throws AuthenticationException {
        if (!this.cleanAuthHeaders(method, "Authorization")) {
            return;
        }
        AuthState authstate = method.getHostAuthState();
        AuthScheme authscheme = authstate.getAuthScheme();
        if (authscheme == null) {
            return;
        }
        if (authstate.isAuthRequested() || !authscheme.isConnectionBased()) {
            Credentials credentials;
            String host = method.getParams().getVirtualHost();
            if (host == null) {
                host = this.conn.getHost();
            }
            int port = this.conn.getPort();
            AuthScope authscope = new AuthScope(host, port, authscheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + authscope));
            }
            if ((credentials = this.state.getCredentials(authscope)) != null) {
                authscheme.authenticateHost(authscope, credentials, this.state, method);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Required credentials not available for " + authscope));
                if (method.getHostAuthState().isPreemptive()) {
                    LOG.warn((Object)"Preemptive authentication requested but no default credentials available");
                }
            }
        }
    }

    private void authenticateProxy(HttpMethod method) throws AuthenticationException {
        if (!this.cleanAuthHeaders(method, "Proxy-Authorization")) {
            return;
        }
        AuthState authstate = method.getProxyAuthState();
        AuthScheme authscheme = authstate.getAuthScheme();
        if (authscheme == null) {
            return;
        }
        if (authstate.isAuthRequested() || !authscheme.isConnectionBased()) {
            Credentials credentials;
            AuthScope authscope = new AuthScope(this.conn.getProxyHost(), this.conn.getProxyPort(), authscheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + authscope));
            }
            if ((credentials = this.state.getProxyCredentials(authscope)) != null && authscheme.supportsCredentials(credentials)) {
                authscheme.authenticateProxy(authscope, credentials, this.state, method);
            } else if (method.getProxyAuthState().isPreemptive()) {
                LOG.debug((Object)"Preemptive authentication requested but no default proxy credentials available");
            } else {
                LOG.warn((Object)("Required proxy credentials not available for " + authscope));
            }
        }
    }

    private void applyConnectionParams(HttpMethod method) throws IOException {
        int timeout = 0;
        Object param = method.getParams().getParameter("http.socket.timeout");
        if (param == null) {
            param = this.conn.getParams().getParameter("http.socket.timeout");
        }
        if (param != null) {
            timeout = (Integer)param;
        }
        this.conn.setSocketTimeout(timeout);
    }

    /*
     * Exception decompiling
     */
    private void executeWithRetry(HttpMethod method) throws IOException, HttpException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean executeConnect() throws IOException, HttpException {
        int code;
        this.connectMethod = new ConnectMethod(this.hostConfiguration);
        this.connectMethod.getParams().setDefaults(this.hostConfiguration.getParams());
        while (true) {
            if (!this.conn.isOpen()) {
                this.conn.open();
            }
            try {
                this.authenticateProxy(this.connectMethod);
            }
            catch (AuthenticationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            this.applyConnectionParams(this.connectMethod);
            this.connectMethod.execute(this.state, this.conn);
            code = this.connectMethod.getStatusCode();
            boolean retry = false;
            AuthState authstate = this.connectMethod.getProxyAuthState();
            authstate.setAuthRequested(code == 407);
            if (authstate.isAuthRequested() && this.processAuthenticationResponse(this.connectMethod)) {
                retry = true;
            }
            if (!retry) break;
            if (this.connectMethod.getResponseBodyAsStream() == null) continue;
            this.connectMethod.getResponseBodyAsStream().close();
        }
        if (code >= 200 && code < 300) {
            this.conn.tunnelCreated();
            this.connectMethod = null;
            return true;
        }
        this.conn.close();
        return false;
    }

    private void fakeResponse(HttpMethod method) throws IOException, HttpException {
        LOG.debug((Object)"CONNECT failed, fake the response for the original method");
        if (method instanceof HttpMethodBase) {
            ((HttpMethodBase)method).fakeResponse(this.connectMethod.getStatusLine(), this.connectMethod.getResponseHeaderGroup(), this.connectMethod.getResponseBodyAsStream());
            method.getProxyAuthState().setAuthScheme(this.connectMethod.getProxyAuthState().getAuthScheme());
            this.connectMethod = null;
        } else {
            this.releaseConnection = true;
            LOG.warn((Object)"Unable to fake response on method as it is not derived from HttpMethodBase.");
        }
    }

    private boolean processRedirectResponse(HttpMethod method) throws RedirectException {
        Header locationHeader = method.getResponseHeader("location");
        if (locationHeader == null) {
            LOG.error((Object)("Received redirect response " + method.getStatusCode() + " but no location header"));
            return false;
        }
        String location = locationHeader.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        URI redirectUri = null;
        URI currentUri = null;
        try {
            currentUri = new URI(this.conn.getProtocol().getScheme(), null, this.conn.getHost(), this.conn.getPort(), method.getPath());
            String charset = method.getParams().getUriCharset();
            redirectUri = new URI(location, true, charset);
            if (redirectUri.isRelativeURI()) {
                if (this.params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                    LOG.warn((Object)("Relative redirect location '" + location + "' not allowed"));
                    return false;
                }
                LOG.debug((Object)"Redirect URI is not absolute - parsing as relative");
                redirectUri = new URI(currentUri, redirectUri);
            } else {
                method.getParams().setDefaults(this.params);
            }
            method.setURI(redirectUri);
            this.hostConfiguration.setHost(redirectUri);
        }
        catch (URIException ex) {
            throw new InvalidRedirectLocationException("Invalid redirect location: " + location, location, ex);
        }
        if (this.params.isParameterFalse("http.protocol.allow-circular-redirects")) {
            if (this.redirectLocations == null) {
                this.redirectLocations = new HashSet();
            }
            this.redirectLocations.add(currentUri);
            try {
                if (redirectUri.hasQuery()) {
                    redirectUri.setQuery(null);
                }
            }
            catch (URIException e) {
                return false;
            }
            if (this.redirectLocations.contains(redirectUri)) {
                throw new CircularRedirectException("Circular redirect to '" + redirectUri + "'");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting from '" + currentUri.getEscapedURI() + "' to '" + redirectUri.getEscapedURI()));
        }
        method.getHostAuthState().invalidate();
        return true;
    }

    private boolean processAuthenticationResponse(HttpMethod method) {
        LOG.trace((Object)"enter HttpMethodBase.processAuthenticationResponse(HttpState, HttpConnection)");
        try {
            switch (method.getStatusCode()) {
                case 401: {
                    return this.processWWWAuthChallenge(method);
                }
                case 407: {
                    return this.processProxyAuthChallenge(method);
                }
            }
            return false;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private boolean processWWWAuthChallenge(HttpMethod method) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authscheme;
        AuthState authstate;
        block12: {
            authstate = method.getHostAuthState();
            Map<String, String> challenges = AuthChallengeParser.parseChallenges(method.getResponseHeaders("WWW-Authenticate"));
            if (challenges.isEmpty()) {
                LOG.debug((Object)"Authentication challenge(s) not found");
                return false;
            }
            Credentials globalCredentials = this.state.getCredentials(AuthScope.ANY);
            authscheme = null;
            try {
                authscheme = this.authProcessor.processChallenge(authstate, challenges, globalCredentials);
            }
            catch (AuthChallengeException e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (authscheme == null) {
            return false;
        }
        String host = method.getParams().getVirtualHost();
        if (host == null) {
            host = this.conn.getHost();
        }
        int port = this.conn.getPort();
        AuthScope authscope = new AuthScope(host, port, authscheme.getSchemeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Authentication scope: " + authscope));
        }
        if (authstate.isAuthAttempted() && authscheme.isComplete()) {
            Credentials credentials = this.promptForCredentials(authscheme, method.getParams(), authscope);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + authscope));
                }
                return false;
            }
            return true;
        }
        authstate.setAuthAttempted(true);
        Credentials credentials = this.state.getCredentials(authscope);
        if (credentials == null) {
            credentials = this.promptForCredentials(authscheme, method.getParams(), authscope);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No credentials available for " + authscope));
            }
            return false;
        }
        return true;
    }

    private boolean processProxyAuthChallenge(HttpMethod method) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authscheme;
        AuthState authstate;
        block11: {
            authstate = method.getProxyAuthState();
            Map<String, String> proxyChallenges = AuthChallengeParser.parseChallenges(method.getResponseHeaders("Proxy-Authenticate"));
            if (proxyChallenges.isEmpty()) {
                LOG.debug((Object)"Proxy authentication challenge(s) not found");
                return false;
            }
            authscheme = null;
            try {
                authscheme = this.authProcessor.processChallenge(authstate, proxyChallenges);
            }
            catch (AuthChallengeException e) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (authscheme == null) {
            return false;
        }
        AuthScope authscope = new AuthScope(this.conn.getProxyHost(), this.conn.getProxyPort(), authscheme.getSchemeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Proxy authentication scope: " + authscope));
        }
        if (authstate.isAuthAttempted() && authscheme.isComplete()) {
            Credentials credentials = this.promptForProxyCredentials(authscheme, method.getParams(), authscope);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + authscope));
                }
                return false;
            }
            return true;
        }
        authstate.setAuthAttempted(true);
        Credentials credentials = this.state.getProxyCredentials(authscope);
        if (credentials == null) {
            credentials = this.promptForProxyCredentials(authscheme, method.getParams(), authscope);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No credentials available for " + authscope));
            }
            return false;
        }
        return true;
    }

    private boolean isRedirectNeeded(HttpMethod method) {
        switch (method.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                LOG.debug((Object)"Redirect required");
                return method.getFollowRedirects();
            }
        }
        return false;
    }

    private boolean isAuthenticationNeeded(HttpMethod method) {
        method.getHostAuthState().setAuthRequested(method.getStatusCode() == 401);
        method.getProxyAuthState().setAuthRequested(method.getStatusCode() == 407);
        if (method.getHostAuthState().isAuthRequested() || method.getProxyAuthState().isAuthRequested()) {
            LOG.debug((Object)"Authorization required");
            if (method.getDoAuthentication()) {
                return true;
            }
            LOG.info((Object)"Authentication requested but doAuthentication is disabled");
            return false;
        }
        return false;
    }

    private Credentials promptForCredentials(AuthScheme authScheme, HttpParams params, AuthScope authscope) {
        LOG.debug((Object)"Credentials required");
        Credentials creds = null;
        CredentialsProvider credProvider = (CredentialsProvider)params.getParameter("http.authentication.credential-provider");
        if (credProvider != null) {
            try {
                creds = credProvider.getCredentials(authScheme, authscope.getHost(), authscope.getPort(), false);
            }
            catch (CredentialsNotAvailableException e) {
                LOG.warn((Object)e.getMessage());
            }
            if (creds != null) {
                this.state.setCredentials(authscope, creds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(authscope + " new credentials given"));
                }
            }
        } else {
            LOG.debug((Object)"Credentials provider not available");
        }
        return creds;
    }

    private Credentials promptForProxyCredentials(AuthScheme authScheme, HttpParams params, AuthScope authscope) {
        LOG.debug((Object)"Proxy credentials required");
        Credentials creds = null;
        CredentialsProvider credProvider = (CredentialsProvider)params.getParameter("http.authentication.credential-provider");
        if (credProvider != null) {
            try {
                creds = credProvider.getCredentials(authScheme, authscope.getHost(), authscope.getPort(), true);
            }
            catch (CredentialsNotAvailableException e) {
                LOG.warn((Object)e.getMessage());
            }
            if (creds != null) {
                this.state.setProxyCredentials(authscope, creds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(authscope + " new credentials given"));
                }
            }
        } else {
            LOG.debug((Object)"Proxy credentials provider not available");
        }
        return creds;
    }

    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public HttpState getState() {
        return this.state;
    }

    public HttpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public HttpParams getParams() {
        return this.params;
    }
}

