/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FileTypeDescription {
    private static final String MESSAGES_PREFIX = "FileTypeDescription.DYNAMIC.";
    private static final String WINDOWS_SUFFIX = ".Windows";
    private static final String UNIX_SUFFIX = ".Unix";
    private static Map<String, String> fileTypeMap = new HashMap<String, String>();

    private FileTypeDescription() {
    }

    public static String getDescription(String filename) {
        int pos = filename.lastIndexOf(46);
        if (pos >= 0 && pos < filename.length() - 1) {
            String extension = filename.substring(pos + 1).toUpperCase(Locale.ENGLISH);
            if (fileTypeMap.containsKey(extension)) {
                return fileTypeMap.get(extension);
            }
            return MessageFormat.format(Messages.getString("FileTypeDescription.TypeFormat"), extension);
        }
        return Messages.getString("FileTypeDescription.GenericFile");
    }

    static {
        Enumeration<String> keys = Messages.getResourceBundle().getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(MESSAGES_PREFIX)) continue;
            String extension = key.substring(MESSAGES_PREFIX.length());
            String description = Messages.getString(key);
            if (extension.endsWith(WINDOWS_SUFFIX)) {
                extension = extension.substring(0, extension.length() - WINDOWS_SUFFIX.length());
                if (Platform.isCurrentPlatform(Platform.GENERIC_UNIX)) {
                    description = MessageFormat.format(Messages.getString("FileTypeDescription.WindowsDescriptionFormat"), description);
                }
            } else if (extension.endsWith(UNIX_SUFFIX)) {
                extension = extension.substring(0, extension.length() - UNIX_SUFFIX.length());
                if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
                    description = MessageFormat.format(Messages.getString("FileTypeDescription.UnixDescriptionFormat"), description);
                }
            }
            fileTypeMap.put(extension, description);
        }
    }
}

