/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.json;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.json.JSONObject;
import com.microsoft.tfs.util.json.JSONParseException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class JSONEncoder {
    private static final String JSON_NULL = "null";
    private static final Map<Character, Character> ENCODE_CHAR_ESCAPES = new HashMap<Character, Character>();
    private static final Map<Character, Character> DECODE_CHAR_ESCAPES = new HashMap<Character, Character>();

    public static String encodeObject(JSONObject object) {
        Check.notNull(object, "object");
        StringBuilder encoded = new StringBuilder("{");
        int i = 0;
        for (Map.Entry<String, String> entry : object.entrySet()) {
            if (i++ > 0) {
                encoded.append(',');
            }
            String key = entry.getKey();
            String value = entry.getValue();
            encoded.append(JSONEncoder.encodeString(key));
            encoded.append(':');
            if (value == null) {
                encoded.append(JSON_NULL);
                continue;
            }
            encoded.append(JSONEncoder.encodeString(entry.getValue()));
        }
        encoded.append("}");
        return encoded.toString();
    }

    public static JSONObject decodeObject(String s) {
        return JSONEncoder.decodeObject(s, null);
    }

    public static JSONObject decodeObject(String s, AtomicInteger charsRead) {
        Check.notNull(s, "s");
        JSONObject decoded = new JSONObject();
        ObjectParseState state = ObjectParseState.START;
        String memberName = null;
        int length = s.length();
        int i = 0;
        while (i < length && state != ObjectParseState.DONE) {
            int codePoint = s.codePointAt(i);
            char c = (char)codePoint;
            boolean advance = true;
            switch (state) {
                case START: {
                    if (Character.isWhitespace(codePoint)) break;
                    if (c == '{') {
                        state = ObjectParseState.MEMBERS;
                        break;
                    }
                    throw new JSONParseException(Messages.getString("JSONEncoder.StringMustStartWithCurlyBrace"));
                }
                case MEMBERS: {
                    if (Character.isWhitespace(codePoint) || c == ',') break;
                    if (c == '}') {
                        state = ObjectParseState.DONE;
                        break;
                    }
                    if (c == '\"') {
                        AtomicInteger nameCharsRead = new AtomicInteger();
                        memberName = JSONEncoder.decodeString(s.substring(i), nameCharsRead);
                        if (memberName == null) {
                            throw new JSONParseException(Messages.getString("JSONEncoder.MemberNameCannotBeNull"));
                        }
                        advance = false;
                        i += nameCharsRead.get();
                        state = ObjectParseState.MEMBER_NAME_SEPARATOR;
                        break;
                    }
                    throw new JSONParseException(MessageFormat.format(Messages.getString("JSONEncoder.UnexpectedCharacterReadingMembersFormat"), Character.valueOf(c)));
                }
                case MEMBER_NAME_SEPARATOR: {
                    if (Character.isWhitespace(codePoint)) break;
                    if (c == ':') {
                        state = ObjectParseState.MEMBER_VALUE;
                        break;
                    }
                    throw new JSONParseException(MessageFormat.format(Messages.getString("JSONEncoder.UnexpectedCharacterReadingNameValueSeparatorFormat"), Character.valueOf(c)));
                }
                case MEMBER_VALUE: {
                    if (Character.isWhitespace(codePoint)) break;
                    if (s.startsWith(JSON_NULL, i)) {
                        decoded.put(memberName, null);
                        memberName = null;
                        advance = false;
                        i += JSON_NULL.length();
                        state = ObjectParseState.MEMBERS;
                        break;
                    }
                    if (c == '\"') {
                        AtomicInteger valueCharsRead = new AtomicInteger();
                        decoded.put(memberName, JSONEncoder.decodeString(s.substring(i), valueCharsRead));
                        memberName = null;
                        advance = false;
                        i += valueCharsRead.get();
                        state = ObjectParseState.MEMBERS;
                        break;
                    }
                    throw new JSONParseException(MessageFormat.format(Messages.getString("JSONEncoder.UnexpectedCharacterReadingMemberValueFormat"), Character.valueOf(c)));
                }
                default: {
                    throw new JSONParseException(MessageFormat.format("Unknown parse state {0}", new Object[]{state}));
                }
            }
            if (!advance) continue;
            i += Character.charCount(codePoint);
        }
        switch (state) {
            case START: {
                throw new JSONParseException(Messages.getString("JSONEncoder.StringMustStartWithCurlyBrace"));
            }
            case MEMBERS: {
                throw new JSONParseException(Messages.getString("JSONEncoder.StringMustEndWithCurlyBrace"));
            }
            case MEMBER_NAME_SEPARATOR: {
                throw new JSONParseException(Messages.getString("JSONEncoder.StringEndedBeforeMemberValueCouldBeRead"));
            }
            case MEMBER_VALUE: {
                throw new JSONParseException(Messages.getString("JSONEncoder.StringEndedBeforeMemberValueCouldBeRead"));
            }
        }
        if (charsRead != null) {
            charsRead.set(i);
        }
        return decoded;
    }

    public static String encodeString(String s) {
        int codePoint;
        if (s == null) {
            return JSON_NULL;
        }
        StringBuilder encoded = new StringBuilder("\"");
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            char c = (char)codePoint;
            if (ENCODE_CHAR_ESCAPES.containsKey(Character.valueOf(c))) {
                encoded.append('\\');
                encoded.append(ENCODE_CHAR_ESCAPES.get(Character.valueOf(c)));
                continue;
            }
            if (Character.isISOControl(codePoint)) {
                encoded.append("\\u");
                encoded.append(String.format("%04x", codePoint));
                continue;
            }
            encoded.appendCodePoint(codePoint);
        }
        encoded.append('\"');
        return encoded.toString();
    }

    public static String decodeString(String s) {
        return JSONEncoder.decodeString(s, null);
    }

    public static String decodeString(String s, AtomicInteger charsRead) {
        int i;
        int codePoint;
        if (s == null) {
            return null;
        }
        if (JSON_NULL.equals(s)) {
            return null;
        }
        StringBuilder decoded = new StringBuilder();
        StringBuilder hexString = new StringBuilder(4);
        StringParseState state = StringParseState.START;
        int length = s.length();
        block12: for (i = 0; i < length && state != StringParseState.DONE; i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            char c = (char)codePoint;
            switch (state) {
                case START: {
                    if (Character.isWhitespace(codePoint)) continue block12;
                    if (c == '\"') {
                        state = StringParseState.TEXT;
                        continue block12;
                    }
                    throw new JSONParseException(Messages.getString("JSONConvert.StringMustStartWithDoubleQuote"));
                }
                case TEXT: {
                    if (c == '\"') {
                        state = StringParseState.DONE;
                        continue block12;
                    }
                    if (c == '\\') {
                        state = StringParseState.ESCAPE;
                        continue block12;
                    }
                    decoded.appendCodePoint(codePoint);
                    continue block12;
                }
                case ESCAPE: {
                    if (c == 'u') {
                        state = StringParseState.ESCAPE_U;
                        continue block12;
                    }
                    if (DECODE_CHAR_ESCAPES.containsKey(Character.valueOf(c))) {
                        decoded.append(DECODE_CHAR_ESCAPES.get(Character.valueOf(c)));
                        state = StringParseState.TEXT;
                        continue block12;
                    }
                    throw new JSONParseException(MessageFormat.format(Messages.getString("JSONConvert.UnknownEscapeSequenceFormat"), Character.valueOf(c)));
                }
                case ESCAPE_U: {
                    if (c == '\"') {
                        throw new JSONParseException(Messages.getString("JSONConvert.StringEndedBeforeAllFourHexadecimal"));
                    }
                    if (!Character.isLetterOrDigit(c)) {
                        throw new JSONParseException(MessageFormat.format(Messages.getString("JSONConvert.CharacterNotValidHexadecimalaFormat"), Character.valueOf(c)));
                    }
                    hexString.append(c);
                    if (hexString.length() != 4) continue block12;
                    decoded.appendCodePoint(Integer.parseInt(hexString.toString(), 16));
                    hexString.setLength(0);
                    state = StringParseState.TEXT;
                    continue block12;
                }
                default: {
                    throw new JSONParseException(MessageFormat.format("Unknown parse state {0}", new Object[]{state}));
                }
            }
        }
        switch (state) {
            case START: {
                throw new JSONParseException(Messages.getString("JSONConvert.StringMustStartWithDoubleQuote"));
            }
            case TEXT: {
                throw new JSONParseException(Messages.getString("JSONConvert.StringMustEndWithDoubleQuote"));
            }
            case ESCAPE: {
                throw new JSONParseException(Messages.getString("JSONConvert.StringEndedBeforeEscapeIdentified"));
            }
            case ESCAPE_U: {
                throw new JSONParseException(Messages.getString("JSONConvert.StringEndedBeforeAllFourHexadecimal"));
            }
        }
        if (charsRead != null) {
            charsRead.set(i);
        }
        return decoded.toString();
    }

    static {
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\"'), Character.valueOf('\"'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\\'), Character.valueOf('\\'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('/'), Character.valueOf('/'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\b'), Character.valueOf('b'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\f'), Character.valueOf('f'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\n'), Character.valueOf('n'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\r'), Character.valueOf('r'));
        ENCODE_CHAR_ESCAPES.put(Character.valueOf('\t'), Character.valueOf('t'));
        for (Map.Entry<Character, Character> e : ENCODE_CHAR_ESCAPES.entrySet()) {
            DECODE_CHAR_ESCAPES.put(e.getValue(), e.getKey());
        }
    }

    private static enum ObjectParseState {
        START,
        MEMBERS,
        MEMBER_NAME,
        MEMBER_NAME_SEPARATOR,
        MEMBER_VALUE,
        DONE;

    }

    private static enum StringParseState {
        START,
        TEXT,
        ESCAPE,
        ESCAPE_U,
        DONE;

    }
}

