/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.shutdown;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.TypesafeEnum;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;
import com.microsoft.tfs.util.shutdown.ShutdownEventListener;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ShutdownManager {
    private static final Log log = LogFactory.getLog(ShutdownManager.class);
    private static ShutdownManager instance;
    private final SingleListenerFacade earlyListeners = new SingleListenerFacade(ShutdownEventListener.class);
    private final SingleListenerFacade middleListeners = new SingleListenerFacade(ShutdownEventListener.class);
    private final SingleListenerFacade lateListeners = new SingleListenerFacade(ShutdownEventListener.class);

    private ShutdownManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    log.trace((Object)"Shutdown hook thread started");
                    ShutdownManager.getInstance().shutdown();
                    log.trace((Object)"Shutdown hook thread finished");
                }
            });
        }
        catch (IllegalStateException e) {
            log.info((Object)"Can't add shutdown hook because we're already shutting down: not a big deal", (Throwable)e);
        }
    }

    public static synchronized ShutdownManager getInstance() {
        if (instance == null) {
            instance = new ShutdownManager();
        }
        return instance;
    }

    public synchronized void shutdown() {
        log.debug((Object)"shutdown");
        try {
            ((ShutdownEventListener)this.earlyListeners.getListener()).onShutdown();
        }
        catch (IllegalStateException e) {
            log.warn((Object)e.getMessage());
        }
        try {
            ((ShutdownEventListener)this.middleListeners.getListener()).onShutdown();
        }
        catch (IllegalStateException e) {
            log.warn((Object)e.getMessage());
        }
        try {
            ((ShutdownEventListener)this.lateListeners.getListener()).onShutdown();
        }
        catch (IllegalStateException e) {
            log.warn((Object)e.getMessage());
        }
    }

    public void addShutdownEventListener(ShutdownEventListener listener, Priority priority) {
        Check.notNull(listener, "listener");
        Check.notNull(priority, "priority");
        if (priority == Priority.EARLY) {
            this.earlyListeners.addListener(listener);
        } else if (priority == Priority.MIDDLE) {
            this.middleListeners.addListener(listener);
        } else if (priority == Priority.LATE) {
            this.lateListeners.addListener(listener);
        } else {
            String messageFormat = Messages.getString("ShutdownManager.UnknownPriorityFormat");
            String message = MessageFormat.format(messageFormat, priority.toString());
            throw new RuntimeException(message);
        }
    }

    public void removeShutdownEventListener(ShutdownEventListener listener, Priority priority) {
        Check.notNull(listener, "listener");
        Check.notNull(priority, "priority");
        if (priority == Priority.EARLY) {
            this.earlyListeners.removeListener(listener);
        } else if (priority == Priority.MIDDLE) {
            this.middleListeners.removeListener(listener);
        } else if (priority == Priority.LATE) {
            this.lateListeners.removeListener(listener);
        } else {
            String messageFormat = Messages.getString("ShutdownManager.UnknownPriorityFormat");
            String message = MessageFormat.format(messageFormat, priority.toString());
            throw new RuntimeException(message);
        }
    }

    public static class Priority
    extends TypesafeEnum {
        public static final Priority EARLY = new Priority(0);
        public static final Priority MIDDLE = new Priority(1);
        public static final Priority LATE = new Priority(2);

        private Priority(int value) {
            super(value);
        }
    }
}

