/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.utils.MessageException;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.ClientInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.InputFileBuilder;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.InputFileIndex;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.ProgressReport;
import org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem.SonarLintInputFile;
import org.sonarsource.sonarlint.core.analysis.container.analysis.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

@SonarLintSide
public class FileIndexer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final InputFileBuilder inputFileBuilder;
    private final AnalysisConfiguration analysisConfiguration;
    private final AnalysisResults analysisResult;
    private final List<InputFileFilter> filters;
    private final IssueExclusionsLoader issueExclusionsLoader;
    private final InputFileIndex inputFileCache;
    private ProgressReport progressReport;

    public FileIndexer(InputFileIndex inputFileCache, InputFileBuilder inputFileBuilder, AnalysisConfiguration analysisConfiguration, AnalysisResults analysisResult, IssueExclusionsLoader issueExclusionsLoader, Optional<List<InputFileFilter>> filters) {
        this.inputFileCache = inputFileCache;
        this.inputFileBuilder = inputFileBuilder;
        this.analysisConfiguration = analysisConfiguration;
        this.analysisResult = analysisResult;
        this.issueExclusionsLoader = issueExclusionsLoader;
        this.filters = filters.orElse(List.of());
    }

    public void index() {
        this.progressReport = new ProgressReport("Report about progress of file indexation", TimeUnit.SECONDS.toMillis(10L));
        this.progressReport.start("Index files");
        Progress progress = new Progress();
        try {
            this.indexFiles(this.inputFileCache, progress, this.analysisConfiguration.inputFiles());
        }
        catch (Exception e) {
            this.progressReport.stop(null);
            throw e;
        }
        int totalIndexed = progress.count();
        this.progressReport.stop(totalIndexed + " " + FileIndexer.pluralizeFiles(totalIndexed) + " indexed");
        this.analysisResult.setIndexedFileCount(totalIndexed);
    }

    private static String pluralizeFiles(int count) {
        return count == 1 ? "file" : "files";
    }

    private void indexFiles(InputFileIndex inputFileCache, Progress progress, Iterable<ClientInputFile> inputFiles) {
        for (ClientInputFile file : inputFiles) {
            this.indexFile(inputFileCache, progress, file);
        }
    }

    private void indexFile(InputFileIndex inputFileCache, Progress progress, ClientInputFile file) {
        SonarLintInputFile inputFile = this.inputFileBuilder.create(file);
        if (this.accept(inputFile)) {
            this.analysisResult.setLanguageForFile(file, inputFile.getLanguage());
            this.indexFile(inputFileCache, progress, inputFile);
            this.issueExclusionsLoader.addMulticriteriaPatterns(inputFile);
        }
    }

    private void indexFile(InputFileIndex inputFileCache, Progress status, SonarLintInputFile inputFile) {
        inputFileCache.doAdd(inputFile);
        status.markAsIndexed(inputFile);
    }

    private boolean accept(InputFile indexedFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(indexedFile)) continue;
            LOG.debug("'{}' excluded by {}", (Object)indexedFile, (Object)filter.getClass().getName());
            return false;
        }
        return true;
    }

    private class Progress {
        private final Set<URI> indexed = new HashSet<URI>();

        private Progress() {
        }

        void markAsIndexed(SonarLintInputFile inputFile) {
            if (this.indexed.contains(inputFile.uri())) {
                throw MessageException.of("File " + inputFile + " can't be indexed twice.");
            }
            this.indexed.add(inputFile.uri());
            int size = this.indexed.size();
            FileIndexer.this.progressReport.message(() -> size + " files indexed...  (last one was " + inputFile.uri() + ")");
        }

        int count() {
            return this.indexed.size();
        }
    }
}

