

This plugin test checks for ``requests`` calls without a timeout specified.

Nearly all production code should use this parameter in nearly all requests,
Failure to do so can cause your program to hang indefinitely.

When request methods are used without the timeout parameter set,
Bandit will return a MEDIUM severity error.


## Example

``` python

>> Issue: [B113:request_without_timeout] Requests call without timeout
Severity: Medium   Confidence: Low
CWE: CWE-400 (https://cwe.mitre.org/data/definitions/400.html)
More Info: https://bandit.readthedocs.io/en/latest/plugins/b113_request_without_timeout.html
Location: examples/requests-missing-timeout.py:3:0
2
3	requests.get('https://gmail.com')
4	requests.get('https://gmail.com', timeout=None)

--------------------------------------------------
>> Issue: [B113:request_without_timeout] Requests call with timeout set to None
Severity: Medium   Confidence: Low
CWE: CWE-400 (https://cwe.mitre.org/data/definitions/400.html)
More Info: https://bandit.readthedocs.io/en/latest/plugins/b113_request_without_timeout.html
Location: examples/requests-missing-timeout.py:4:0
3	requests.get('https://gmail.com')
4	requests.get('https://gmail.com', timeout=None)
5	requests.get('https://gmail.com', timeout=5)

```
## see also:

- https://requests.readthedocs.io/en/latest/user/advanced/#timeouts

New in version  1.7.5

