Makes sure that all pods are targeted by a NetworkPolicy.

# Details
With network policies the communication between all Kubernetes components and also with endpoints outside the network can be controlled.
Network policies can create firewall-like protection between pods running on the same Kubernetes cluster.
If an attacker could compromise a container, the attacker would try to explore the network to compromise other containers and hosts as well.
Restricting the network access and the communication paths would isolate different components, making it more difficult for the attacker to infiltrate the entire system.
The official [Kubernetes](https://kubernetes.io/blog/2018/07/18/11-ways-not-to-get-hacked/) website recommends denying all traffic in the network and then incrementally add the necessary routes as a best practice.

# Further Reading: 
- Brendan Burns et al. Kubernetes Best Practices. First Edition. Sebastopol: O’Reilly Media, Inc., 2019. isbn: 9781492056478.
- Hasham Haider. Kubernetes Production Readiness and Best Practices Checklist. replex, 2019.
- Daniele Polencic. Kubernetes production best practices. A curated checklist of best practices designed to help you release to production. url: https://learnk8s.io/production-best-practices#application-development
- Liz Rice and Michael Hausenblas. Kubernetes Security. First Edition. Sebastopol: O’Reilly Media, Inc., 2018. isbn: 9781492039068.
- Andrew Martin. 11 Ways (Not) to Get Hacked. July 18, 2018. url: https://kubernetes.io/blog/2018/07/18/11-ways-not-to-get-hacked/