﻿## SA1015

<table>
<tr>
  <td>TypeName</td>
  <td>SA1015ClosingGenericBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1015</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A closing generic bracket within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a closing generic bracket is not correct.

A closing generic bracket should never be preceded by whitespace, unless the bracket is the first character on the line.
                    A closing generic bracket should be followed by an open parenthesis, a close 
                    parenthesis, a closing generic bracket, a nullable symbol, an end of 
                    line or a single whitespace (but not whitespace and an open parenthesis).

## How to fix violations

To fix a violation of this rule, ensure the whitespace around the closing generic bracket 
                    is correct.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1015:ClosingGenericBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1015 // ClosingGenericBracketsMustBeSpacedCorrectly
#pragma warning restore SA1015 // ClosingGenericBracketsMustBeSpacedCorrectly
```
