<h2>Why is this an issue?</h2>
<p>Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate. This rule allows to check that all
interface names match a provided regular expression.</p>
<h3>Noncompliant code example</h3>
<p>With the default regular expression <code>^[A-Z][a-zA-Z0-9]*$</code>:</p>

```java
public interface myInterface {...} // Noncompliant
```
<h3>Compliant solution</h3>

```java
public interface MyInterface {...}
```