<h2>Why is this an issue?</h2>
<p>Creating an object for the sole purpose of calling <code>getClass</code> on it is a waste of memory and cycles. Instead, simply use the class’s
<code>.class</code> property.</p>
<h3>Noncompliant code example</h3>

```java
MyObject myOb = new MyObject();  // Noncompliant
Class c = myOb.getClass();
```
<h3>Compliant solution</h3>

```java
Class c = MyObject.class;
```