<p>This rule raises an issue when an overriding method changes a contract defined in a superclass.</p>
<h2>Why is this an issue?</h2>
<p>Because a subclass instance may be cast to and treated as an instance of the superclass, overriding methods should uphold the aspects of the
superclass contract that relate to the Liskov Substitution Principle. Specifically, if the parameters or return type of the superclass method are
marked with any of the following: <code>@Nullable</code>, <code>@CheckForNull</code>, <code>@NotNull</code>, <code>@NonNull</code>, and
<code>@Nonnull</code>, then subclass parameters are not allowed to tighten the contract, and return values are not allowed to loosen it.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class Fruit {

  private Season ripe;
  private String color;

  public void setRipe(@Nullable Season ripe) {
    this.ripe = ripe;
  }

  public @NotNull Integer getProtein() {
    return 12;
  }
}

public class Raspberry extends Fruit {

  public void setRipe(@NotNull Season ripe) {  // Noncompliant: the ripe argument annotated as @Nullable in parent class
    this.ripe = ripe;
  }

  public @Nullable Integer getProtein() {  // Noncompliant: the return type annotated as @NotNull in parent class
    return null;
  }
}
```
<h4>Compliant solution</h4>

```java
public class Fruit {

  private Season ripe;
  private String color;

  public void setRipe(@Nullable Season ripe) {
    this.ripe = ripe;
  }

  public @NotNull Integer getProtein() {
    return 12;
  }
}

public class Raspberry extends Fruit {

  public void setRipe(@Nullable Season ripe) {
    this.ripe = ripe;
  }

  public @NotNull Integer getProtein() {
    return 12;
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> SOLID - <a href="https://en.wikipedia.org/wiki/Liskov_substitution_principle">Wikipedia - Liskov substitution principle</a> </li>
</ul>