<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently. This rule raises an issue when a test class name does not match the provided
regular expression.</p>
<h3>Noncompliant code example</h3>
<p>With the default value: <code>^((Test|IT)[a-zA-Z0-9_]+|[A-Z][a-zA-Z0-9_]*(Test|Tests|TestCase|IT|ITCase))$</code></p>

```java
class Foo {  // Noncompliant
  @Test
  void check() {  }
}

class Bar {  // Noncompliant
  @Nested
  class PositiveCase {
    @Test
    void check() {  }
  }
}
```
<h3>Compliant solution</h3>

```java
class FooTest {
  @Test
  void check() {  }
}

class BarIT {
  @Nested
  class PositiveCase {
    @Test
    void check() {  }
  }
}
```