<h2>Why is this an issue?</h2>
<p>With the introduction of Java 9, the standard annotation class <code>java.lang.Deprecated</code> has been updated with new parameters. Notably, a
boolean parameter <code>forRemoval</code> has been added to clearly signify whether the deprecated code is intended to be removed in the future. This
is indicated with <code>forRemoval=true</code>. The javadoc of the annotation explicitly mentions the following:</p>
<blockquote>
  <p>This annotation type has a boolean-valued element <code>forRemoval</code>. A value of <code>true</code> indicates intent to remove the annotated
  program element in a future version. A value of <code>false</code> indicates that use of the annotated program element is discouraged, but at the
  time the program element was annotated, there was no specific intent to remove it.</p>
</blockquote>
<p>While it is generally recommended for developers to steer clear of using deprecated classes, interfaces, and their deprecated members, those
already marked for removal will surely block you from upgrading your dependency. Usage of deprecated code should be avoided or eliminated as soon as
possible to prevent accumulation and allow a smooth upgrade of dependencies.</p>
<p>The deprecated code is usually no longer maintained, can contain some bugs or vulnerabilities, and usually indicates that there is a better way to
do the same thing. Removing it can even lead to significant improvement of your software.</p>
<h2>How to fix it</h2>
<p>Usage of deprecated classes, interfaces, and their methods explicitly marked for removal is discouraged. A developer should either migrate to
alternative methods or refactor the code to avoid the deprecated ones.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
/**
 * @deprecated As of release 1.3, replaced by {@link #Fee}. Will be dropped with release 1.4.
 */
@Deprecated(forRemoval=true)
public class Foo { ... }

public class Bar {
  /**
   * @deprecated  As of release 1.7, replaced by {@link #doTheThingBetter()}
   */
  @Deprecated(forRemoval=true)
  public void doTheThing() { ... }

  public void doTheThingBetter() { ... }

  /**
   * @deprecated As of release 1.14 due to poor performances.
   */
  @Deprecated(forRemoval=false)
  public void doTheOtherThing() { ... }
}

public class Qix extends Bar {
  @Override
  public void doTheThing() { ... } // Noncompliant; don't override a deprecated method marked for removal
}

public class Bar extends Foo {  // Noncompliant; Foo is deprecated and will be removed

  public void myMethod() {
    Bar bar = new Bar();  // okay; the class isn't deprecated
    bar.doTheThing();  // Noncompliant; doTheThing method is deprecated and will be removed

    bar.doTheOtherThing(); // Okay; deprecated, but not marked for removal
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/477">CWE-477 - Use of Obsolete Functions</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/6TdGBQ">CERT, MET02-J.</a> - Do not use deprecated or obsolete classes or methods </li>
  <li> RSPEC-1874 for standard deprecation use </li>
</ul>