<h2>Why is this an issue?</h2>
<p>When the return value of a function call contains the operation status code, this value should be tested to make sure the operation completed
successfully.</p>
<p>This rule raises an issue when the return values of the following are ignored:</p>
<ul>
  <li> <code>java.io.File</code> operations that return a status code (except <code>mkdirs</code>) </li>
  <li> <code>Iterator.hasNext()</code> </li>
  <li> <code>Enumeration.hasMoreElements()</code> </li>
  <li> <code>Lock.tryLock()</code> </li>
  <li> non-void <code>Condition.await*</code> methods </li>
  <li> <code>CountDownLatch.await(long, TimeUnit)</code> </li>
  <li> <code>Semaphore.tryAcquire</code> </li>
  <li> <code>BlockingQueue</code>: <code>offer</code>, <code>remove</code> </li>
</ul>
<h3>Noncompliant code example</h3>

```java
public void doSomething(File file, Lock lock) {
  file.delete();  // Noncompliant
  // ...
  lock.tryLock(); // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
public void doSomething(File file, Lock lock) {
  if (!lock.tryLock()) {
    // lock failed; take appropriate action
  }
  if (!file.delete()) {
    // file delete failed; take appropriate action
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/xzdGBQ">CERT, EXP00-J.</a> - Do not ignore values returned by methods </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/TTZGBQ">CERT, FIO02-J.</a> - Detect and handle file-related errors </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/754">CWE-754 - Improper Check for Unusual Exceptional Conditions</a> </li>
</ul>