<h2>Why is this an issue?</h2>
<p>Using the <code>new</code> operator with <code>Symbol</code> and <code>BigInt</code> will throw a <code>TypeError</code> because they are not
intended to be used as constructors. <code>Symbol</code> and <code>BigInt</code> are primitive types in JavaScript and should be used as such.</p>
<p>This is different from the other primitive types, such as string, number or boolean, where it was possible to call global <code>String</code> or
<code>Number</code> as functions that return primitive types, but also use them as constructors with the <code>new</code> operator to create wrapper
objects. This confusing double behavior is not implemented for <code>Symbol</code> and <code>BigInt</code> types that were introduced later in the
language.</p>
<p>This behavior would be especially problematic for symbols that have reference identity and already behave like objects in some way. For example,
they are garbage collectable and therefore can be used as keys in WeakMap and WeakSet objects.</p>

```js
let foo = new Symbol('abc'); // Noncompliant: TypeError: Symbol is not a constructor
let bar = new BigInt(123);   // Noncompliant: TypeError: BigInt is not a constructor
```
<p>To fix the code remove the <code>new</code> operator.</p>

```js
let foo = Symbol('abc');
let bar = BigInt(123);
```
<p>For the <code>BigInt</code> type to be recognized correctly, the environment should be <code>es2020</code> or higher.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol/Symbol">Symbol</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt/BigInt">BigInt</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new">new operator</a> </li>
</ul>