<h2>Why is this an issue?</h2>
<p>Overriding a method just to call the same method from the super class without performing any other actions is useless and misleading. The only time
this is justified is in <code>final</code> overriding methods, where the effect is to lock in the parent class behavior. This rule ignores such
overrides of <code>equals</code>, <code>hashCode</code> and <code>toString</code>.</p>
<h3>Noncompliant code example</h3>

```php
class Child extends Parent {

  public function func($n,$m) {
    parent::func($n$m);  // Noncompliant
  }
}

class Parent {
  public function func($n, $m) {
    // do something
  }
}
```
<h3>Compliant solution</h3>

```php
class Child extends Parent {

  public function func($n,$m) {
    parent::func($n$m);
    // do additional things...
  }
}

class Parent {
  public function func($n, $m) {
    // do something
  }
}
```
<p>or</p>

```php
class Child extends Parent {
  // function eliminated
}

class Parent {
  public function func($n, $m) {
    // do something
  }
}
```