<h2>Why is this an issue?</h2>
<p>Dead stores refer to assignments made to local variables that are subsequently never used or immediately overwritten. Such assignments are
unnecessary and don’t contribute to the functionality or clarity of the code. They may even negatively impact performance. Removing them enhances code
cleanliness and readability. Even if the unnecessary operations do not do any harm in terms of the program’s correctness, they are - at best - a waste
of computing resources.</p>
<h3>Exceptions</h3>
<p>This rule ignores initializations to <code>-1</code>, <code>0</code>, <code>1</code>, <code>null</code>, <code>true</code>, <code>false</code>,
<code>""</code>, <code>[]</code> and <code>array()</code>.</p>
<h2>How to fix it</h2>
<p>Remove the unnecesarry assignment, then test the code to make sure that the right-hand side of a given assignment had no side effects (e.g. a
method that writes certain data to a file and returns the number of written bytes).</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
$i = $a + $b; // Noncompliant - calculation result is not used before value is overwritten
$i = compute();
```
<h4>Compliant solution</h4>

```php
$i = $a + $b;
$i += compute();
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/563">CWE-563 - Assignment to Variable without Use ('Unused Variable')</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S1763'>php:S1763</a> - All code should be reachable </li>
  <li> <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S3626'>php:S3626</a> - Jump statements should not be redundant </li>
  <li> <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S1763'>php:S1763</a> detects unreachable code </li>
  <li> <a href='checks/checks/?languages=PHP&tools=SONAR_LINT&rule=php:S3626'>php:S3626</a> identifies redundant jump statements </li>
</ul>