<h2>Why is this an issue?</h2>
<p>When the names of parameters in a method call match the names of the method arguments, it contributes to clearer, more readable code. However, when
the names match, but are passed in a different order than the method arguments, it indicates a mistake in the parameter order which will likely lead
to unexpected results.</p>
<h3>Noncompliant code example</h3>

```php
public function divide($divisor, $dividend) {
  return $divisor/$dividend;
}

public function doTheThing() {
  $divisor = 15;
  $dividend = 5;

  $result = $this->divide($dividend, $divisor);  // Noncompliant; operation succeeds, but result is unexpected
}
```
<h3>Compliant solution</h3>

```php
public function divide($divisor, $dividend) {
  return $divisor/$dividend;
}

public function doTheThing() {
  $divisor = 15;
  $dividend = 5;

  $result = $this->divide($divisor, $dividend); // Compliant
}{code}
h4.  
```