<h2>Why is this an issue?</h2>
<p>Initially, TypeScript defined "internal modules" and "external modules":</p>
<ul>
  <li> Internal modules: The <code>module</code> keyword was introduced in TypeScript to define internal modules. Internal modules were used to group
  classes, interfaces, and functions into logical units. </li>
  <li> External modules refer to JavaScript modules, introduced in ECMAScript 2015. In TypeScript, just as in JavaScript (after ECMAScript 2015), any
  file containing a top-level <code>import</code> or <code>export</code> is considered a module. </li>
</ul>
<p>However, in order to avoid confusion with similarly named terms, <code>module</code> was deprecated in favor of the <code>namespace</code> keyword,
and "external modules" became simply "modules", as to align with ECMAScript 2015’s terminology.</p>
<p>Now that <code>namespace</code> is available, the use of <code>module</code> is deprecated because it does the same thing, and its use could
confuse maintainers unaware of the history of the language. Therefore, the use of <code>module</code> is discouraged in TypeScript code.</p>

```ts
module myMod {  // Noncompliant
  // ...
}
```
<p>Anywhere the <code>module</code> keyword was used when declaring an internal module, the <code>namespace</code> keyword should be used instead.</p>

```ts
namespace myMod {
  // ...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/namespaces.html">Namespaces</a> </li>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/modules.html">Modules</a> </li>
  <li> ECMAScript - <a href="https://262.ecma-international.org/6.0/">ECMAScript 2015</a> </li>
</ul>