<h2>Why is this an issue?</h2>
<p>React components often render HTML elements, and developers can pass various props (properties) to these elements. However, React has its own set
of supported properties and attributes, and it’s essential to avoid using unknown or invalid properties when working with such elements to prevent
unexpected behavior at runtime.</p>
<p>The rule reports any instances where you are using a property or attribute that is not recognized by React or the HTML element you are
rendering.</p>
<h2>How to fix it</h2>
<p>Replace any unknown property or attribute with a known one, or add it to the list of exceptions.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
class Welcome extends React.Component {
  render() {
    return <div class="hello">Hello, World!</div>; // Noncompliant: 'class' is a reserved keyword in JavaScript
  }
}
```
<h4>Compliant solution</h4>

```ts
class Welcome extends React.Component {
  render() {
    return <div className="hello">Hello, World!</div>;
  }
}
```
<h4>Noncompliant code example</h4>

```ts
const Image = <img source={myImage} />; // Noncompliant: The 'img' tag does not recognize any 'source' attribute
```
<h4>Compliant solution</h4>

```ts
const Image = <img src={myImage} />;
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes">HTML attribute reference</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes">HTML global attributes</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute">SVG attribute reference</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes">ARIA states and properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/data-*">data-*</a> </li>
  <li> React Documentation - <a href="https://react.dev/reference/react-dom/components/common#common-props">Standard DOM props</a> </li>
</ul>