import{_ as i,h as t,ak as s,g as a}from"./chunks/framework.B7a_7emw.js";const k=JSON.parse('{"title":"Teamscale Compact Coverage","description":"","frontmatter":{"title":"Teamscale Compact Coverage","pageClass":"wider-content"},"headers":[],"relativePath":"reference/upload-formats-and-samples/teamscale-compact-coverage/index.md","filePath":"reference/upload-formats-and-samples/teamscale-compact-coverage/index.md"}'),n={name:"reference/upload-formats-and-samples/teamscale-compact-coverage/index.md"};function l(o,e,d,r,h,p){return a(),t("div",null,[...e[0]||(e[0]=[s(`<h1 id="teamscale-compact-coverage" tabindex="-1">Teamscale Compact Coverage <a class="header-anchor" href="#teamscale-compact-coverage" aria-label="Permalink to &quot;Teamscale Compact Coverage&quot;">​</a></h1><nav class="table-of-contents"><ul><li><a href="#report-format">Report Format</a><ul><li><a href="#preliminaries">Preliminaries</a></li><li><a href="#teamscalecompactcoveragereport">TeamscaleCompactCoverageReport</a></li><li><a href="#compactcoveragefileinfo">CompactCoverageFileInfo</a></li></ul></li><li><a href="#coverageprobe">CoverageProbe</a><ul><li><a href="#decisionprobe">DecisionProbe</a></li><li><a href="#statementprobe">StatementProbe</a></li></ul></li><li><a href="#sample-file">Sample File</a></li></ul></nav><h2 id="report-format" tabindex="-1">Report Format <a class="header-anchor" href="#report-format" aria-label="Permalink to &quot;Report Format&quot;">​</a></h2><p>Teamscale Compact Coverage is a Teamscale-specific coverage format that allows to upload coverage information in a compressed format to reduce the amount of data processed by the Teamscale instance.</p><h3 id="preliminaries" tabindex="-1">Preliminaries <a class="header-anchor" href="#preliminaries" aria-label="Permalink to &quot;Preliminaries&quot;">​</a></h3><ul><li>Line range string <ul><li>String containing line ranges and individual lines separated by commas.</li><li>Compact representation of a set of lines of code.</li><li>Example: <code>&quot;10-12,13,22-27,40&quot;</code></li></ul></li></ul><h3 id="teamscalecompactcoveragereport" tabindex="-1">TeamscaleCompactCoverageReport <a class="header-anchor" href="#teamscalecompactcoveragereport" aria-label="Permalink to &quot;TeamscaleCompactCoverageReport&quot;">​</a></h3><p>The top level JSON object is the <code>TeamscaleCompactCoverageReport</code>. It contains the following attributes:</p><table><tbody><tr><td style="line-height:1.6;"><code>version</code></td><td><code>int</code></td><td>required</td><td><ul><li>The version for the format described here should be <code>1</code>.</li><li>Version number for the Teamscale Compact Coverage report version.</li><li>If not given, the parser will fall back to version 1 of the Teamscale Compact Coverage format.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>coverage</code></td><td><code>Array&lt;CompactCoverageFileInfo&gt;</code></td><td>required</td><td><ul><li>See section for <a href="#compactcoveragefileinfo"><code>CompactCoverageFileInfo</code></a>.</li></ul></td></tr></tbody></table><h3 id="compactcoveragefileinfo" tabindex="-1">CompactCoverageFileInfo <a class="header-anchor" href="#compactcoveragefileinfo" aria-label="Permalink to &quot;CompactCoverageFileInfo&quot;">​</a></h3><p>Aggregated coverage information about a source code file. It contains the following attributes.</p><table><tbody><tr><td style="line-height:1.6;"><code>filePath</code></td><td><code>string</code></td><td>required</td><td><ul><li>The source file path</li><li>Typically relative to the project&#39;s root, but might also be an absolute path.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>fullyCoveredLines</code></td><td><code>string</code></td><td>required</td><td><ul><li>Line range string for the lines in the source code that are fully covered, i.e. all possible branches of this line are covered.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>partiallyCoveredLines</code></td><td><code>string</code></td><td>optional</td><td><ul><li>Line range string for the lines in the source code that are partially covered.</li><li>A line is partially covered if at least one, but not all possible branches in this line are covered.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>uncoveredLines</code></td><td><code>string</code></td><td>optional</td><td><ul><li>Line range string for the lines in the source code that are not covered, i.e. the line is coverable but has not been executed by any test case.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>coverageProbes</code></td><td><code>Array&lt;CoverageProbe&gt;</code></td><td>optional</td><td><ul><li>See section for <code>CoverageProbe</code>.</li><li>Can both contain <code>DecisionProbe</code>s and <code>StatementProbe</code>s.</li></ul></td></tr></tbody></table><h2 id="coverageprobe" tabindex="-1">CoverageProbe <a class="header-anchor" href="#coverageprobe" aria-label="Permalink to &quot;CoverageProbe&quot;">​</a></h2><p>CoverageProbes are generic coverage &quot;indicators&quot; associated with a source line (the start line of the corresponding statement). Probes can be of types <code>DecisionProbe</code> and <code>StatementProbe</code> as defined by the attribute <code>type</code>. For example in case of branch coverage, a probe may indicate for an if-condition how many times it was evaluated to true and how often to false.</p><h3 id="decisionprobe" tabindex="-1">DecisionProbe <a class="header-anchor" href="#decisionprobe" aria-label="Permalink to &quot;DecisionProbe&quot;">​</a></h3><p>Probe for a decision, e.g. an if-statement, which carries two execution counters.</p><table><tbody><tr><td style="line-height:1.6;"><code>type</code></td><td><code>string</code></td><td>required</td><td><ul><li>Set to <code>&quot;decision&quot;</code>.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>line</code></td><td><code>int</code></td><td>required</td><td><ul><li>1-based line number of the associated statement.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>trueExecutionCount</code></td><td><code>int</code></td><td>required</td><td><ul><li>Number of executions the expression evaluated to true.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>falseExecutionCount</code></td><td><code>int</code></td><td>required</td><td><ul><li>Number of executions the expression evaluated to false.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>configurations</code></td><td><code>Array&lt;DecisionProbeConfiguration&gt;</code></td><td>required</td><td><ul><li>See section for <code>DecisionProbeConfiguration</code>.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>conditions</code></td><td><code>Array&lt;McDcCondition&gt;</code></td><td>required</td><td><ul><li>See section for <code>McDcCondition</code>.</li></ul></td></tr></tbody></table><h4 id="decisionprobeconfiguration" tabindex="-1">DecisionProbeConfiguration <a class="header-anchor" href="#decisionprobeconfiguration" aria-label="Permalink to &quot;DecisionProbeConfiguration&quot;">​</a></h4><p>A configuration for the individual conditions in a decision. We are looking at an example for the condition <code>if (val == 1 &amp;&amp; val2 == 2 &amp;&amp; val3 == 3)</code>.</p><table><tbody><tr><td style="line-height:1.6;"><code>description</code></td><td><code>string</code></td><td>required</td><td><ul><li>The evaluation result of the individual conditions in the decision.</li><li><code>&quot;T || F || _&quot;</code> indicates that the first expression evaluated to true, the second one to false, and the third one to &quot;Don&#39;t care&quot;/&quot;Not executed&quot;.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>decisionValue</code></td><td><code>boolean</code></td><td>required</td><td><ul><li>The overall truth value of the combined decision, based on the valuation in description.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>executionCount</code></td><td><code>int</code></td><td>required</td><td><ul><li>The number the probes which evaluated to this exact specific configuration.</li></ul></td></tr></tbody></table><h4 id="mcdccondition" tabindex="-1">McDcCondition <a class="header-anchor" href="#mcdccondition" aria-label="Permalink to &quot;McDcCondition&quot;">​</a></h4><p>An MC/DC condition necessary to meet the MC/DC criterion consisting of a textual description and the information whether it was fulfilled.</p><table><tbody><tr><td style="line-height:1.6;"><code>description</code></td><td><code>string</code></td><td>required</td><td><ul><li>The evaluation result of the individual conditions in the decision.</li><li>Equivalent to the format of <code>DecisionProbeConfiguration#description</code>.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>fulfilled</code></td><td><code>boolean</code></td><td>required</td><td><ul><li>Flag whether the MC/DC condition was fulfilled.</li></ul></td></tr></tbody></table><h3 id="statementprobe" tabindex="-1">StatementProbe <a class="header-anchor" href="#statementprobe" aria-label="Permalink to &quot;StatementProbe&quot;">​</a></h3><p>Simple probe that carries a single execution count.</p><table><tbody><tr><td style="line-height:1.6;"><code>type</code></td><td><code>string</code></td><td>required</td><td><ul><li>Set to <code>&quot;statement&quot;</code>.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>line</code></td><td><code>int</code></td><td>required</td><td><ul><li>1-based line number of the associated statement.</li></ul></td></tr><tr><td style="line-height:1.6;"><code>executionCount</code></td><td><code>int</code></td><td>required</td><td><ul><li>The total number of executions of this probe.</li></ul></td></tr></tbody></table><h2 id="sample-file" tabindex="-1">Sample File <a class="header-anchor" href="#sample-file" aria-label="Permalink to &quot;Sample File&quot;">​</a></h2><p>The following JSON sample file combines the data described above.</p><div class="language-json vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">json</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;version&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  &quot;coverage&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;filePath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;Simple.java&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;fullyCoveredLines&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1-3&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;partiallyCoveredLines&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;4,6&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;filePath&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;StringUtils.java&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;fullyCoveredLines&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;1,3&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;partiallyCoveredLines&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;4-6&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;uncoveredLines&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;2&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">      &quot;coverageProbes&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;type&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;decision&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;line&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">2</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;trueExecutionCount&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">0</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;falseExecutionCount&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;configurations&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">              &quot;description&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;T || F || _&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">              &quot;decisionValue&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">false</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">              &quot;executionCount&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">          ],</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;conditions&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: [</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">              &quot;description&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;T || T&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">              &quot;fulfilled&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">true</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">          ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        },</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        {</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;type&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;statement&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;line&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">3</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">,</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">          &quot;executionCount&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  ]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div>`,29)])])}const u=i(n,[["render",l]]);export{k as __pageData,u as default};
