This check detects files which contain C++ code but do not use one of the file extensions expected for this language.
For example, a C++ source file with a `.c` file extension instead of `.cpp`.
The concrete extensions that are expected can be configured.

# Why is this a problem?

Especially in heterogeneous code bases, libraries may provide interfaces in several languages.
Not properly differentiating files by their extension can cause the wrong files to be included.
Regardless, explicit differentiation of files written in different languages simplifies programming tasks, such as browsing the repository for relevant files. 

This check can also be useful when transitioning a code base from C to C++.

# How can I resolve this?
Rename files so that C++ files do not have the `.c` extension.
Ensure that files containing C++ code use the appropriate `.cpp`, `.cxx`, `.cc`, `.h`, `.hpp`, or `.hh` extension as configured for your project, and C files use `.c` or `.h`.

# Examples
## Non-Compliant
```cpp
// File named example.c but contains C++ code
class Example {
    int exampleMember;
};
```
## Compliant
```cpp
// File correctly named example.cpp to reflect C++ content
class Example {
    int exampleMember;
};
```

## Compliant
Note that this check is applied after C/C++ preprocessing.
For example, the file `example.c` with these contents:

```cpp
#if 0
class A {
    int a;
}
#endif

int plusOne(int num) {
    return num + 1;
}
```

Will not cause a finding because the C++ code is removed by the preprocessor.