``` python
heights = {'Fred': 175, 'Anne': 166, 'Joe': 192}
```
  
Iterable dict keys:
``` python
# Python 2 only:
for key in heights.iterkeys():
    ...
```
  
``` python
# Python 2 and 3:
for key in heights:
    ...
```
  
Iterable dict values:
``` python
# Python 2 only:
for value in heights.itervalues():
    ...
```
  
``` python
# Idiomatic Python 3
for value in heights.values():    # extra memory overhead on Py2
    ...
```
  
``` python
# Python 2 and 3: option 1
from builtins import dict

heights = dict(Fred=175, Anne=166, Joe=192)
for key in heights.values():    # efficient on Py2 and Py3
    ...
```
  
``` python
# Python 2 and 3: option 2
from builtins import itervalues
# or
from six import itervalues

for key in itervalues(heights):
    ...
```
  
Iterable dict items:
``` python
# Python 2 only:
for (key, value) in heights.iteritems():
    ...
```
  
``` python
# Python 2 and 3: option 1
for (key, value) in heights.items():    # inefficient on Py2    
    ...
```
  
``` python
# Python 2 and 3: option 2
from future.utils import viewitems

for (key, value) in viewitems(heights):   # also behaves like a set
    ...
```
  
``` python
# Python 2 and 3: option 3
from future.utils import iteritems
# or
from six import iteritems

for (key, value) in iteritems(heights):
    ...
```
  

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)