Using method return values without a null check could lead to null dereference errors.

# What Does This Check Look For?

This check identifies cases where the return value of a method, which can return null, is used without a prior null check.

# Why is This a Problem?

Using objects without checking if they are null first can lead to null dereference errors.
These errors can cause a program to crash or behave unpredictably, leading to a bad user experience.
Moreover, identifying the source of null dereference issues can be time-consuming and may hide larger design flaws.
Preventing such errors by ensuring that values are valid before use is a crucial step towards building more reliable software.

# How Can I Resolve This?

Always perform a null check on values returned from methods that may return null before using them.
This can be done using if-conditions, utilizing language-specific null-safe operators, or implementing optional types where applicable.
This approach not only prevents null dereference errors but also encourages more thoughtful error handling and robust design.

# Examples

## Non-Compliant

```java
String value = mayReturnNull();
System.out.println(value.length());  // non-compliant: may throw NullPointerException if value is null
```

## Compliant

```java
String value = mayReturnNull();
if (value != null) {
    System.out.println(value.length());  // compliant: checks if value is not null before using it
}
```

# Where Can I Learn More?

- [EXP01-J. Do not use a null in a case where an object is required](https://wiki.sei.cmu.edu/confluence/display/java/EXP01-J.+Do+not+use+a+null+in+a+case+where+an+object+is+required)
- [Null Dereference](https://owasp.org/www-community/vulnerabilities/Null_Dereference)