The names of Simulink files need to fulfill the following requirements:

- Sub ID a:
    - They shall only contain alphanumeric characters (a-z, A-Z, 0-9) and single-byte underscores (_).
    - They shall not contain line breaks, single-byte spaces, double-byte characters, and control characters.
- Sub ID b: They shall not have numbers at the beginning.
- Sub ID c: They shall not have underscores at the beginning.
- Sub ID d: They shall not have an underscore at the end.
- Sub ID e: They shall not have consecutive underscores.
- Sub ID f: They shall not consist solely of a reserved MATLAB word.

This check does not implement Sub ID g, i.e., duplicated file names are not detected.

## Guidelines

- [MAB Modeling Guideline (Version 6.0)](https://mathworks.com/help/simulink/mdl_gd/maab/ar_0001usablecharactersforfilenames.html)

## References

- Corresponding Model Advisor check [JMAAB ar_0001](https://www.mathworks.com/help/slcheck/ref/check-file-names.html)
