/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cloud_smells.clike;

import eu.cqse.check.cloud_smells.UnwantedExpressionBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

@Check(id="cqse-avoid-hard-coded-unc-path", languages={ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HardCodedUNCPathUsageCheck
extends UnwantedExpressionBase {
    protected static final String CHECK_NAME = "Hard Coded UNC Path";
    @CheckOption(name="Hard Coded UNC Path - Servers to which UNC paths are allowed", description="Using UNC paths pointing to a server name specified here is allowed. Separated by commas.")
    private Set<String> allowedServerNames = new HashSet<String>();

    @Override
    protected @NonNull EnumSet<EShallowEntityType> getTargetTypes() {
        return EnumSet.of(EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT);
    }

    @Override
    protected boolean shouldIgnore(MatchResult matchResult) {
        return this.allowedServerNames.contains(matchResult.group(1));
    }

    @Override
    protected Pattern getUnwantedRegex() {
        return Pattern.compile("[\"'\\s](?i)(?:\\\\\\\\){2}([a-z0-9_.$ -]+)(?:(?:\\\\){2}([a-z0-9_.$ -]+))+");
    }

    @Override
    protected String getFindingText(ShallowEntity entity, MatchResult matchResult) {
        return CHECK_NAME;
    }
}

