/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-inverted-junit-assert", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class InvertedJUnitAssertCheck
extends CheckImplementationBase {
    private static final String ASSERT_TRUE = "assertTrue";
    private static final String ASSERT_FALSE = "assertFalse";

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.contains((List)statement.ownStartTokens(), (ETokenType)ETokenType.NOT)) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList includedTokens = entity.includedTokens();
        if (includedTokens.size() <= 2 || !"!".equals(((IToken)includedTokens.get(2)).getText())) {
            return;
        }
        String tokenText = ((IToken)includedTokens.get(0)).getText();
        if (tokenText.startsWith(ASSERT_TRUE)) {
            this.createAssertFinding(entity, ASSERT_TRUE, ASSERT_FALSE);
        } else if (tokenText.startsWith(ASSERT_FALSE)) {
            this.createAssertFinding(entity, ASSERT_FALSE, ASSERT_TRUE);
        }
    }

    private void createAssertFinding(ShallowEntity entity, String currentAssert, String expectedAssert) {
        this.buildFinding("`" + currentAssert + "` with inverted condition should be `" + expectedAssert + "`", this.buildLocation().forEntity(entity)).createAndStore();
    }
}

