/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.jc_0501", languages={ELanguage.SIMULINK})
public class SimulinkStateBlockEntriesFormatCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE_MULTIPLE_STATEMENTS = "Multiple statements in line {0}: {1}";
    private static final String FINDING_MESSAGE_STATE_ACTION_STATEMENTS = "Statement in same line as state action type in line {0}: {1}";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Insert new lines between statements and action types, and between consecutive statements.");
    private static final int MAXIMUM_CODE_LINE_LENGTH = 30;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
                if (!(node instanceof StateflowState)) continue;
                this.checkState((StateflowState)node);
            }
        }
    }

    private void checkState(StateflowState state) {
        List stateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)state);
        for (StateflowStateAction stateAction : stateActions) {
            this.checkForActionTypeAndStatementInSameLine(state, stateAction);
            this.checkForMultipleStatementsInSameLine(state, stateAction);
        }
    }

    private void checkForActionTypeAndStatementInSameLine(StateflowState state, StateflowStateAction stateAction) {
        if (SimulinkStateBlockEntriesFormatCheck.isCorrectlyFormattedStateAction(stateAction)) {
            return;
        }
        List actionCode = stateAction.actionCode;
        int lineNumberOneBased = ((IToken)actionCode.get(0)).getLineNumber() + 1;
        List linesOfActionCode = StateflowCheckUtils.splitLines((List)actionCode);
        List firstLineOfActionCode = (List)linesOfActionCode.get(0);
        String displayString = TokenStreamTextUtils.concatTokenTexts((List)stateAction.actionDeclaration) + TokenStreamTextUtils.concatTokenTexts((List)firstLineOfActionCode);
        this.buildFinding(state, lineNumberOneBased, displayString, FINDING_MESSAGE_STATE_ACTION_STATEMENTS);
    }

    private static boolean isCorrectlyFormattedStateAction(StateflowStateAction stateAction) {
        List actionCodeWithoutCommentsAndEOL = stateAction.actionCode.stream().filter(token -> token.getType() != ETokenType.EOL && token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT).collect(Collectors.toList());
        if (stateAction.actionDeclaration.isEmpty() || actionCodeWithoutCommentsAndEOL.isEmpty()) {
            return true;
        }
        IToken lastDeclarationToken = (IToken)stateAction.actionDeclaration.get(stateAction.actionDeclaration.size() - 1);
        return ((IToken)actionCodeWithoutCommentsAndEOL.get(0)).getLineNumber() > lastDeclarationToken.getLineNumber();
    }

    private void checkForMultipleStatementsInSameLine(StateflowState state, StateflowStateAction stateAction) {
        List actionCode = stateAction.actionCode;
        List lines = StateflowCheckUtils.splitLines((List)actionCode);
        for (List line : lines) {
            if (TokenStreamUtils.count((List)line, (ETokenType)ETokenType.SEMICOLON) <= 1) continue;
            int lineNumberOneBased = ((IToken)line.get(0)).getLineNumber() + 1;
            this.buildFinding(state, lineNumberOneBased, TokenStreamTextUtils.concatTokenTexts((List)line), FINDING_MESSAGE_MULTIPLE_STATEMENTS);
        }
    }

    private void buildFinding(StateflowState state, int lineNumberOneBased, String codeLineForFindingMessage, String findingMessage) {
        codeLineForFindingMessage = StringUtils.truncateWithThreeDots((String)codeLineForFindingMessage, (int)30);
        codeLineForFindingMessage = MarkupUtils.formatAsSourceCode((String)codeLineForFindingMessage);
        this.buildFinding(MessageFormat.format(findingMessage, lineNumberOneBased, codeLineForFindingMessage), (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }
}

