/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ManualTestCase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.IntPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.SimpleNLPUtils;

@Check(id="cqse-wia-excessive-step", languages={ELanguage.NL_TESTS})
public class ExcessiveStepCheck
extends WorkItemCheckBase<ManualTestCase> {
    private static final String CHECK_NAME = "Excessive test step";
    @CheckOption(name="Excessive test step - Maximum number of words for test step 'action'", description="The maximum number of words that is allowed in test step 'action' fields. A finding is generated if this value is exceeded. All consecutive characters delimited by whitespace characters are considered words.")
    private int maxActionWords = 50;
    @CheckOption(name="Excessive test step - Maximum number of words for test step 'check'", description="The maximum number of words that is allowed in test step 'check' fields. A finding is generated if this value is exceeded. All consecutive characters delimited by whitespace characters are considered words.")
    private int maxCheckWords = 50;
    @CheckOption(name="Excessive test step - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and not included in the word count.For example, the regex `\".*?\"` ignores text that is enclosed in double quotes, and the regex `(?<=\\W|^)\\p{Punct}+(?=\\W|$)` ignores words that consist of punctuation characters only.")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'", "(?<=\\W|^)\\p{Punct}+(?=\\W|$)");
    private Pattern compiledIgnorePattern;

    public ExcessiveStepCheck() {
        super(ManualTestCase.class);
    }

    private String preprocessText(String text) {
        Matcher matcher = this.compiledIgnorePattern.matcher(text);
        return matcher.replaceAll("");
    }

    private void checkWordCount(ManualTestCase testCase, ManualTestCase.TestStep step, @Nullable String text, boolean isAction, String nameForMessage, IntPredicate isOverThreshold) {
        if (text == null) {
            return;
        }
        int numberOfWords = SimpleNLPUtils.splitIntoWords((String)this.preprocessText(text)).size();
        if (isOverThreshold.test(numberOfWords)) {
            this.buildFinding("Excessive step: %s with %d words".formatted(nameForMessage, numberOfWords), this.buildLocation().forTestStep(testCase, step, 0, text.length() - 1, isAction)).addFindingProperties(FindingPropertyList.singleton((String)"Length in Words", (String)String.valueOf(numberOfWords))).createAndStore();
        }
    }

    public void initialize() throws CheckException {
        StringJoiner combinedPattern = new StringJoiner(")|(", "(", ")");
        this.ignorePatterns.forEach(combinedPattern::add);
        this.compiledIgnorePattern = Pattern.compile(combinedPattern.toString());
    }

    @Override
    public void execute(ManualTestCase testCase) throws CheckException {
        for (ManualTestCase.TestStep step : testCase.getTestSteps()) {
            this.checkWordCount(testCase, step, step.getAction(), true, "action", n -> n > this.maxActionWords);
            this.checkWordCount(testCase, step, step.getCheck(), false, "check", n -> n > this.maxCheckWords);
        }
    }
}

