/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.EDefaultSpecItemLinkRole;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class LinkRule {
    private static final Pattern ITEM_SPLIT_PATTERN = Pattern.compile("|", 16);
    private static final Pattern LINK_RULE_PATTERN = Pattern.compile("\\((?<sourceItems>[^)]*)\\)\\s*--\\[(?<relations>[^]]*)]->\\s*\\((?<targetItems>[^)]*)\\)");
    private final Set<String> sourceItems;
    private final Set<String> relations;
    private final Set<String> targetItems;

    private LinkRule(Set<String> sourceItems, Set<String> relations, Set<String> targetItems) {
        this.sourceItems = sourceItems;
        this.relations = relations;
        this.targetItems = targetItems;
    }

    public static LinkRule parse(String ruleDefinition) throws CheckException {
        Matcher matcher = LINK_RULE_PATTERN.matcher(ruleDefinition);
        if (!matcher.matches()) {
            throw new CheckException("Unable to parse rule definition \"%s\", must match the following pattern: %s".formatted(ruleDefinition, LINK_RULE_PATTERN.pattern()));
        }
        Set<String> sourceItems = LinkRule.getItemsFromGroup(matcher, "sourceItems");
        Set<String> relations = LinkRule.getItemsFromGroup(matcher, "relations");
        Set<String> targetItems = LinkRule.getItemsFromGroup(matcher, "targetItems");
        return new LinkRule(sourceItems, relations, targetItems);
    }

    public static List<LinkRule> parse(Collection<String> ruleDefinitions) throws CheckException {
        ArrayList<LinkRule> parsedRules = new ArrayList<LinkRule>();
        for (String ruleDefinition : ruleDefinitions) {
            LinkRule parse = LinkRule.parse(ruleDefinition);
            parsedRules.add(parse);
        }
        return parsedRules;
    }

    private static @NonNull Set<String> getItemsFromGroup(Matcher matcher, String group) {
        String content = matcher.group(group);
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptySet();
        }
        Set collect = Arrays.stream(ITEM_SPLIT_PATTERN.split(content)).filter(Predicate.not(String::isBlank)).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(collect);
    }

    public Set<String> getSourceItems() {
        return this.sourceItems;
    }

    public Set<String> getRelations() {
        return this.relations;
    }

    public Set<String> getTargetItems() {
        return this.targetItems;
    }

    public boolean isViolatedBy(SpecItem item, ICheckContext context) throws CheckException {
        if (!this.hasSourceItemType(item)) {
            return false;
        }
        Collection<String> relationsToCheck = this.getRelationsToCheck(item);
        if (this.targetItems.isEmpty()) {
            return relationsToCheck.stream().map(r -> LinkRule.getLinkedIssueIds(item, r)).allMatch(List::isEmpty);
        }
        for (String relation : relationsToCheck) {
            List<TeamscaleIssueId> linkedItemIds = LinkRule.getLinkedIssueIds(item, relation);
            for (TeamscaleIssueId linkedItemId : linkedItemIds) {
                Optional linkedItem = context.getWorkItemForId(linkedItemId, SpecItem.class);
                if (!linkedItem.filter(this::hasTargetItemType).isPresent()) continue;
                return false;
            }
        }
        return true;
    }

    private static List<TeamscaleIssueId> getLinkedIssueIds(SpecItem item, String relation) {
        if ("parent".equalsIgnoreCase(relation)) {
            return Stream.concat(item.getParentId().stream(), item.getAdditionalParents().stream()).toList();
        }
        return item.getLinkedSpecItems(relation);
    }

    private Collection<String> getRelationsToCheck(SpecItem item) {
        if (this.relations.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(item.getLinkRoles());
            result.add("parent");
            return result;
        }
        return this.relations;
    }

    public String buildFindingMessage(SpecItem specItem) {
        StringBuilder result = new StringBuilder("Traceability Violation: ");
        result.append(specItem.getHumanReadableType()).append(" must have a relation");
        LinkRule.listTypes(this.relations, result);
        result.append(" to any item");
        LinkRule.listTypes(this.targetItems, result);
        return result.toString();
    }

    private static void listTypes(Set<String> types, StringBuilder into) {
        if (!types.isEmpty()) {
            into.append(" of type ").append(StringUtils.joinDifferentLastDelimiter(types.stream().map(type -> "'" + type + "'").toList(), (String)", ", (String)" or "));
        }
    }

    public boolean hasTargetItemType(SpecItem item) {
        return LinkRule.itemHasType(item, this.targetItems);
    }

    public boolean hasSourceItemType(SpecItem item) {
        return LinkRule.itemHasType(item, this.sourceItems);
    }

    private static boolean itemHasType(SpecItem item, Set<String> possibleTypes) {
        if (possibleTypes.contains("*")) {
            return true;
        }
        if (possibleTypes.isEmpty()) {
            return true;
        }
        TeamscaleIssueTypeInfo typeInfo = item.getTypeInfo();
        if (typeInfo == null) {
            return possibleTypes.contains(item.getWorkItemType().getHumanReadable());
        }
        return possibleTypes.contains(typeInfo.getType()) || possibleTypes.contains(typeInfo.getTypeAbbreviation());
    }

    public LinkRule inverse() {
        CCSMAssert.isNotNull(this.getRelations());
        List inverseRelations = EDefaultSpecItemLinkRole.getOppositesOf(this.getRelations());
        return new LinkRule(this.getTargetItems(), Set.copyOf(inverseRelations), this.getSourceItems());
    }
}

