/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.VssRestResponse;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.client.model.ProxyAuthenticationRequiredException;
import com.microsoft.alm.client.model.VssException;
import com.microsoft.alm.client.model.VssServiceException;
import com.microsoft.alm.client.model.VssServiceResponseException;
import com.microsoft.alm.client.utils.JsonHelper;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.WrappedException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public abstract class VssHttpClientBase {
    public static final String VSS_HTTP_METHOD_OVERRIDE_PROPERTY = "VSS_HTTP_METHOD_OVERRIDE";
    private final URI baseUrl;
    private static final Properties clientProperties = new Properties();
    private final VssRestClientHandler clientHandler;

    protected VssHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        this.baseUrl = baseUrl;
        this.clientHandler = clientHandler;
        this.clientHandler.init(this.getOverrideSetting(), clientProperties.getProperty("version"), baseUrl);
    }

    protected boolean getOverrideSetting() {
        String overrideEnabledEnvVar = System.getProperty(VSS_HTTP_METHOD_OVERRIDE_PROPERTY);
        if (!StringUtil.isNullOrEmpty(overrideEnabledEnvVar)) {
            return Boolean.valueOf(overrideEnabledEnvVar);
        }
        return true;
    }

    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return null;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public Exception getLastExecutionException() {
        return this.clientHandler.getLastException();
    }

    public boolean checkConnection() {
        return this.clientHandler.checkConnection();
    }

    protected VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, Map<String, String> queryParameters) {
        return this.createRequest(method, locationId, routeValues, version, null, null, queryParameters, "application/json");
    }

    protected VssRestRequest createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, String acceptMediaType) {
        return this.createRequest(method, locationId, null, version, null, null, null, acceptMediaType);
    }

    protected VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, String acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, null, null, null, acceptMediaType);
    }

    protected VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, Map<String, String> queryParameters, String acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, null, null, queryParameters, acceptMediaType);
    }

    protected VssRestRequest createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, Map<String, String> queryParameters, String acceptMediaType) {
        return this.createRequest(method, locationId, null, version, null, null, queryParameters, acceptMediaType);
    }

    protected <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, TEntity value, String contentMediaType, String acceptMediaType) {
        return this.createRequest(method, locationId, null, version, value, contentMediaType, null, acceptMediaType);
    }

    protected <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, String contentMediaType, String acceptMediaType) {
        return this.createRequest(method, locationId, routeValues, version, value, contentMediaType, null, acceptMediaType);
    }

    protected <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        return this.createRequest(method, locationId, null, version, value, contentMediaType, queryParameters, acceptMediaType);
    }

    protected <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, Map<String, String> queryParameters) {
        return this.createRequest(method, locationId, routeValues, version, value, "application/json", queryParameters, "application/json");
    }

    public <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        return this.clientHandler.createRequest(method, locationId, routeValues, version, value, contentMediaType, queryParameters, acceptMediaType);
    }

    public VssRestResponse sendRequest(VssRestRequest request) {
        VssRestResponse response = request.sendRequest();
        this.handleResponse(response);
        return response;
    }

    public <TResult> TResult sendRequest(VssRestRequest request, Class<TResult> resultClass) {
        VssRestResponse response = this.sendRequest(request);
        return response.readEntity(resultClass);
    }

    public <TResult> TResult sendRequest(VssRestRequest request, TypeReference<TResult> resultClass) {
        VssRestResponse response = this.sendRequest(request);
        return response.readEntity(resultClass);
    }

    private void handleResponse(VssRestResponse response) {
        if (response.isProxyAuthRequired()) {
            throw new ProxyAuthenticationRequiredException();
        }
        if (!response.isSuccessResponse()) {
            Throwable exceptionToThrow = null;
            if (response.isJsonResponse()) {
                WrappedException wrappedException = response.readEntity(WrappedException.class);
                exceptionToThrow = wrappedException.Unwrap(this.getTranslatedExceptions());
            }
            if (exceptionToThrow == null || !(exceptionToThrow instanceof VssException)) {
                String statusText;
                String tfsServiceError;
                String message = null;
                if (exceptionToThrow != null) {
                    message = exceptionToThrow.getMessage();
                }
                if (!StringUtil.isNullOrEmpty(tfsServiceError = response.getHeader("X-TFS-ServiceError"))) {
                    try {
                        message = URLDecoder.decode(tfsServiceError, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else if (StringUtil.isNullOrEmpty(message) && !StringUtil.isNullOrEmpty(statusText = response.getStatusText())) {
                    message = statusText;
                }
                exceptionToThrow = new VssServiceResponseException(response.getStatusCode(), message, (Exception)exceptionToThrow);
            }
            throw (VssException)exceptionToThrow;
        }
    }

    protected void addModelAsQueryParams(NameValueCollection queryParams, Object model) {
        if (model != null) {
            Map<String, String> jSearchCriteria = JsonHelper.toQueryParametersMap(model);
            for (Map.Entry<String, String> property : jSearchCriteria.entrySet()) {
                if (StringUtil.isNullOrEmpty(property.getValue())) continue;
                queryParams.addIfNotEmpty(property.getKey(), property.getValue());
            }
        }
    }

    private static void loadClientProperties() {
        try {
            InputStream in = VssHttpClientBase.class.getResourceAsStream("client.properties");
            clientProperties.load(in);
            in.close();
        }
        catch (Exception ex) {
            throw new VssServiceException(ex.getMessage(), ex);
        }
    }

    static {
        VssHttpClientBase.loadClientProperties();
    }
}

