/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.BuildService2008;
import com.microsoft.tfs.core.clients.build.IBuildControllerSpec;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildDetailSpec;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IQueuedBuildSpec;
import com.microsoft.tfs.core.clients.build.flags.BuildReason2010;
import com.microsoft.tfs.core.clients.build.flags.BuildServerVersion;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus2010;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryDeletedOption;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions2010;
import com.microsoft.tfs.core.clients.build.flags.QueueOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueOptions2010;
import com.microsoft.tfs.core.clients.build.internal.BuildGroupQueryResult2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgentSpec2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildControllerQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSpec2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDeletionResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDeletionResult2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetailSpec2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildGroupItemSpec2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueryResult2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueSpec;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueSpec2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildRequest2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildUpdateOptions2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.InformationChangeRequest2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.RetentionPolicy2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.Agent2008Status;
import com.microsoft.tfs.core.clients.build.soapextensions.ContinuousIntegrationType;
import com.microsoft.tfs.core.clients.build.soapextensions.ControllerStatus;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class TFS2008Helper {
    private final BuildServer buildServer;
    private final BuildService2008 buildService;

    public TFS2008Helper(BuildServer buildServer) {
        this.buildServer = buildServer;
        this.buildService = new BuildService2008(buildServer.getConnection());
    }

    public static ControllerStatus convert(Agent2008Status status) {
        if (status.equals(Agent2008Status.ENABLED)) {
            return ControllerStatus.AVAILABLE;
        }
        return ControllerStatus.UNAVAILABLE;
    }

    public static BuildAgentSpec2008 convert(IBuildControllerSpec spec, String defaultTeamProjectName) {
        BuildAgentSpec2008 spec2008 = new BuildAgentSpec2008();
        String[] parts = StringUtil.splitRemoveEmpties(spec.getName(), "\\\\");
        if (parts.length == 2) {
            spec2008.setTeamProject(parts[0]);
            spec2008.setName(parts[1]);
        } else {
            if (StringUtil.isNullOrEmpty(defaultTeamProjectName)) {
                defaultTeamProjectName = "*";
            }
            spec2008.setTeamProject(defaultTeamProjectName);
            spec2008.setName(spec.getName());
        }
        return spec2008;
    }

    public static BuildDefinition convert(BuildServer buildServer, BuildDefinition2010 definition) {
        return TFS2010Helper.convert((IBuildServer)buildServer, definition);
    }

    public static BuildDefinitionSpec2010 convert(IBuildDefinitionSpec spec) {
        BuildDefinitionSpec2010 spec2010 = TFS2010Helper.convert(spec);
        spec2010.setOptions(TFS2008Helper.convert(spec2010.getOptions()));
        return spec2010;
    }

    public static BuildGroupItemSpec2010[] convert(BuildServer buildServer, IBuildControllerSpec[] specs) {
        BuildGroupItemSpec2010[] newSpecs = new BuildGroupItemSpec2010[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            newSpecs[i] = TFS2008Helper.convert(specs[i], "");
        }
        return newSpecs;
    }

    public static BuildDefinition2010 convert(BuildServer buildServer, BuildDefinition definition) {
        if (definition == null) {
            return null;
        }
        definition.prepareToSave();
        BuildDefinition2010 oldDefinition = new BuildDefinition2010(BuildServerVersion.V2, definition);
        for (RetentionPolicy2010 policy : oldDefinition.getRetentionPolicies()) {
            if (policy.getBuildReason().equals(BuildReason2010.ALL)) continue;
            String format = Messages.getString("TFS2008Helper.RetentionNotSupportedFormat");
            String message = MessageFormat.format(format, buildServer.getDisplayText(policy.getBuildReason()));
            throw new NotSupportedException(message);
        }
        return oldDefinition;
    }

    public BuildDefinition2010[] convert(BuildDefinition[] definitions) {
        BuildDefinition2010[] newDefinitions = new BuildDefinition2010[definitions.length];
        for (int i = 0; i < definitions.length; ++i) {
            newDefinitions[i] = TFS2008Helper.convert(this.buildServer, definitions[i]);
        }
        return newDefinitions;
    }

    public static BuildDefinition[] convert(BuildServer buildServer, BuildDefinition2010[] definitions) {
        BuildDefinition[] newResults = TFS2010Helper.convert((IBuildServer)buildServer, definitions);
        return newResults;
    }

    public static BuildGroupItemSpec2010[] convert(IBuildDefinitionSpec[] specs) {
        BuildGroupItemSpec2010[] newSpecs = new BuildGroupItemSpec2010[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            newSpecs[i] = TFS2008Helper.convert(specs[i]);
        }
        return newSpecs;
    }

    public static BuildDetail convert(BuildServer buildServer, BuildDetail2010 build) {
        return TFS2010Helper.convert((IBuildServer)buildServer, build);
    }

    public static BuildDetail[] convert(BuildServer buildServer, BuildDetail2010[] builds) {
        BuildDetail[] newResults = TFS2010Helper.convert((IBuildServer)buildServer, builds);
        return newResults;
    }

    public static BuildDetailSpec2010 convert(BuildServer buildServer, IBuildDetailSpec spec) {
        BuildDetailSpec2010 spec2010 = TFS2010Helper.convert((IBuildServer)buildServer, spec);
        spec2010.setQueryOptions(TFS2008Helper.convert(spec2010.getQueryOptions()));
        spec2010.setStatus(TFS2008Helper.convert(spec2010.getStatus()));
        return spec2010;
    }

    public static BuildDetailSpec2010[] convert(BuildServer buildServer, IBuildDetailSpec[] specs) {
        BuildDetailSpec2010[] newSpecs = new BuildDetailSpec2010[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            newSpecs[i] = TFS2008Helper.convert(buildServer, specs[i]);
        }
        return newSpecs;
    }

    public static BuildDeletionResult[] convert(BuildDeletionResult2010[] results) {
        BuildDeletionResult[] newResults = TFS2010Helper.convert(results);
        return newResults;
    }

    public void convert(BuildAgent2008[] agents, AtomicReference<BuildController[]> outControllers, AtomicReference<BuildServiceHost[]> outServiceHosts) {
        ArrayList<BuildController> controllers = new ArrayList<BuildController>();
        ArrayList<BuildServiceHost> serviceHosts = new ArrayList<BuildServiceHost>();
        if (agents == null) {
            return;
        }
        for (BuildAgent2008 agent2008 : agents) {
            if (agent2008 == null) {
                controllers.add(null);
                continue;
            }
            controllers.add(new BuildController((IBuildServer)this.buildServer, agent2008));
            serviceHosts.add(new BuildServiceHost((IBuildServer)this.buildServer, agent2008));
        }
        outControllers.set(controllers.toArray(new BuildController[controllers.size()]));
        outServiceHosts.set(serviceHosts.toArray(new BuildServiceHost[serviceHosts.size()]));
    }

    public BuildControllerQueryResult convertToControllerResult(BuildGroupQueryResult2008 result) {
        AtomicReference<BuildController[]> outControllers = new AtomicReference<BuildController[]>();
        AtomicReference<BuildServiceHost[]> outServiceHosts = new AtomicReference<BuildServiceHost[]>();
        this.convert(result.getAgents(), outControllers, outServiceHosts);
        return new BuildControllerQueryResult(this.buildServer, new BuildAgent[0], outControllers.get(), outServiceHosts.get());
    }

    public BuildControllerQueryResult[] convertToControllerResult(BuildGroupQueryResult2008[] results) {
        BuildControllerQueryResult[] newResults = new BuildControllerQueryResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = this.convertToControllerResult(results[i]);
        }
        return newResults;
    }

    public BuildDefinitionQueryResult convertToDefinitionResult(BuildGroupQueryResult2008 result) {
        AtomicReference<BuildController[]> outControllers = new AtomicReference<BuildController[]>();
        AtomicReference<BuildServiceHost[]> outServiceHosts = new AtomicReference<BuildServiceHost[]>();
        this.convert(result.getAgents(), outControllers, outServiceHosts);
        BuildDefinition[] definitions = TFS2008Helper.convert(this.buildServer, result.getDefinitions());
        return new BuildDefinitionQueryResult(this.buildServer, new BuildAgent[0], outControllers.get(), definitions, outServiceHosts.get());
    }

    public BuildDefinitionQueryResult[] convertToDefinitionResult(BuildGroupQueryResult2008[] results) {
        BuildDefinitionQueryResult[] newResults = new BuildDefinitionQueryResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = this.convertToDefinitionResult(results[i]);
        }
        return newResults;
    }

    public static BuildInformationNode[] convert(BuildInformationNode2010[] nodes) {
        return TFS2010Helper.convert(nodes);
    }

    public static QueryOptions2010 convert(QueryOptions options) {
        return TFS2008Helper.convert(TFS2010Helper.convert(options));
    }

    public static QueryOptions2010 convert(QueryOptions2010 options) {
        if (options.contains(QueryOptions2010.CONTROLLERS)) {
            options = options.remove(QueryOptions2010.CONTROLLERS);
            options = options.combine(QueryOptions2010.AGENTS);
        }
        if (options.contains(QueryOptions2010.PROCESS)) {
            options = options.remove(QueryOptions2010.PROCESS);
            options = options.combine(QueryOptions2010.DEFINITIONS);
        }
        return options;
    }

    public BuildQueryResult convert(BuildQueryResult2008 result) {
        AtomicReference<BuildController[]> outControllers = new AtomicReference<BuildController[]>();
        AtomicReference<BuildServiceHost[]> outServiceHosts = new AtomicReference<BuildServiceHost[]>();
        this.convert(result.getAgents(), outControllers, outServiceHosts);
        BuildDefinition[] definitions = TFS2008Helper.convert(this.buildServer, result.getDefinitions());
        BuildDetail[] builds = TFS2008Helper.convert(this.buildServer, result.getBuilds());
        return new BuildQueryResult(this.buildServer, new BuildAgent[0], outControllers.get(), definitions, builds, outServiceHosts.get());
    }

    public BuildQueryResult[] convert(BuildQueryResult2008[] results) {
        BuildQueryResult[] newResults = new BuildQueryResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = this.convert(results[i]);
        }
        return newResults;
    }

    public BuildQueueQueryResult convert(BuildQueueQueryResult2008 result) {
        AtomicReference<BuildController[]> outControllers = new AtomicReference<BuildController[]>();
        AtomicReference<BuildServiceHost[]> outServiceHosts = new AtomicReference<BuildServiceHost[]>();
        this.convert(result.getAgents(), outControllers, outServiceHosts);
        BuildDefinition[] definitions = TFS2008Helper.convert(this.buildServer, result.getDefinitions());
        QueuedBuild[] queuedBuilds = TFS2008Helper.convert(this.buildServer, result.getBuilds());
        return new BuildQueueQueryResult(this.buildServer, new BuildAgent[0], outControllers.get(), definitions, queuedBuilds, outServiceHosts.get(), new BuildDetail[0]);
    }

    public BuildQueueQueryResult[] convert(BuildQueueQueryResult2008[] results) {
        BuildQueueQueryResult[] newResults = new BuildQueueQueryResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = this.convert(results[i]);
        }
        return newResults;
    }

    public BuildRequest2008 convert(BuildRequest request) {
        return new BuildRequest2008(request);
    }

    public static BuildStatus2010 convert(BuildStatus2010 status) {
        if (status.equals(BuildStatus2010.ALL)) {
            status = status.remove(BuildStatus2010.NOT_STARTED);
        } else if (status.equals(BuildStatus2010.NONE)) {
            status = BuildStatus2010.NOT_STARTED;
        }
        return status;
    }

    public static BuildUpdateOptions2010 convert(BuildUpdateOptions update) {
        BuildUpdateOptions2010 options2010 = TFS2010Helper.convert(update);
        options2010.getWebServiceObject().setStatus(TFS2008Helper.convert(options2010.getStatus()).getWebServiceObject());
        return options2010;
    }

    public static BuildUpdateOptions2010[] convert(BuildUpdateOptions[] updates) {
        BuildUpdateOptions2010[] newUpdates = new BuildUpdateOptions2010[updates.length];
        for (int i = 0; i < updates.length; ++i) {
            newUpdates[i] = TFS2008Helper.convert(updates[i]);
        }
        return newUpdates;
    }

    public static InformationChangeRequest2010[] convert(InformationChangeRequest[] requests) {
        InformationChangeRequest2010[] newResults = TFS2010Helper.convert(requests);
        return newResults;
    }

    public static QueuedBuild convert(BuildServer buildServer, QueuedBuild2008 queuedBuild) {
        if (queuedBuild == null) {
            return null;
        }
        return new QueuedBuild(buildServer, queuedBuild);
    }

    public static QueuedBuild[] convert(BuildServer buildServer, QueuedBuild2008[] builds) {
        QueuedBuild[] newBuilds = new QueuedBuild[builds.length];
        for (int i = 0; i < builds.length; ++i) {
            newBuilds[i] = TFS2008Helper.convert(buildServer, builds[i]);
        }
        return newBuilds;
    }

    public BuildDefinition[] addBuildDefinitions(BuildDefinition[] definitions) {
        BuildDefinition2010[] results = this.buildService.addBuildDefinitions(this.convert(definitions));
        return TFS2008Helper.convert(this.buildServer, results);
    }

    public void addBuildQualities(String teamProject, String[] qualities) {
        this.buildService.addBuildQualities(teamProject, qualities);
    }

    public void cancelBuilds(int[] ids) {
        this.buildService.cancelBuilds(ids);
    }

    public void deleteBuildQualities(String teamProject, String[] qualities) {
        this.buildService.deleteBuildQualities(teamProject, qualities);
    }

    public BuildDeletionResult[] deleteBuilds(String[] uris, DeleteOptions options) {
        return TFS2008Helper.convert(this.buildService.deleteBuilds(uris));
    }

    public void DeleteBuildAgents(String[] agentUris) {
        this.buildService.deleteBuildAgents(agentUris);
    }

    public void deleteBuildDefinitions(String[] definitionUris) {
        this.buildService.deleteBuildDefinitions(definitionUris);
    }

    public void evaluateSchedules() {
        this.buildService.evaluateSchedules();
    }

    public BuildDefinition[] getAffectedBuildDefinitions(String[] serverItems, DefinitionTriggerType triggerType) {
        ContinuousIntegrationType ciType = TFS2010Helper.convert(triggerType);
        BuildDefinition2010[] definitions = this.buildService.getAffectedBuildDefinitions(serverItems);
        ArrayList<BuildDefinition> list = new ArrayList<BuildDefinition>();
        for (int i = 0; i < definitions.length; ++i) {
            if (!definitions[i].getContinuousIntegrationType().contains(ciType)) continue;
            list.add(TFS2008Helper.convert(this.buildServer, definitions[i]));
        }
        return list.toArray(new BuildDefinition[list.size()]);
    }

    public String[] getBuildQualities(String teamProject) {
        return this.buildService.getBuildQualities(teamProject);
    }

    public BuildControllerQueryResult[] queryBuildControllers(IBuildControllerSpec[] specs) {
        BuildGroupQueryResult2008[] results = this.buildService.queryBuildGroups(TFS2008Helper.convert(this.buildServer, specs));
        return this.convertToControllerResult(results);
    }

    public BuildControllerQueryResult queryBuildControllersByUri(String[] uris, boolean includeAgents) {
        BuildAgent2008[] results = this.buildService.queryBuildAgentsByUri(uris);
        AtomicReference<BuildController[]> outControllers = new AtomicReference<BuildController[]>();
        AtomicReference<BuildServiceHost[]> outServiceHosts = new AtomicReference<BuildServiceHost[]>();
        this.convert(results, outControllers, outServiceHosts);
        return new BuildControllerQueryResult(this.buildServer, new BuildAgent[0], outControllers.get(), outServiceHosts.get());
    }

    public BuildDefinitionQueryResult[] queryBuildDefinitions(IBuildDefinitionSpec[] specs) {
        BuildGroupQueryResult2008[] results = this.buildService.queryBuildGroups(TFS2008Helper.convert(specs));
        return this.convertToDefinitionResult(results);
    }

    public BuildDefinitionQueryResult queryBuildDefinitionsByUri(String[] uris) {
        BuildGroupQueryResult2008 result = this.buildService.queryBuildDefinitionsByUri(uris);
        return this.convertToDefinitionResult(result);
    }

    public BuildQueryResult[] queryBuilds(IBuildDetailSpec[] specs) {
        BuildQueryResult2008[] results = this.buildService.queryBuilds(TFS2008Helper.convert(this.buildServer, specs));
        return this.convert(results);
    }

    public IBuildDetail[] queryBuildsByUri(String[] uris, String[] informationTypes, QueryOptions queryOptions, QueryDeletedOption queryDeletedOption) {
        BuildQueryResult2008 result = this.buildService.queryBuildsByUri(uris, informationTypes, TFS2008Helper.convert(queryOptions));
        return this.convert(result).getBuilds();
    }

    public BuildDetail[] updateBuilds(BuildUpdateOptions[] updates) {
        BuildDetail2010[] results = this.buildService.updateBuilds(TFS2008Helper.convert(updates));
        return TFS2008Helper.convert(this.buildServer, results);
    }

    public BuildDefinition[] updateBuildDefinitions(BuildDefinition[] definitions) {
        BuildDefinition2010[] results = this.buildService.updateBuildDefinitions(this.convert(definitions));
        return TFS2008Helper.convert(this.buildServer, results);
    }

    public void ProcessChangeset(int changesetId) {
        this.buildService.processChangeset(changesetId);
    }

    public BuildQueueQueryResult[] queryQueuedBuilds(IQueuedBuildSpec[] specs) {
        BuildQueueSpec2008[] oldSpecs = new BuildQueueSpec2008[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            oldSpecs[i] = new BuildQueueSpec2008((BuildQueueSpec)specs[i]);
        }
        BuildQueueQueryResult2008[] results = this.buildService.queryBuildQueue(oldSpecs);
        BuildQueueQueryResult[] newResults = new BuildQueueQueryResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = this.convert(results[i]);
        }
        return newResults;
    }

    public BuildQueueQueryResult queryQueuedBuildsById(int[] queuedBuildIds, QueryOptions queryOptions) {
        BuildQueueQueryResult2008 result = this.buildService.queryBuildQueueById(queuedBuildIds, TFS2008Helper.convert(queryOptions));
        return this.convert(result);
    }

    public QueuedBuild queueBuild(BuildRequest request, QueueOptions options) {
        BuildRequest2008 request2008 = this.convert(request);
        QueueOptions2010 options2010 = TFS2010Helper.convert(options);
        QueuedBuild2008 result = this.buildService.queueBuild(request2008, options2010);
        QueuedBuild queuedBuild = TFS2008Helper.convert(this.buildServer, result);
        queuedBuild.setBuildDefinition(request.getBuildDefinition());
        if (queuedBuild.getBuild() != null) {
            ((BuildDetail)queuedBuild.getBuild()).setBuildDefinition(request.getBuildDefinition());
        }
        return queuedBuild;
    }

    public void stopBuilds(String[] uris) {
        this.buildService.stopBuilds(uris);
    }

    public QueuedBuild[] updateQueuedBuilds(QueuedBuildUpdateOptions[] updates) {
        QueuedBuild2008[] results = this.buildService.updateQueuedBuilds(TFS2010Helper.convert(updates));
        QueuedBuild[] newResults = new QueuedBuild[results.length];
        for (int i = 0; i < results.length; ++i) {
            newResults[i] = TFS2008Helper.convert(this.buildServer, results[i]);
        }
        return newResults;
    }

    public BuildInformationNode[] updateBuildInformation(InformationChangeRequest[] requests) {
        return TFS2008Helper.convert(this.buildService.updateBuildInformation(TFS2008Helper.convert(requests)));
    }
}

