/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.LocalWorkspaceState;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.SavedCheckin;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalServerInfo;
import com.microsoft.tfs.core.ws.runtime.xml.XMLConvert;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class WorkspaceInfo
implements Comparable<WorkspaceInfo> {
    private static final Log log = LogFactory.getLog(WorkspaceInfo.class);
    private static final String XML_WORKSPACE_INFO = "WorkspaceInfo";
    private static final String XML_NAME = "name";
    private static final String XML_OWNER_NAME = "ownerName";
    private static final String XML_OWNER_DISPLAY_NAME = "ownerDisplayName";
    private static final String XML_OWNER_ALIASES = "OwnerAliases";
    private static final String XML_OWNER_ALIAS = "OwnerAlias";
    private static final String XML_COMPUTER = "computer";
    private static final String XML_COMMENT = "comment";
    private static final String XML_IS_LOCAL_WORKSPACE = "isLocalWorkspace";
    private static final String XML_MAPPED_PATHS = "MappedPaths";
    private static final String XML_MAPPED_PATH = "MappedPath";
    private static final String XML_WORKING_FOLDERS = "WorkingFolders";
    private static final String XML_MAP = "Map";
    private static final String XML_PATH = "path";
    private static final String XML_LOCAL_PATH = "local";
    private static final String XML_SECURITY_TOKEN = "securityToken";
    private static final String XML_LAST_SAVED_CHECKIN = "LastSavedCheckin";
    private static final String XML_LAST_SAVED_CHECKIN_TIME_STAMP = "LastSavedCheckinTimeStamp";
    private static final String OPTIONS_NAME = "options";
    private InternalServerInfo serverInfo;
    private String name;
    private String ownerName;
    private String ownerDisplayName;
    private String computer;
    private String[] ownerAliases;
    private String comment;
    private boolean isLocalWorkspace;
    private String securityToken;
    private String[] mappedPaths;
    private WorkspaceOptions options;
    private LocalWorkspaceState state;
    private SavedCheckin lastSavedCheckin;
    private Calendar lastSavedCheckinTimeStamp;

    public WorkspaceInfo(InternalServerInfo serverInfo, Workspace workspace) {
        Check.notNull(serverInfo, "serverInfo");
        Check.notNull(workspace, "workspace");
        this.serverInfo = serverInfo;
        this.comment = workspace.getComment();
        this.computer = workspace.getComputer();
        this.isLocalWorkspace = workspace.getLocation() == WorkspaceLocation.LOCAL;
        this.name = workspace.getName();
        this.ownerName = workspace.getOwnerName();
        this.ownerDisplayName = workspace.getOwnerDisplayName();
        this.securityToken = workspace.getSecurityToken();
        this.mappedPaths = WorkingFolder.extractMappedPaths(workspace.getFolders());
        this.options = workspace.getOptions();
        this.ownerAliases = workspace.getOwnerAliases() != null ? (String[])workspace.getOwnerAliases().clone() : new String[]{};
        this.state = LocalWorkspaceState.NEW;
        this.lastSavedCheckinTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.lastSavedCheckinTimeStamp.set(1, 0, 1, 0, 0, 0);
        this.lastSavedCheckinTimeStamp.set(14, 0);
        Check.isTrue(!this.name.equals(this.ownerName), MessageFormat.format("Something went wrong since name and owner are the same: {0}", this.toString()));
    }

    private WorkspaceInfo() {
    }

    public Workspace getWorkspace(TFSTeamProjectCollection collection) {
        Check.notNull(collection, "collection");
        return collection.getVersionControlClient().getLocalWorkspace(this.getName(), this.getOwnerName());
    }

    public String getMapping(String path) {
        int length = 0;
        String mappingFound = null;
        for (String map : this.getMappedPaths()) {
            if (!LocalPath.isChild(map, path) || map.length() <= length) continue;
            length = map.length();
            mappingFound = map;
        }
        return mappingFound;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkspaceInfo)) {
            return false;
        }
        WorkspaceInfo other = (WorkspaceInfo)obj;
        boolean isEqual = Workspace.matchName(this.getName(), other.getName()) && Workspace.matchOwner(this.getOwnerName(), other.getOwnerName()) && this.serverInfo.getServerGUID().equals(other.serverInfo.getServerGUID());
        Check.isTrue(!isEqual || this.hashCode() == other.hashCode(), "WorkspaceInfo is equal to another, but the hashcodes didn't match.");
        return isEqual;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + Workspace.hashName(this.getName());
        result = result * 37 + Workspace.hashOwner(this.getOwnerName());
        result = result * 37 + this.serverInfo.getServerGUID().hashCode();
        return result;
    }

    @Override
    public int compareTo(WorkspaceInfo other) {
        if (other == null) {
            return 1;
        }
        int result = 0;
        result = Workspace.compareServerURI(this.getServerURI(), other.getServerURI());
        if (result != 0) {
            return result;
        }
        result = Workspace.compareName(this.getName(), other.getName());
        if (result != 0) {
            return result;
        }
        return Workspace.compareOwner(this.getOwnerName(), other.getOwnerName());
    }

    public static WorkspaceInfo loadFromXML(InternalServerInfo serverInfo, Element workspaceInfoNode) {
        WorkspaceInfo workspaceInfo = new WorkspaceInfo();
        workspaceInfo.serverInfo = serverInfo;
        NamedNodeMap attributes = workspaceInfoNode.getAttributes();
        Check.notNull(attributes, "attributes");
        workspaceInfo.name = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_NAME));
        workspaceInfo.ownerName = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_OWNER_NAME));
        workspaceInfo.ownerDisplayName = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_OWNER_DISPLAY_NAME));
        if (StringUtil.isNullOrEmpty(workspaceInfo.ownerDisplayName)) {
            workspaceInfo.ownerDisplayName = workspaceInfo.getOwnerName();
        }
        workspaceInfo.computer = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_COMPUTER));
        workspaceInfo.comment = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_COMMENT));
        workspaceInfo.securityToken = WorkspaceInfo.getStringValue(attributes.getNamedItem(XML_SECURITY_TOKEN), null);
        workspaceInfo.isLocalWorkspace = WorkspaceInfo.getBooleanValue(attributes.getNamedItem(XML_IS_LOCAL_WORKSPACE));
        workspaceInfo.lastSavedCheckinTimeStamp = WorkspaceInfo.getTimeStampValue(attributes.getNamedItem(XML_LAST_SAVED_CHECKIN_TIME_STAMP));
        workspaceInfo.options = WorkspaceInfo.getWorkspaceOptionsValue(attributes.getNamedItem(OPTIONS_NAME));
        for (Element child : DOMUtils.getChildElements(workspaceInfoNode)) {
            String name = child.getNodeName();
            if (name.equals(XML_MAPPED_PATHS)) {
                Element[] mappedPathElements = DOMUtils.getChildElements(child, XML_MAPPED_PATH);
                workspaceInfo.mappedPaths = new String[mappedPathElements.length];
                for (int i = 0; i < mappedPathElements.length; ++i) {
                    workspaceInfo.mappedPaths[i] = WorkspaceInfo.getStringValue(mappedPathElements[i].getAttributes().getNamedItem(XML_PATH));
                }
                continue;
            }
            if (name.equals(XML_WORKING_FOLDERS)) {
                Element[] mapElements = DOMUtils.getChildElements(child, XML_MAP);
                workspaceInfo.mappedPaths = new String[mapElements.length];
                for (int i = 0; i < mapElements.length; ++i) {
                    workspaceInfo.mappedPaths[i] = WorkspaceInfo.getStringValue(mapElements[i].getAttributes().getNamedItem(XML_LOCAL_PATH));
                }
                workspaceInfo.state = LocalWorkspaceState.MODIFIED;
                continue;
            }
            if (name.equals(XML_LAST_SAVED_CHECKIN)) {
                Check.isTrue(DOMUtils.getChildElements(child, "SavedCheckin").length == 1, MessageFormat.format("Wrong number of LastSavedCheckin children: {0}", DOMUtils.getChildElements(child, "SavedCheckin").length));
                workspaceInfo.lastSavedCheckin = SavedCheckin.loadFromXML(DOMUtils.getFirstChildElement(child, "SavedCheckin"));
                continue;
            }
            if (name.equals(XML_OWNER_ALIASES)) {
                Element[] aliasNodes = DOMUtils.getChildElements(child, XML_OWNER_ALIAS);
                ArrayList<String> aliases = new ArrayList<String>(aliasNodes.length);
                for (int i = 0; i < aliasNodes.length; ++i) {
                    String alias = WorkspaceInfo.getStringValue(aliasNodes[i].getAttributes().getNamedItem(XML_OWNER_ALIAS));
                    if (!StringUtil.isNullOrEmpty(alias)) {
                        aliases.add(alias);
                        continue;
                    }
                    log.error((Object)MessageFormat.format("Owner alias loaded from cache was null or empty: {0}", workspaceInfo));
                }
                workspaceInfo.ownerAliases = aliases.toArray(new String[aliases.size()]);
                continue;
            }
            log.warn((Object)MessageFormat.format("Unknown workspace child node: {0}", name));
        }
        if (workspaceInfo.ownerAliases == null) {
            workspaceInfo.ownerAliases = new String[0];
        }
        workspaceInfo.markClean();
        return workspaceInfo;
    }

    private static String getStringValue(Node attrNode) {
        return WorkspaceInfo.getStringValue(attrNode, "");
    }

    private static String getStringValue(Node attrNode, String defaultValue) {
        if (attrNode == null) {
            return defaultValue;
        }
        return attrNode.getNodeValue();
    }

    private static boolean getBooleanValue(Node attrNode) {
        String v = WorkspaceInfo.getStringValue(attrNode, null);
        if (StringUtil.isNullOrEmpty(v)) {
            return false;
        }
        return Boolean.parseBoolean(v);
    }

    private static Calendar getTimeStampValue(Node attrNode) {
        String v = WorkspaceInfo.getStringValue(attrNode, null);
        if (StringUtil.isNullOrEmpty(v)) {
            return null;
        }
        return XMLConvert.toCalendar(v, true);
    }

    private static WorkspaceOptions getWorkspaceOptionsValue(Node attrNode) {
        String v = WorkspaceInfo.getStringValue(attrNode, null);
        if (StringUtil.isNullOrEmpty(v)) {
            return WorkspaceOptions.NONE;
        }
        try {
            return WorkspaceOptions.fromFlags(Integer.parseInt(v));
        }
        catch (NumberFormatException e) {
            log.warn((Object)MessageFormat.format("Exception parsing WorkspaceInfo options from ''{0}'', using WorkspaceOptions.NONE", v));
            return WorkspaceOptions.NONE;
        }
    }

    public void saveAsXML(Element parent) {
        Element workspaceInfoNode = DOMUtils.appendChild(parent, XML_WORKSPACE_INFO);
        workspaceInfoNode.setAttribute(XML_NAME, this.getName());
        workspaceInfoNode.setAttribute(XML_OWNER_NAME, this.getOwnerName());
        workspaceInfoNode.setAttribute(XML_OWNER_DISPLAY_NAME, this.getOwnerDisplayName());
        workspaceInfoNode.setAttribute(XML_COMPUTER, this.getComputer());
        workspaceInfoNode.setAttribute(XML_COMMENT, this.getComment());
        workspaceInfoNode.setAttribute(XML_IS_LOCAL_WORKSPACE, Boolean.toString(this.isLocalWorkspace).toLowerCase());
        workspaceInfoNode.setAttribute(XML_LAST_SAVED_CHECKIN_TIME_STAMP, XMLConvert.toString(this.lastSavedCheckinTimeStamp, true));
        workspaceInfoNode.setAttribute(OPTIONS_NAME, Integer.toString(this.options.toIntFlags()));
        if (null != this.securityToken) {
            workspaceInfoNode.setAttribute(XML_SECURITY_TOKEN, this.getSecurityToken());
        }
        Element mappedPathsNode = DOMUtils.appendChild(workspaceInfoNode, XML_MAPPED_PATHS);
        for (String path : this.mappedPaths) {
            Element mappedPathNode = DOMUtils.appendChild(mappedPathsNode, XML_MAPPED_PATH);
            mappedPathNode.setAttribute(XML_PATH, path);
        }
        if (this.lastSavedCheckin != null) {
            Element lastSavedCheckinNode = DOMUtils.appendChild(workspaceInfoNode, XML_LAST_SAVED_CHECKIN);
            this.lastSavedCheckin.saveAsXML(lastSavedCheckinNode);
        }
        if (this.ownerAliases != null) {
            Element ownerAliasesNode = DOMUtils.appendChild(workspaceInfoNode, XML_OWNER_ALIASES);
            for (String ownerAlias : this.ownerAliases) {
                Element ownerAliasNode = DOMUtils.appendChild(ownerAliasesNode, XML_OWNER_ALIAS);
                ownerAliasNode.setAttribute(XML_OWNER_ALIAS, ownerAlias);
            }
        }
    }

    public void markClean() {
        this.state = LocalWorkspaceState.CLEAN;
    }

    public String formatWorkspaceNameForException(WorkspaceInfo conflictingWorkspace) {
        Check.notNull(conflictingWorkspace, "conflictingWorkspace");
        String fullWorkspaceName = Workspace.compareOwner(this.getOwnerName(), conflictingWorkspace.getOwnerName()) == 0 ? conflictingWorkspace.getName() : new WorkspaceSpec(conflictingWorkspace.getName(), conflictingWorkspace.getOwnerName()).toString();
        if (!this.serverInfo.getServerGUID().equals(conflictingWorkspace.serverInfo.getServerGUID())) {
            fullWorkspaceName = MessageFormat.format("{0} [{1}]", fullWorkspaceName, conflictingWorkspace.serverInfo.getURI());
        }
        return fullWorkspaceName;
    }

    private void updateMappings(String[] mappedPaths, boolean fromCache) {
        Check.notNull(mappedPaths, "mappedPaths");
        if (WorkspaceInfo.areMappedPathSetsEqual(mappedPaths, this.mappedPaths)) {
            return;
        }
        this.mappedPaths = (String[])mappedPaths.clone();
        if (!fromCache) {
            this.setState(LocalWorkspaceState.MODIFIED);
        }
    }

    public static boolean areMappedPathSetsEqual(String[] set1, String[] set2) {
        int i;
        Check.notNull(set1, "set1");
        Check.notNull(set2, "set2");
        if (set1.length != set2.length) {
            return false;
        }
        Arrays.sort(set1);
        Arrays.sort(set2);
        for (i = 0; i < set1.length && LocalPath.equals(set1[i], set2[i]); ++i) {
        }
        return i == set1.length;
    }

    public static boolean areOwnerAliasesSetsEqual(String[] set1, String[] set2) {
        int i;
        Check.notNull(set1, "set1");
        Check.notNull(set2, "set2");
        if (set1.length != set2.length) {
            return false;
        }
        Arrays.sort(set1);
        Arrays.sort(set2);
        for (i = 0; i < set1.length && Workspace.matchOwner(set1[i], set2[i]); ++i) {
        }
        return i == set1.length;
    }

    public void update(WorkspaceInfo ws, boolean fromCache) {
        Check.isTrue(Workspace.matchName(ws.getName(), this.getName()), MessageFormat.format("Names must be the same: {0} vs. {1}", this.getName(), ws.getName()));
        Check.isTrue(ws.ownerNameMatches(this.getOwnerName()), MessageFormat.format("Owners must be the same: {0} vs. {1}", this.getOwnerName(), ws.getOwnerName()));
        Check.isTrue(ws.serverInfo.getServerGUID().equals(this.serverInfo.getServerGUID()), MessageFormat.format("Servers (guid) must be the same: {0} vs. {1}", this.serverInfo.getURI(), ws.serverInfo.getURI()));
        if (!this.getName().equals(ws.getName())) {
            this.name = ws.getName();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!this.getOwnerName().equals(ws.getOwnerName())) {
            this.ownerName = ws.getOwnerName();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!this.getOwnerDisplayName().equals(ws.getOwnerDisplayName())) {
            this.ownerDisplayName = ws.getOwnerDisplayName();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!Workspace.matchComment(ws.getComment(), this.getComment())) {
            this.comment = ws.getComment();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!Workspace.matchSecurityToken(ws.getSecurityToken(), this.getSecurityToken())) {
            this.securityToken = ws.getSecurityToken();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (ws.getLocation() != this.getLocation()) {
            this.isLocalWorkspace = ws.isLocalWorkspace;
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!Workspace.matchComputer(ws.getComputer(), this.getComputer())) {
            this.computer = ws.getComputer();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        ArrayList<String> mappingList = new ArrayList<String>(ws.mappedPaths.length);
        for (String mapping : ws.mappedPaths) {
            mappingList.add(mapping);
        }
        this.updateMappings(mappingList.toArray(new String[mappingList.size()]), fromCache);
        if (this.lastSavedCheckinTimeStamp.compareTo(ws.lastSavedCheckinTimeStamp) < 0) {
            this.lastSavedCheckin = ws.getLastSavedCheckin();
            this.lastSavedCheckinTimeStamp = ws.lastSavedCheckinTimeStamp;
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
        if (!WorkspaceInfo.areOwnerAliasesSetsEqual(ws.ownerAliases, this.ownerAliases)) {
            this.ownerAliases = (String[])ws.ownerAliases.clone();
            if (!fromCache) {
                this.setState(LocalWorkspaceState.MODIFIED);
            }
        }
    }

    public void copyLocalMetadata(WorkspaceInfo oldInfo) {
        this.lastSavedCheckin = oldInfo.lastSavedCheckin;
        this.lastSavedCheckinTimeStamp = oldInfo.lastSavedCheckinTimeStamp;
    }

    public String toString() {
        return MessageFormat.format("WorkspaceInfo [serverInfo={0}, name={1}, ownerName={2}, ownerDisplayName={3}, computer={4}, ownerAliases={5}, comment={6}, isLocalWorkspace={7}, securityToken={8}, mappedPaths={9}, options={10}, state={11}, lastSavedCheckin={12}, lastSavedCheckinTimeStamp={13}]", this.serverInfo, this.name, this.ownerName, this.ownerDisplayName, this.computer, Arrays.toString(this.ownerAliases), this.comment, this.isLocalWorkspace, this.securityToken, Arrays.toString(this.mappedPaths), this.options, this.state, this.lastSavedCheckin, this.lastSavedCheckinTimeStamp);
    }

    public boolean ownerNameMatches(String ownerName) {
        Check.notNullOrEmpty(ownerName, XML_OWNER_NAME);
        if (Workspace.matchOwner(ownerName, this.getOwnerName())) {
            return true;
        }
        String[] aliases = this.getOwnerAliases();
        if (aliases != null) {
            for (String aliasName : aliases) {
                if (!Workspace.matchOwner(aliasName, ownerName)) continue;
                return true;
            }
        }
        return false;
    }

    public URI getServerURI() {
        return this.serverInfo.getURI();
    }

    public GUID getServerGUID() {
        return this.serverInfo.getServerGUID();
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerDisplayName() {
        return this.ownerDisplayName;
    }

    public String[] getOwnerAliases() {
        return this.ownerAliases;
    }

    public String getDisplayName() {
        return new WorkspaceSpec(this.getName(), this.getOwnerDisplayName()).toString();
    }

    public String getQualifiedName() {
        return new WorkspaceSpec(this.getName(), this.getOwnerName()).toString();
    }

    public String getComputer() {
        return this.computer;
    }

    public String getComment() {
        return this.comment;
    }

    public WorkspaceLocation getLocation() {
        if (this.isLocalWorkspace) {
            return WorkspaceLocation.LOCAL;
        }
        return WorkspaceLocation.SERVER;
    }

    public String[] getMappedPaths() {
        return this.mappedPaths;
    }

    public SavedCheckin getLastSavedCheckin() {
        return this.lastSavedCheckin;
    }

    public void setLastSavedCheckin(SavedCheckin value, Workstation workstationToSave) {
        if (value == null && this.lastSavedCheckin == null) {
            return;
        }
        this.lastSavedCheckin = value;
        this.lastSavedCheckinTimeStamp = Calendar.getInstance();
        this.setState(LocalWorkspaceState.MODIFIED);
        workstationToSave.saveConfigIfDirty();
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public WorkspaceOptions getOptions() {
        return this.options;
    }

    public InternalServerInfo getServer() {
        return this.serverInfo;
    }

    public LocalWorkspaceState getState() {
        return this.state;
    }

    public void setState(LocalWorkspaceState newState) {
        if (newState.getValue() > this.state.getValue()) {
            this.state = newState;
        }
    }
}

