/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query.qe;

import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryGroupingImp;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.QEQueryRowImp;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQuery;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryGrouping;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRow;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRowCollection;
import com.microsoft.tfs.core.clients.workitem.query.qe.WIQLOperators;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class QEQueryRowCollectionImpl
implements QEQueryRowCollection {
    private final QEQueryImpl query;
    private final List<QEQueryRow> rows;
    private final QEQueryGroupingImp grouping;
    private final PropertyChangeListener rowPropertyChangeListener = new RowPropertyChangeListener();

    public QEQueryRowCollectionImpl(QEQueryImpl query) {
        this.query = query;
        this.rows = new ArrayList<QEQueryRow>();
        this.grouping = new QEQueryGroupingImp(query);
    }

    @Override
    public QEQuery getQuery() {
        return this.query;
    }

    @Override
    public QEQueryRow addRow() {
        return this.addRow(this.rows.size());
    }

    @Override
    public QEQueryRow addRow(int index) {
        QEQueryRowImp row = new QEQueryRowImp();
        row.addPropertyChangeListener(this.rowPropertyChangeListener);
        this.rows.add(index, row);
        this.grouping.addRow(index);
        this.query.notifyModifiedListeners();
        return row;
    }

    @Override
    public void addNewRow(int index) {
        QEQueryRow row = this.addRow(index);
        if (index == 0) {
            QEQueryRow secondRow;
            row.setLogicalOperator("");
            if (this.getRowCount() > 1 && ((secondRow = this.getRow(1)).getLogicalOperator() == null || secondRow.getLogicalOperator().trim().length() == 0)) {
                secondRow.setLogicalOperator(WIQLOperators.getLocalizedOperator("AND"));
            }
        } else {
            row.setLogicalOperator(WIQLOperators.getLocalizedOperator("AND"));
        }
        row.setOperator(WIQLOperators.getLocalizedOperator("="));
    }

    @Override
    public void deleteRow(QEQueryRow row) {
        int index = this.rows.indexOf(row);
        if (index == -1) {
            return;
        }
        this.grouping.removeRow(index);
        this.rows.remove(index);
        ((QEQueryRowImp)row).removePropertyChangeListener(this.rowPropertyChangeListener);
        this.query.notifyModifiedListeners();
    }

    @Override
    public QEQueryGrouping getGrouping() {
        return this.grouping;
    }

    @Override
    public QEQueryRow getRow(int index) {
        return this.rows.get(index);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public QEQueryRow[] getRows() {
        return this.rows.toArray(new QEQueryRow[this.rows.size()]);
    }

    @Override
    public int indexOf(QEQueryRow row) {
        return this.rows.indexOf(row);
    }

    private class RowPropertyChangeListener
    implements PropertyChangeListener {
        private RowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            QEQueryRowCollectionImpl.this.query.notifyModifiedListeners();
        }
    }
}

