/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.types;

import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPSerializationException;
import com.microsoft.tfs.core.ws.runtime.serialization.AttributeSerializable;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementSerializable;
import com.microsoft.tfs.core.ws.runtime.types.Flag;
import com.microsoft.tfs.core.ws.runtime.xml.XMLStreamReaderHelper;
import com.microsoft.tfs.util.Check;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class FlagSet
extends HashSet
implements AttributeSerializable,
ElementSerializable {
    public FlagSet() {
    }

    protected FlagSet(Flag[] flags) {
        for (int i = 0; i < flags.length; ++i) {
            this.add(flags[i]);
        }
    }

    protected FlagSet(String[] flagStrings) {
        Check.notNull(flagStrings, "flagStrings");
        for (int i = 0; i < flagStrings.length; ++i) {
            this.add(this.findFlagInstance(flagStrings[i].trim()));
        }
    }

    public void readFromAttribute(String value) throws XMLStreamException {
        if (value.length() == 0) {
            throw new XMLStreamException("Can't read a flag set from empty attribute value");
        }
        this.clear();
        String[] flagStrings = value.split(" ");
        for (int i = 0; i < flagStrings.length; ++i) {
            this.add(this.findFlagInstance(flagStrings[i].trim()));
        }
    }

    public void readFromElement(XMLStreamReader reader) throws XMLStreamException {
        this.readFromAttribute(reader.getText());
        XMLStreamReaderHelper.readUntilElementEnd(reader);
    }

    @Override
    public void writeAsAttribute(XMLStreamWriter writer, String name) throws XMLStreamException {
        writer.writeAttribute(name, this.toString());
    }

    @Override
    public void writeAsElement(XMLStreamWriter writer, String name) throws XMLStreamException {
        writer.writeStartElement(name);
        writer.writeCharacters(this.toString());
        writer.writeEndElement();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(((Flag)i.next()).name);
        }
        return sb.toString();
    }

    protected abstract Flag findFlagInstance(String var1) throws SOAPSerializationException;

    public boolean containsOnly(Flag flag) {
        return this.size() == 1 && super.contains(flag);
    }

    public boolean containsAny(FlagSet other) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!other.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }
}

