/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.AbstractByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteIterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.bytes.ByteSpliterators;

public class ByteArrayList
extends AbstractByteList
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353130L;
    protected transient byte[] a;
    protected int size;

    private static final byte[] copyArraySafe(byte[] a, int length) {
        if (length == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(a, length);
    }

    protected ByteArrayList(byte[] a, boolean wrapped) {
        this.a = a;
    }

    public ByteArrayList() {
        this.a = ByteArrays.DEFAULT_EMPTY_ARRAY;
    }

    private void grow(int capacity) {
        if (capacity <= this.a.length) {
            return;
        }
        if (this.a != ByteArrays.DEFAULT_EMPTY_ARRAY) {
            capacity = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)capacity);
        } else if (capacity < 10) {
            capacity = 10;
        }
        this.a = ByteArrays.forceCapacity(this.a, capacity, this.size);
        assert (this.size <= this.a.length);
    }

    @Override
    public void add(int index2, byte k) {
        this.ensureIndex(index2);
        this.grow(this.size + 1);
        if (index2 != this.size) {
            System.arraycopy(this.a, index2, this.a, index2 + 1, this.size - index2);
        }
        this.a[index2] = k;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    @Override
    public boolean add(byte k) {
        this.grow(this.size + 1);
        this.a[this.size++] = k;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public byte getByte(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index2];
    }

    @Override
    public int indexOf(byte k) {
        for (int i = 0; i < this.size; ++i) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte k) {
        int i = this.size;
        while (i-- != 0) {
            if (k != this.a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public byte removeByte(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte old = this.a[index2];
        --this.size;
        if (index2 != this.size) {
            System.arraycopy(this.a, index2 + 1, this.a, index2, this.size - index2);
        }
        assert (this.size <= this.a.length);
        return old;
    }

    @Override
    public boolean rem(byte k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeByte(index2);
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public byte set(int index2, byte k) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        byte old = this.a[index2];
        this.a[index2] = k;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public ByteList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new SubList(from, to);
    }

    @Override
    public void getElements(int from, byte[] a, int offset, int length) {
        ByteArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void setElements(int index2, byte[] a, int offset, int length) {
        this.ensureIndex(index2);
        ByteArrays.ensureOffsetLength(a, offset, length);
        if (index2 + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index2 + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(a, offset, this.a, index2, length);
    }

    @Override
    public void forEach(ByteConsumer action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept(this.a[i]);
        }
    }

    @Override
    public boolean addAll(int index2, ByteCollection c) {
        if (c instanceof ByteList) {
            return this.addAll(index2, (ByteList)c);
        }
        this.ensureIndex(index2);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index2, this.a, index2 + n, this.size - index2);
        ByteIterator i = c.iterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index2++] = i.nextByte();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    public boolean addAll(int index2, ByteList l) {
        this.ensureIndex(index2);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.grow(this.size + n);
        System.arraycopy(this.a, index2, this.a, index2 + n, this.size - index2);
        l.getElements(0, this.a, index2, n);
        this.size += n;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(ByteCollection c) {
        byte[] a = this.a;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (c.contains(a[i])) continue;
            a[j++] = a[i];
        }
        boolean modified = this.size != j;
        this.size = j;
        return modified;
    }

    @Override
    public byte[] toArray(byte[] a) {
        if (a == null || a.length < this.size) {
            a = java.util.Arrays.copyOf(a, this.size);
        }
        System.arraycopy(this.a, 0, a, 0, this.size);
        return a;
    }

    @Override
    public ByteListIterator listIterator(final int index2) {
        this.ensureIndex(index2);
        return new ByteListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < ByteArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ByteArrayList.this.a[this.last];
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ByteArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(byte k) {
                ByteArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(byte k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ByteArrayList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ByteArrayList.this.removeByte(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                while (this.pos < ByteArrayList.this.size) {
                    ++this.pos;
                    this.last = this.last;
                    action.accept(ByteArrayList.this.a[this.last]);
                }
            }
        };
    }

    @Override
    public ByteSpliterator spliterator() {
        return new Spliterator();
    }

    @Override
    public void sort(ByteComparator comp) {
        if (comp == null) {
            ByteArrays.stableSort(this.a, 0, this.size);
        } else {
            ByteArrays.stableSort(this.a, 0, this.size, comp);
        }
    }

    @Override
    public void unstableSort(ByteComparator comp) {
        if (comp == null) {
            ByteArrays.unstableSort(this.a, 0, this.size);
        } else {
            ByteArrays.unstableSort(this.a, 0, this.size, comp);
        }
    }

    public ByteArrayList clone() {
        ByteArrayList cloned = null;
        if (this.getClass() == ByteArrayList.class) {
            cloned = new ByteArrayList(ByteArrayList.copyArraySafe(this.a, this.size), false);
            cloned.size = this.size;
        } else {
            try {
                cloned = (ByteArrayList)super.clone();
            }
            catch (CloneNotSupportedException err) {
                throw new InternalError(err);
            }
            cloned.a = ByteArrayList.copyArraySafe(this.a, this.size);
        }
        return cloned;
    }

    public boolean equals(ByteArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        byte[] a1 = this.a;
        byte[] a2 = l.a;
        if (a1 == a2 && s == l.size()) {
            return true;
        }
        while (s-- != 0) {
            if (a1[s] == a2[s]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ByteArrayList) {
            return this.equals((ByteArrayList)o);
        }
        if (o instanceof SubList) {
            return ((SubList)o).equals(this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(ByteArrayList l) {
        int i;
        int s1 = this.size();
        int s2 = l.size();
        byte[] a1 = this.a;
        byte[] a2 = l.a;
        if (a1 == a2 && s1 == s2) {
            return 0;
        }
        for (i = 0; i < s1 && i < s2; ++i) {
            byte e1 = a1[i];
            byte e2 = a2[i];
            int r = Byte.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Byte> l) {
        if (l instanceof ByteArrayList) {
            return this.compareTo((ByteArrayList)l);
        }
        if (l instanceof SubList) {
            return -((SubList)l).compareTo(this);
        }
        return super.compareTo(l);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeByte(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readByte();
        }
    }

    private class SubList
    extends AbstractByteList.ByteRandomAccessSubList {
        private static final long serialVersionUID = -3185226345314976296L;

        protected SubList(int from, int to) {
            super(ByteArrayList.this, from, to);
        }

        private byte[] getParentArray() {
            return ByteArrayList.this.a;
        }

        @Override
        public byte getByte(int i) {
            this.ensureRestrictedIndex(i);
            return ByteArrayList.this.a[i + this.from];
        }

        @Override
        public ByteListIterator listIterator(int index2) {
            return new SubListIterator(index2);
        }

        @Override
        public ByteSpliterator spliterator() {
            return new SubListSpliterator();
        }

        boolean contentsEquals(byte[] otherA, int otherAFrom, int otherATo) {
            if (ByteArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return true;
            }
            if (otherATo - otherAFrom != this.size()) {
                return false;
            }
            int pos = this.from;
            int otherPos = otherAFrom;
            while (pos < this.to) {
                if (ByteArrayList.this.a[pos++] == otherA[otherPos++]) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof List)) {
                return false;
            }
            if (o instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)o;
                return this.contentsEquals(other.a, 0, other.size());
            }
            if (o instanceof SubList) {
                SubList other = (SubList)o;
                return this.contentsEquals(other.getParentArray(), other.from, other.to);
            }
            return super.equals(o);
        }

        int contentsCompareTo(byte[] otherA, int otherAFrom, int otherATo) {
            if (ByteArrayList.this.a == otherA && this.from == otherAFrom && this.to == otherATo) {
                return 0;
            }
            int i = this.from;
            int j = otherAFrom;
            while (i < this.to && i < otherATo) {
                byte e1 = ByteArrayList.this.a[i];
                byte e2 = otherA[j];
                int r = Byte.compare(e1, e2);
                if (r != 0) {
                    return r;
                }
                ++i;
                ++j;
            }
            return i < otherATo ? -1 : (i < this.to ? 1 : 0);
        }

        @Override
        public int compareTo(List<? extends Byte> l) {
            if (l instanceof ByteArrayList) {
                ByteArrayList other = (ByteArrayList)l;
                return this.contentsCompareTo(other.a, 0, other.size());
            }
            if (l instanceof SubList) {
                SubList other = (SubList)l;
                return this.contentsCompareTo(other.getParentArray(), other.from, other.to);
            }
            return super.compareTo(l);
        }

        private final class SubListIterator
        extends ByteIterators.AbstractIndexBasedListIterator {
            SubListIterator(int index2) {
                super(0, index2);
            }

            @Override
            protected final byte get(int i) {
                return ByteArrayList.this.a[SubList.this.from + i];
            }

            @Override
            protected final void add(int i, byte k) {
                SubList.this.add(i, k);
            }

            @Override
            protected final void set(int i, byte k) {
                SubList.this.set(i, k);
            }

            @Override
            protected final void remove(int i) {
                SubList.this.removeByte(i);
            }

            @Override
            protected final int getMaxPos() {
                return SubList.this.to - SubList.this.from;
            }

            @Override
            public byte nextByte() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.pos++;
                return ByteArrayList.this.a[SubList.this.from + this.lastReturned];
            }

            @Override
            public byte previousByte() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.pos;
                return ByteArrayList.this.a[SubList.this.from + this.pos];
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                int max = SubList.this.to - SubList.this.from;
                while (this.pos < max) {
                    ++this.pos;
                    this.lastReturned = this.lastReturned;
                    action.accept(ByteArrayList.this.a[SubList.this.from + this.lastReturned]);
                }
            }
        }

        private final class SubListSpliterator
        extends ByteSpliterators.LateBindingSizeIndexBasedSpliterator {
            SubListSpliterator() {
                super(SubList.this.from);
            }

            private SubListSpliterator(int pos, int maxPos) {
                super(pos, maxPos);
            }

            @Override
            protected final int getMaxPosFromBackingStore() {
                return SubList.this.to;
            }

            @Override
            protected final byte get(int i) {
                return ByteArrayList.this.a[i];
            }

            @Override
            protected final SubListSpliterator makeForSplit(int pos, int maxPos) {
                return new SubListSpliterator(pos, maxPos);
            }

            @Override
            public boolean tryAdvance(ByteConsumer action) {
                if (this.pos >= this.getMaxPos()) {
                    return false;
                }
                action.accept(ByteArrayList.this.a[this.pos++]);
                return true;
            }

            @Override
            public void forEachRemaining(ByteConsumer action) {
                int max = this.getMaxPos();
                while (this.pos < max) {
                    action.accept(ByteArrayList.this.a[this.pos++]);
                }
            }
        }
    }

    private final class Spliterator
    implements ByteSpliterator {
        boolean hasSplit = false;
        int pos;
        int max;

        public Spliterator() {
            this(0, byteArrayList.size, false);
        }

        private Spliterator(int pos, int max, boolean hasSplit) {
            assert (pos <= max) : "pos " + pos + " must be <= max " + max;
            this.pos = pos;
            this.max = max;
            this.hasSplit = hasSplit;
        }

        private int getWorkingMax() {
            return this.hasSplit ? this.max : ByteArrayList.this.size;
        }

        @Override
        public int characteristics() {
            return 16720;
        }

        @Override
        public long estimateSize() {
            return this.getWorkingMax() - this.pos;
        }

        @Override
        public boolean tryAdvance(ByteConsumer action) {
            if (this.pos >= this.getWorkingMax()) {
                return false;
            }
            action.accept(ByteArrayList.this.a[this.pos++]);
            return true;
        }

        @Override
        public void forEachRemaining(ByteConsumer action) {
            int max = this.getWorkingMax();
            while (this.pos < max) {
                action.accept(ByteArrayList.this.a[this.pos]);
                ++this.pos;
            }
        }

        @Override
        public ByteSpliterator trySplit() {
            int myNewPos;
            int max = this.getWorkingMax();
            int retLen = max - this.pos >> 1;
            if (retLen <= 1) {
                return null;
            }
            this.max = max;
            int retMax = myNewPos = this.pos + retLen;
            int oldPos = this.pos;
            this.pos = myNewPos;
            this.hasSplit = true;
            return new Spliterator(oldPos, retMax, true);
        }
    }
}

