/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ModuleAnnotationsResolver;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.CheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.OptInDescription;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.checkers.UsageCheckerUtilsKt;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationSettings;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0006\u0012\u0013\u0014\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findRelevantDataClassPropertyIfAny", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ClassifierUsage", "Companion", "OptInDiagnosticReporter", "OptInFactoryBasedReporter", "OptInReporterMultiplexer", "Overrides", "frontend"})
@SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,553:1\n1549#2:554\n1620#2,3:555\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker\n*L\n105#1:554\n105#1:555,3\n*E\n"})
public final class OptInUsageChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleAnnotationsResolver moduleAnnotationsResolver;
    @NotNull
    private static final Name LEVEL;
    @NotNull
    private static final Name MESSAGE;
    @NotNull
    private static final Name WARNING_LEVEL;
    @NotNull
    private static final Name ERROR_LEVEL;
    @NotNull
    private static final OptInReporterMultiplexer USAGE_DIAGNOSTICS;

    public OptInUsageChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        PropertyDescriptor propertyDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        BindingContext bindingContext2 = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
        BindingContext bindingContext3 = bindingContext2;
        LanguageVersionSettings languageVersionSettings2 = context.getLanguageVersionSettings();
        Intrinsics.checkNotNull(resultingDescriptor);
        Set optIns = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, (DeclarationDescriptor)resultingDescriptor, this.moduleAnnotationsResolver, bindingContext3, languageVersionSettings2, null, false, false, false, 120, null);
        if (resultingDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)resultingDescriptor).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && (propertyDescriptor = this.findRelevantDataClassPropertyIfAny((FunctionDescriptor)resultingDescriptor, context)) != null) {
            Companion.reportNotAllowedOptIns(SetsKt.plus(optIns, org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, propertyDescriptor, this.moduleAnnotationsResolver, bindingContext3, languageVersionSettings2, null, false, false, false, 120, null)), reportOn, context);
            return;
        }
        if (resultingDescriptor instanceof SamConstructorDescriptor) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CallableMemberDescriptor methodDescriptor = ((SamConstructorDescriptor)resultingDescriptor).getSingleAbstractMethod();
            Iterable iterable = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, methodDescriptor, this.moduleAnnotationsResolver, bindingContext3, languageVersionSettings2, null, false, false, false, 120, null);
            boolean $i$f$map = false;
            void var12_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName2 = optInDescription.component1();
                String message2 = optInDescription.component3();
                collection.add(new OptInDescription(fqName2, OptInDescription.Severity.WARNING, message2, false));
            }
            List samOptIns = (List)destination$iv$iv;
            Companion.reportNotAllowedOptIns(samOptIns, reportOn, context);
        }
        Companion.reportNotAllowedOptIns(optIns, reportOn, context);
    }

    private final PropertyDescriptor findRelevantDataClassPropertyIfAny(FunctionDescriptor $this$findRelevantDataClassPropertyIfAny, CallCheckerContext context) {
        String string2 = $this$findRelevantDataClassPropertyIfAny.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        Integer index2 = StringsKt.toIntOrNull(StringsKt.removePrefix(string2, (CharSequence)"component"));
        DeclarationDescriptor declarationDescriptor = $this$findRelevantDataClassPropertyIfAny.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        if (container instanceof ClassDescriptor && ((ClassDescriptor)container).isData() && index2 != null) {
            ValueParameterDescriptor dataClassParameterDescriptor;
            Object object = ((ClassDescriptor)container).getUnsubstitutedPrimaryConstructor();
            ValueParameterDescriptor valueParameterDescriptor = object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.getOrNull(object, index2 - 1) : (dataClassParameterDescriptor = null);
            if (dataClassParameterDescriptor != null) {
                return (PropertyDescriptor)context.getTrace().getBindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, dataClassParameterDescriptor);
            }
        }
        return null;
    }

    static {
        Name name = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        LEVEL = name;
        Name name2 = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        MESSAGE = name2;
        Name name3 = Name.identifier("WARNING");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        WARNING_LEVEL = name3;
        Name name4 = Name.identifier("ERROR");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        ERROR_LEVEL = name4;
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2 = Errors.OPT_IN_USAGE;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, "OPT_IN_USAGE");
        OptInDiagnosticReporter optInDiagnosticReporter = new OptInFactoryBasedReporter(diagnosticFactory2, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("should")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = Errors.OPT_IN_USAGE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory22, "OPT_IN_USAGE_ERROR");
        OptInDiagnosticReporter optInDiagnosticReporter2 = new OptInFactoryBasedReporter(diagnosticFactory22, Companion.getDefaultDiagnosticMessage$frontend(OptInNames.INSTANCE.buildMessagePrefix("must")));
        DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory23 = Errors.OPT_IN_USAGE_FUTURE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory23, "OPT_IN_USAGE_FUTURE_ERROR");
        USAGE_DIAGNOSTICS = new OptInReporterMultiplexer(optInDiagnosticReporter, optInDiagnosticReporter2, new OptInFactoryBasedReporter(diagnosticFactory23, Companion.getDefaultDiagnosticMessage$frontend("This declaration is experimental due to signature types and its usage must be marked (will become an error in future releases)")));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "checkUsageOfKotlinRequiresOptInOrOptIn", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "isUsageAsOptInArgument", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isUsageAsQualifier", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,553:1\n125#2:554\n125#2:555\n1747#3,3:556\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$ClassifierUsage\n*L\n467#1:554\n468#1:555\n473#1:556,3\n*E\n"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public ClassifierUsage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context) {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter(targetDescriptor, "targetDescriptor");
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(context, "context");
                    v0 = targetDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue(v0, "getName(...)");
                    name = v0;
                    if ((Intrinsics.areEqual(name, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().shortName()) || Intrinsics.areEqual(name, OptInNames.INSTANCE.getOPT_IN_FQ_NAME().shortName())) && (Intrinsics.areEqual(fqName = DescriptorUtilsKt.getFqNameSafe(targetDescriptor), OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME()) || Intrinsics.areEqual(fqName, OptInNames.INSTANCE.getOPT_IN_FQ_NAME()))) {
                        this.checkUsageOfKotlinRequiresOptInOrOptIn(element, context);
                        return;
                    }
                    var6_6 = targetDescriptor;
                    targetClass = var6_6 instanceof ClassDescriptor != false ? (ClassDescriptor)targetDescriptor : (var6_6 instanceof TypeAliasDescriptor != false ? ((TypeAliasDescriptor)targetDescriptor).getClassDescriptor() : null);
                    v1 = context.getTrace().getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(v1, "getBindingContext(...)");
                    bindingContext = v1;
                    if (targetClass != null && org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(OptInUsageChecker.Companion, targetClass, false, false, 3, null) != null && !UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsOptInArgument(element, bindingContext)) {
                        context.getTrace().report(Errors.OPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN.on(element));
                    }
                    var7_7 = element;
                    strict$iv = false;
                    $i$f$getParentOfType = false;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtImportDirective.class, strict$iv) != null) break block8;
                    strict$iv = element;
                    strict$iv = true;
                    $i$f$getParentOfType = false;
                    containingClass = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClassOrObject.class, strict$iv);
                    v2 = OptInUsageChecker.Companion;
                    v3 = targetDescriptor;
                    v4 = this.moduleAnnotationsResolver;
                    v5 = bindingContext;
                    v6 = context.getLanguageVersionSettings();
                    v7 = null;
                    v8 = false;
                    v9 = false;
                    if (containingClass == null) ** GOTO lbl-1000
                    strict$iv = containingClass.getSuperTypeListEntries();
                    var22_13 = v9;
                    var21_14 = v8;
                    var20_15 = v7;
                    var19_16 = v6;
                    var18_17 = v5;
                    var17_18 = v4;
                    var16_19 = v3;
                    var15_20 = v2;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v10 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (KtSuperTypeListEntry)element$iv;
                            $i$a$-any-OptInUsageChecker$ClassifierUsage$check$descriptions$1 = false;
                            if (!Intrinsics.areEqual(it.getTypeAsUserType(), element.getParent())) continue;
                            v10 = true;
                            break block7;
                        }
                        v10 = false;
                    }
                }
                var23_25 = v10;
                v2 = var15_20;
                v3 = var16_19;
                v4 = var17_18;
                v5 = var18_17;
                v6 = var19_16;
                v7 = var20_15;
                v8 = var21_14;
                v9 = var22_13;
                if (var23_25) {
                    v11 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v11 = false;
                }
                descriptions = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(v2, v3, v4, v5, v6, v7, v8, v9, v11, 56, null);
                OptInUsageChecker.Companion.reportNotAllowedOptIns(descriptions, element, context);
            }
        }

        private final void checkUsageOfKotlinRequiresOptInOrOptIn(PsiElement element, CheckerContext context) {
            List<String> optInFqNames = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
            if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
                context.getTrace().report(Errors.OPT_IN_IS_NOT_ENABLED.on(element));
            }
            if (!UsageCheckerUtilsKt.isUsageAsAnnotationOrImport(element) && !this.isUsageAsQualifier(element)) {
                context.getTrace().report(Errors.OPT_IN_CAN_ONLY_BE_USED_AS_ANNOTATION.on(element));
            }
        }

        private final boolean isUsageAsQualifier(PsiElement $this$isUsageAsQualifier) {
            if ($this$isUsageAsQualifier instanceof KtSimpleNameExpression) {
                KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector((KtSimpleNameExpression)$this$isUsageAsQualifier);
                KtExpression qualifier = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)$this$isUsageAsQualifier;
                PsiElement psiElement = qualifier.getParent();
                KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
                if (Intrinsics.areEqual(ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null, qualifier)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsageAsOptInArgument(PsiElement $this$isUsageAsOptInArgument, BindingContext bindingContext2) {
            KtExpression ktExpression = $this$isUsageAsOptInArgument instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)$this$isUsageAsOptInArgument : null;
            PsiElement qualifier = ktExpression != null && (ktExpression = KtPsiUtilKt.getTopmostParentQualifiedExpressionForSelector(ktExpression)) != null ? (PsiElement)ktExpression : $this$isUsageAsOptInArgument;
            PsiElement parent2 = qualifier.getParent();
            if (!(parent2 instanceof KtClassLiteralExpression)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent() instanceof KtValueArgument)) return false;
            if (!(((KtClassLiteralExpression)parent2).getParent().getParent() instanceof KtValueArgumentList)) return false;
            PsiElement entry = ((KtClassLiteralExpression)parent2).getParent().getParent().getParent();
            boolean bl = false;
            if (!(entry instanceof KtAnnotationEntry)) return false;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, entry);
            if (annotationDescriptor == null) return false;
            AnnotationDescriptor annotation2 = annotationDescriptor;
            boolean bl2 = false;
            if (Intrinsics.areEqual(annotation2.getFqName(), OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) return true;
            if (Intrinsics.areEqual(annotation2.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) return true;
            if (!Intrinsics.areEqual(annotation2.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) return false;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u0011J!\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0017J4\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bJ$\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"J0\u0010#\u001a\u00020$*\u00020\u001d2!\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020$0\u0011H\u0082\bJ!\u0010(\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u001c\u0010-\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010.\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\"\u0010/\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J,\u0010/\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020$H\u0002J$\u0010/\u001a\u00020$*\u00020\u001d2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u00020$H\u0002J'\u00101\u001a\u0004\u0018\u00010\u001b*\u0002022\b\b\u0002\u00103\u001a\u00020$2\b\b\u0002\u00100\u001a\u00020$H\u0000\u00a2\u0006\u0002\b4JV\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b06*\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u0002070;2\b\b\u0002\u00103\u001a\u00020$2\b\b\u0002\u0010<\u001a\u00020$2\b\b\u0002\u0010=\u001a\u00020$JD\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b06*\u0004\u0018\u00010>2\u0006\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020+2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002070;2\b\b\u0002\u0010@\u001a\u00020$H\u0002J\u0018\u0010A\u001a\u0004\u0018\u00010\u001b*\u00020B2\b\u0010!\u001a\u0004\u0018\u00010+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion;", "", "()V", "ERROR_LEVEL", "Lorg/jetbrains/kotlin/name/Name;", "LEVEL", "MESSAGE", "USAGE_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "WARNING_LEVEL", "checkCompilerArguments", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "reportError", "Lkotlin/Function1;", "", "reportWarning", "getDefaultDiagnosticMessage", "Lorg/jetbrains/kotlin/name/FqName;", "prefix", "getDefaultDiagnosticMessage$frontend", "reportNotAllowedOptIns", "descriptions", "", "Lorg/jetbrains/kotlin/resolve/checkers/OptInDescription;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "diagnostics", "context", "Lorg/jetbrains/kotlin/resolve/checkers/CheckerContext;", "anyParentMatches", "", "predicate", "Lkotlin/ParameterName;", "name", "isDeclarationAnnotatedWith", "annotationFqName", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isDeclarationAnnotatedWith$frontend", "isElementAnnotatedWithOptIn", "isElementAnnotatedWithSubclassOptInRequired", "isOptInAllowed", "subclassesOnly", "loadOptInForMarkerAnnotation", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "useFutureError", "loadOptInForMarkerAnnotation$frontend", "loadOptIns", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "visited", "", "useMarkersFromContainer", "fromSupertype", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitedClassifiers", "warningsOnly", "loadSubclassOptInRequired", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,553:1\n385#1,4:579\n1855#2,2:554\n1747#2,3:556\n1603#2,9:559\n1855#2:568\n1856#2:570\n1612#2:571\n1360#2:572\n1446#2,5:573\n1747#2,2:583\n1747#2,3:585\n1749#2:588\n1747#2,3:589\n1855#2,2:592\n1#3:569\n1#3:594\n125#4:578\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Companion\n*L\n339#1:579,4\n229#1:554,2\n243#1:556,3\n246#1:559,9\n246#1:568\n246#1:570\n246#1:571\n276#1:572\n276#1:573,5\n354#1:583,2\n358#1:585,3\n354#1:588\n372#1:589,3\n430#1:592,2\n246#1:569\n338#1:578\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<FqName, String> getDefaultDiagnosticMessage$frontend(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter(prefix, "prefix");
            return new Function1<FqName, String>(prefix){
                final /* synthetic */ String $prefix;
                {
                    this.$prefix = $prefix;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull FqName fqName2) {
                    Intrinsics.checkNotNullParameter(fqName2, "fqName");
                    String string2 = fqName2.asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    return OptInNames.INSTANCE.buildDefaultDiagnosticMessage(this.$prefix, string2);
                }
            };
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull CheckerContext context) {
            Intrinsics.checkNotNullParameter(descriptions, "descriptions");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(context, "context");
            this.reportNotAllowedOptIns(descriptions, element, context.getLanguageVersionSettings(), context.getTrace(), USAGE_DIAGNOSTICS);
        }

        public final void reportNotAllowedOptIns(@NotNull Collection<OptInDescription> descriptions, @NotNull PsiElement element, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull BindingTrace trace, @NotNull OptInReporterMultiplexer diagnostics2) {
            Intrinsics.checkNotNullParameter(descriptions, "descriptions");
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(diagnostics2, "diagnostics");
            for (OptInDescription optInDescription : descriptions) {
                OptInDiagnosticReporter optInDiagnosticReporter;
                FqName annotationFqName = optInDescription.component1();
                OptInDescription.Severity severity = optInDescription.component2();
                String message2 = optInDescription.component3();
                boolean subclassesOnly = optInDescription.component4();
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
                if (this.isOptInAllowed(element, annotationFqName, languageVersionSettings2, bindingContext2, subclassesOnly)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                    case 1: {
                        optInDiagnosticReporter = diagnostics2.getWarning();
                        break;
                    }
                    case 2: {
                        optInDiagnosticReporter = diagnostics2.getError();
                        break;
                    }
                    case 3: {
                        optInDiagnosticReporter = diagnostics2.getFutureError();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                OptInDiagnosticReporter diagnostic = optInDiagnosticReporter;
                diagnostic.report(trace, element, annotationFqName, message2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<OptInDescription> loadOptIns(@NotNull DeclarationDescriptor $this$loadOptIns, @NotNull ModuleAnnotationsResolver moduleAnnotationsResolver, @NotNull BindingContext context, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull Set<DeclarationDescriptor> visited2, boolean useFutureError, boolean useMarkersFromContainer, boolean fromSupertype) {
            SinceKotlinAccessibility accessibility;
            boolean bl;
            SmartSet result2;
            block15: {
                Object it;
                Intrinsics.checkNotNullParameter($this$loadOptIns, "<this>");
                Intrinsics.checkNotNullParameter(moduleAnnotationsResolver, "moduleAnnotationsResolver");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
                Intrinsics.checkNotNullParameter(visited2, "visited");
                if (!visited2.add($this$loadOptIns)) {
                    return SetsKt.emptySet();
                }
                result2 = SmartSet.Companion.create();
                if ($this$loadOptIns instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$this$loadOptIns).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    for (CallableMemberDescriptor callableMemberDescriptor : ((CallableMemberDescriptor)$this$loadOptIns).getOverriddenDescriptors()) {
                        ClassDescriptor it2;
                        Intrinsics.checkNotNull(callableMemberDescriptor);
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, callableMemberDescriptor, moduleAnnotationsResolver, context, languageVersionSettings2, visited2, !languageVersionSettings2.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 64, null));
                        if (!useMarkersFromContainer) continue;
                        DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)$this$loadOptIns).getContainingDeclaration();
                        if ((declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null) == null) continue;
                        it2 = it2;
                        boolean bl2 = false;
                        result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it2, moduleAnnotationsResolver, context, languageVersionSettings2, visited2, useFutureError, false, false, 96, null));
                    }
                    return result2;
                }
                for (AnnotationDescriptor annotationDescriptor : $this$loadOptIns.getAnnotations()) {
                    Collection collection = result2;
                    Object object = DescriptorUtilsKt.getAnnotationClass(annotationDescriptor);
                    if (object == null || (object = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(this, (ClassDescriptor)object, useFutureError, false, 2, null)) == null) {
                        object = fromSupertype ? this.loadSubclassOptInRequired(annotationDescriptor, context) : null;
                    }
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(collection, object);
                }
                if ($this$loadOptIns instanceof CallableDescriptor && !($this$loadOptIns instanceof ClassConstructorDescriptor)) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((CallableDescriptor)$this$loadOptIns).getReturnType(), moduleAnnotationsResolver, context, languageVersionSettings2, visited2, false, 16, null));
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)$this$loadOptIns).getExtensionReceiverParameter();
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, moduleAnnotationsResolver, context, languageVersionSettings2, visited2, false, 16, null));
                }
                if ($this$loadOptIns instanceof FunctionDescriptor) {
                    List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)$this$loadOptIns).getValueParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
                    Iterable $this$forEach$iv = list2;
                    boolean bl2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (ValueParameterDescriptor)element$iv;
                        boolean bl3 = false;
                        result2.addAll(Companion.loadOptIns(it.getType(), moduleAnnotationsResolver, context, languageVersionSettings2, visited2, $this$loadOptIns instanceof ConstructorDescriptor));
                    }
                }
                if ($this$loadOptIns instanceof TypeAliasDescriptor) {
                    result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((TypeAliasDescriptor)$this$loadOptIns).getExpandedType(), moduleAnnotationsResolver, context, languageVersionSettings2, visited2, false, 16, null));
                }
                Iterable $this$any$iv = $this$loadOptIns.getAnnotations();
                boolean bl3 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getFqName(), OptInNames.INSTANCE.getWAS_EXPERIMENTAL_FQ_NAME())) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl && (accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility($this$loadOptIns, languageVersionSettings2)) instanceof SinceKotlinAccessibility.NotAccessibleButWasExperimental) {
                void $this$mapNotNullTo$iv$iv;
                Object element$iv;
                Iterable iterable = ((SinceKotlinAccessibility.NotAccessibleButWasExperimental)accessibility).getMarkerClasses();
                SmartSet smartSet = result2;
                boolean $i$f$mapNotNull = false;
                element$iv = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    OptInDescription it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl5 = false;
                    ClassDescriptor it = (ClassDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, it, useFutureError, false, 2, null) == null) continue;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                smartSet.addAll((List)destination$iv$iv);
            }
            DeclarationDescriptor container = $this$loadOptIns.getContainingDeclaration();
            if (useMarkersFromContainer && container instanceof ClassDescriptor && !($this$loadOptIns instanceof ConstructorDescriptor)) {
                result2.addAll(org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, container, moduleAnnotationsResolver, context, languageVersionSettings2, visited2, useFutureError, false, false, 96, null));
            }
            return result2;
        }

        public static /* synthetic */ Set loadOptIns$default(Companion companion, DeclarationDescriptor declarationDescriptor, ModuleAnnotationsResolver moduleAnnotationsResolver, BindingContext bindingContext2, LanguageVersionSettings languageVersionSettings2, Set set, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 8) != 0) {
                set = new LinkedHashSet();
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            if ((n & 0x40) != 0) {
                bl3 = false;
            }
            return companion.loadOptIns(declarationDescriptor, moduleAnnotationsResolver, bindingContext2, languageVersionSettings2, set, bl, bl2, bl3);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<OptInDescription> loadOptIns(KotlinType $this$loadOptIns, ModuleAnnotationsResolver moduleAnnotationsResolver, BindingContext context, LanguageVersionSettings languageVersionSettings2, Set<DeclarationDescriptor> visitedClassifiers, boolean warningsOnly) {
            Set<OptInDescription> set;
            KotlinType kotlinType = $this$loadOptIns;
            if (!(kotlinType != null ? !KotlinTypeKt.isError(kotlinType) : false)) {
                set = SetsKt.emptySet();
            } else if ($this$loadOptIns instanceof AbbreviatedType) {
                Set set2;
                ClassifierDescriptor classifierDescriptor = ((AbbreviatedType)$this$loadOptIns).getAbbreviation().getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, moduleAnnotationsResolver, context, languageVersionSettings2, visitedClassifiers, warningsOnly || !languageVersionSettings2.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 96, null) : (set2 = null)) == null) {
                    set2 = SetsKt.emptySet();
                }
                set = SetsKt.plus(set2, org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, ((AbbreviatedType)$this$loadOptIns).getExpandedType(), moduleAnnotationsResolver, context, languageVersionSettings2, visitedClassifiers, false, 16, null));
            } else {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Set set3;
                ClassifierDescriptor classifierDescriptor = $this$loadOptIns.getConstructor().getDeclarationDescriptor();
                if ((classifierDescriptor != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(this, classifierDescriptor, moduleAnnotationsResolver, context, languageVersionSettings2, visitedClassifiers, warningsOnly || !languageVersionSettings2.supportsFeature(LanguageFeature.OptInContagiousSignatures), false, false, 96, null) : (set3 = null)) == null) {
                    set3 = SetsKt.emptySet();
                }
                Iterable iterable = $this$loadOptIns.getArguments();
                Set set4 = set3;
                boolean $i$f$flatMap = false;
                void var9_10 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    TypeProjection it = (TypeProjection)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = it.isStarProjection() ? SetsKt.emptySet() : org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, it.getType(), moduleAnnotationsResolver, context, languageVersionSettings2, visitedClassifiers, false, 16, null);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                set = SetsKt.plus(set4, (List)destination$iv$iv);
            }
            return set;
        }

        static /* synthetic */ Set loadOptIns$default(Companion companion, KotlinType kotlinType, ModuleAnnotationsResolver moduleAnnotationsResolver, BindingContext bindingContext2, LanguageVersionSettings languageVersionSettings2, Set set, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.loadOptIns(kotlinType, moduleAnnotationsResolver, bindingContext2, languageVersionSettings2, set, bl);
        }

        @Nullable
        public final OptInDescription loadOptInForMarkerAnnotation$frontend(@NotNull ClassDescriptor $this$loadOptInForMarkerAnnotation, boolean useFutureError, boolean subclassesOnly) {
            Name name;
            Intrinsics.checkNotNullParameter($this$loadOptInForMarkerAnnotation, "<this>");
            AnnotationDescriptor annotationDescriptor = $this$loadOptInForMarkerAnnotation.getAnnotations().findAnnotation(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME());
            if (annotationDescriptor == null) {
                return null;
            }
            AnnotationDescriptor optInAnnotationDescriptor = annotationDescriptor;
            Map<Name, ConstantValue<?>> arguments2 = optInAnnotationDescriptor.getAllValueArguments();
            ConstantValue<?> constantValue = arguments2.get(LEVEL);
            EnumValue enumValue = constantValue instanceof EnumValue ? (EnumValue)constantValue : null;
            Name name2 = name = enumValue != null ? enumValue.getEnumEntryName() : null;
            OptInDescription.Severity severity = Intrinsics.areEqual(name, WARNING_LEVEL) ? OptInDescription.Severity.WARNING : (Intrinsics.areEqual(name, ERROR_LEVEL) ? (useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Severity.ERROR) : (OptInDescription.Companion.getDEFAULT_SEVERITY() == OptInDescription.Severity.ERROR && useFutureError ? OptInDescription.Severity.FUTURE_ERROR : OptInDescription.Companion.getDEFAULT_SEVERITY()));
            constantValue = arguments2.get(MESSAGE);
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            String message2 = stringValue != null ? (String)stringValue.getValue() : null;
            return new OptInDescription(DescriptorUtilsKt.getFqNameSafe($this$loadOptInForMarkerAnnotation), severity, message2, subclassesOnly);
        }

        public static /* synthetic */ OptInDescription loadOptInForMarkerAnnotation$frontend$default(Companion companion, ClassDescriptor classDescriptor2, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            return companion.loadOptInForMarkerAnnotation$frontend(classDescriptor2, bl, bl2);
        }

        private final OptInDescription loadSubclassOptInRequired(AnnotationDescriptor $this$loadSubclassOptInRequired, BindingContext context) {
            ClassDescriptor markerDescriptor;
            if (!Intrinsics.areEqual($this$loadSubclassOptInRequired.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                return null;
            }
            ConstantValue<?> markerClass = $this$loadSubclassOptInRequired.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
            if (!(markerClass instanceof KClassValue)) {
                return null;
            }
            KClassValue.Value value2 = (KClassValue.Value)((KClassValue)markerClass).getValue();
            if (!(value2 instanceof KClassValue.Value.NormalClass)) {
                return null;
            }
            BindingContext bindingContext2 = context;
            ClassDescriptor classDescriptor2 = markerDescriptor = bindingContext2 != null ? (ClassDescriptor)bindingContext2.get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, ((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName().toUnsafe()) : null;
            return classDescriptor2 != null ? org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(this, classDescriptor2, false, true, 1, null) : null;
        }

        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, CheckerContext context, boolean subclassesOnly) {
            LanguageVersionSettings languageVersionSettings2 = context.getLanguageVersionSettings();
            BindingContext bindingContext2 = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings2, bindingContext2, subclassesOnly);
        }

        public final boolean isOptInAllowed(@NotNull PsiElement $this$isOptInAllowed, @NotNull FqName annotationFqName, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkNotNullParameter($this$isOptInAllowed, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
            return this.isOptInAllowed($this$isOptInAllowed, annotationFqName, languageVersionSettings2, bindingContext2, false);
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isOptInAllowed(PsiElement $this$isOptInAllowed, FqName annotationFqName, LanguageVersionSettings languageVersionSettings, BindingContext bindingContext, boolean subclassesOnly) {
            if (languageVersionSettings.getFlag(AnalysisFlags.getOptIn()).contains(annotationFqName.asString())) {
                return true;
            }
            if (!subclassesOnly) ** GOTO lbl-1000
            var7_6 = $this$isOptInAllowed;
            strict$iv = true;
            $i$f$getParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtSuperTypeListEntry.class, strict$iv) != null) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            isSubclass = v0;
            $this$getParentOfType$iv = this;
            $this$anyParentMatches$iv = $this$isOptInAllowed;
            $i$f$anyParentMatches = false;
            element$iv = $this$anyParentMatches$iv;
            while (true) {
                element = element$iv;
                $i$a$-anyParentMatches-OptInUsageChecker$Companion$isOptInAllowed$1 = false;
                v1 = OptInUsageChecker.Companion.isDeclarationAnnotatedWith$frontend(element, annotationFqName, bindingContext) || OptInUsageChecker.Companion.isElementAnnotatedWithOptIn(element, annotationFqName, bindingContext) || isSubclass && OptInUsageChecker.Companion.isElementAnnotatedWithSubclassOptInRequired(element, annotationFqName, bindingContext);
                if (v1) {
                    v2 = true;
                    break;
                }
                v3 = var13_14 = element$iv.getParent();
                if (v3 == null) {
                    v2 = false;
                    break;
                }
                Intrinsics.checkNotNull(v3);
                element$iv = var13_14;
            }
            return v2;
        }

        public final boolean isDeclarationAnnotatedWith$frontend(@NotNull PsiElement $this$isDeclarationAnnotatedWith, @NotNull FqName annotationFqName, @NotNull BindingContext bindingContext2) {
            Intrinsics.checkNotNullParameter($this$isDeclarationAnnotatedWith, "<this>");
            Intrinsics.checkNotNullParameter(annotationFqName, "annotationFqName");
            Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
            if (!($this$isDeclarationAnnotatedWith instanceof KtDeclaration)) {
                return false;
            }
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$isDeclarationAnnotatedWith);
            return descriptor2 != null && descriptor2.getAnnotations().hasAnnotation(annotationFqName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithOptIn(PsiElement $this$isElementAnnotatedWithOptIn, FqName annotationFqName, BindingContext bindingContext2) {
            boolean bl;
            if (!($this$isElementAnnotatedWithOptIn instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$this$isElementAnnotatedWithOptIn).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 != null && Intrinsics.areEqual(descriptor2.getFqName(), OptInNames.INSTANCE.getOPT_IN_FQ_NAME())) {
                    ConstantValue<?> annotationClasses = descriptor2.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    if (annotationClasses instanceof ArrayValue) {
                        boolean bl3;
                        Iterable $this$any$iv2 = (Iterable)((ArrayValue)annotationClasses).getValue();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ConstantValue annotationClass = (ConstantValue)element$iv2;
                                boolean bl4 = false;
                                if (annotationClass instanceof KClassValue) {
                                    KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                                    boolean bl5 = false;
                                    if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual(((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                                        return true;
                                    }
                                    boolean bl6 = false;
                                    if (bl6) {
                                        return true;
                                    }
                                }
                                boolean bl7 = false;
                                if (!bl7) continue;
                                return true;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isElementAnnotatedWithSubclassOptInRequired(PsiElement $this$isElementAnnotatedWithSubclassOptInRequired, FqName annotationFqName, BindingContext bindingContext2) {
            boolean bl;
            if (!($this$isElementAnnotatedWithSubclassOptInRequired instanceof KtAnnotated)) return false;
            List<KtAnnotationEntry> list2 = ((KtAnnotated)$this$isElementAnnotatedWithSubclassOptInRequired).getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KtAnnotationEntry entry = (KtAnnotationEntry)element$iv;
                boolean bl2 = false;
                AnnotationDescriptor descriptor2 = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, entry);
                if (descriptor2 != null && Intrinsics.areEqual(descriptor2.getFqName(), OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_FQ_NAME())) {
                    ConstantValue<?> annotationClass = descriptor2.getAllValueArguments().get(OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS());
                    if (annotationClass instanceof KClassValue) {
                        KClassValue.Value value2 = (KClassValue.Value)((KClassValue)annotationClass).getValue();
                        boolean bl3 = false;
                        if (value2 instanceof KClassValue.Value.NormalClass && Intrinsics.areEqual(((KClassValue.Value.NormalClass)value2).getClassId().asSingleFqName(), annotationFqName) && ((KClassValue.Value.NormalClass)value2).getArrayDimensions() == 0) {
                            return true;
                        }
                        boolean bl4 = false;
                        if (bl4) {
                            return true;
                        }
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final void checkCompilerArguments(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull Function1<? super String, Unit> reportError2, @NotNull Function1<? super String, Unit> reportWarning) {
            Intrinsics.checkNotNullParameter(module2, "module");
            Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
            Intrinsics.checkNotNullParameter(reportError2, "reportError");
            Intrinsics.checkNotNullParameter(reportWarning, "reportWarning");
            DeprecationResolver deprecationResolver = new DeprecationResolver(new LockBasedStorageManager("OptInUsageChecker"), languageVersionSettings2, DeprecationSettings.Default.INSTANCE);
            Iterable $this$forEach$iv = languageVersionSettings2.getFlag(AnalysisFlags.getOptIn());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String fqName2 = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual(fqName2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) continue;
                org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.checkCompilerArguments$checkAnnotation(module2, reportWarning, deprecationResolver, reportError2, fqName2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final boolean checkCompilerArguments$checkAnnotation(ModuleDescriptor $module, Function1<? super String, Unit> $reportWarning, DeprecationResolver deprecationResolver, Function1<? super String, Unit> $reportError, String fqName2) {
            ClassDescriptor descriptor2 = DescriptorUtilKt.resolveClassByFqName($module, new FqName(fqName2), NoLookupLocation.FOR_NON_TRACKED_SCOPE);
            if (descriptor2 == null) {
                $reportWarning.invoke("Opt-in requirement marker " + fqName2 + " is unresolved. Please make sure it's present in the module dependencies");
                return false;
            }
            if (org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptInForMarkerAnnotation$frontend$default(Companion, descriptor2, false, false, 3, null) == null) {
                $reportWarning.invoke("Class " + fqName2 + " is not an opt-in requirement marker");
                return false;
            }
            for (DescriptorBasedDeprecationInfo deprecation : deprecationResolver.getDeprecations(descriptor2)) {
                String string2;
                String string3;
                Function1<? super String, Unit> report2;
                Function1<? super String, Unit> function1;
                switch (WhenMappings.$EnumSwitchMapping$1[deprecation.getDeprecationLevel().ordinal()]) {
                    case 1: {
                        function1 = $reportWarning;
                        break;
                    }
                    case 2: 
                    case 3: {
                        function1 = $reportError;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Function1<? super String, Unit> function12 = report2 = function1;
                StringBuilder stringBuilder = new StringBuilder().append("Opt-in requirement marker ").append(fqName2).append(" is deprecated");
                if (deprecation.getMessage() != null) {
                    void it;
                    StringBuilder stringBuilder2 = stringBuilder;
                    Function1<? super String, Unit> function13 = function12;
                    boolean bl = false;
                    String string4 = ". " + (String)it;
                    function12 = function13;
                    stringBuilder = stringBuilder2;
                    string3 = string4;
                } else {
                    string3 = string2 = null;
                }
                if (string3 == null) {
                    string2 = "";
                }
                function12.invoke(stringBuilder.append(string2).toString());
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[DeprecationLevelValue.values().length];
                try {
                    nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "message", "", "frontend"})
    public static interface OptInDiagnosticReporter {
        public void report(@NotNull BindingTrace var1, @NotNull PsiElement var2, @NotNull FqName var3, @Nullable String var4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInFactoryBasedReporter;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/name/FqName;", "", "defaultMessage", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;Lkotlin/jvm/functions/Function1;)V", "getDefaultMessage", "()Lkotlin/jvm/functions/Function1;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "report", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "element", "fqName", "message", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInFactoryBasedReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,553:1\n1#2:554\n*E\n"})
    public static final class OptInFactoryBasedReporter
    implements OptInDiagnosticReporter {
        @NotNull
        private final DiagnosticFactory2<PsiElement, FqName, String> factory;
        @NotNull
        private final Function1<FqName, String> defaultMessage;

        public OptInFactoryBasedReporter(@NotNull DiagnosticFactory2<PsiElement, FqName, String> factory, @NotNull Function1<? super FqName, String> defaultMessage) {
            Intrinsics.checkNotNullParameter(factory, "factory");
            Intrinsics.checkNotNullParameter(defaultMessage, "defaultMessage");
            this.factory = factory;
            this.defaultMessage = defaultMessage;
        }

        @NotNull
        public final DiagnosticFactory2<PsiElement, FqName, String> getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function1<FqName, String> getDefaultMessage() {
            return this.defaultMessage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message2) {
            String string2;
            FqName fqName3;
            PsiElement psiElement;
            DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory2;
            BindingTrace bindingTrace;
            block4: {
                block3: {
                    void it;
                    String string3;
                    Intrinsics.checkNotNullParameter(trace, "trace");
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(fqName2, "fqName");
                    bindingTrace = trace;
                    diagnosticFactory2 = this.factory;
                    psiElement = element;
                    fqName3 = fqName2;
                    string2 = message2;
                    if (string2 == null) break block3;
                    String string4 = string3 = string2;
                    FqName fqName4 = fqName3;
                    PsiElement psiElement2 = psiElement;
                    DiagnosticFactory2<PsiElement, FqName, String> diagnosticFactory22 = diagnosticFactory2;
                    BindingTrace bindingTrace2 = bindingTrace;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    bindingTrace = bindingTrace2;
                    diagnosticFactory2 = diagnosticFactory22;
                    psiElement = psiElement2;
                    fqName3 = fqName4;
                    string2 = bl2 ? string3 : null;
                    if (string2 != null) break block4;
                }
                string2 = this.defaultMessage.invoke(fqName2);
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = diagnosticFactory2.on(psiElement, fqName3, string2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "", "warning", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "error", "futureError", "(Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;)V", "getError", "()Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "getFutureError", "getWarning", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    public static final class OptInReporterMultiplexer {
        @NotNull
        private final OptInDiagnosticReporter warning;
        @NotNull
        private final OptInDiagnosticReporter error;
        @NotNull
        private final OptInDiagnosticReporter futureError;

        public OptInReporterMultiplexer(@NotNull OptInDiagnosticReporter warning, @NotNull OptInDiagnosticReporter error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            this.warning = warning;
            this.error = error;
            this.futureError = futureError;
        }

        @NotNull
        public final OptInDiagnosticReporter getWarning() {
            return this.warning;
        }

        @NotNull
        public final OptInDiagnosticReporter getError() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter getFutureError() {
            return this.futureError;
        }

        @NotNull
        public final OptInDiagnosticReporter component1() {
            return this.warning;
        }

        @NotNull
        public final OptInDiagnosticReporter component2() {
            return this.error;
        }

        @NotNull
        public final OptInDiagnosticReporter component3() {
            return this.futureError;
        }

        @NotNull
        public final OptInReporterMultiplexer copy(@NotNull OptInDiagnosticReporter warning, @NotNull OptInDiagnosticReporter error, @NotNull OptInDiagnosticReporter futureError) {
            Intrinsics.checkNotNullParameter(warning, "warning");
            Intrinsics.checkNotNullParameter(error, "error");
            Intrinsics.checkNotNullParameter(futureError, "futureError");
            return new OptInReporterMultiplexer(warning, error, futureError);
        }

        public static /* synthetic */ OptInReporterMultiplexer copy$default(OptInReporterMultiplexer optInReporterMultiplexer, OptInDiagnosticReporter optInDiagnosticReporter, OptInDiagnosticReporter optInDiagnosticReporter2, OptInDiagnosticReporter optInDiagnosticReporter3, int n, Object object) {
            if ((n & 1) != 0) {
                optInDiagnosticReporter = optInReporterMultiplexer.warning;
            }
            if ((n & 2) != 0) {
                optInDiagnosticReporter2 = optInReporterMultiplexer.error;
            }
            if ((n & 4) != 0) {
                optInDiagnosticReporter3 = optInReporterMultiplexer.futureError;
            }
            return optInReporterMultiplexer.copy(optInDiagnosticReporter, optInDiagnosticReporter2, optInDiagnosticReporter3);
        }

        @NotNull
        public String toString() {
            return "OptInReporterMultiplexer(warning=" + this.warning + ", error=" + this.error + ", futureError=" + this.futureError + ')';
        }

        public int hashCode() {
            int result2 = this.warning.hashCode();
            result2 = result2 * 31 + this.error.hashCode();
            result2 = result2 * 31 + this.futureError.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptInReporterMultiplexer)) {
                return false;
            }
            OptInReporterMultiplexer optInReporterMultiplexer = (OptInReporterMultiplexer)other;
            if (!Intrinsics.areEqual(this.warning, optInReporterMultiplexer.warning)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.error, optInReporterMultiplexer.error)) {
                return false;
            }
            return Intrinsics.areEqual(this.futureError, optInReporterMultiplexer.futureError);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleAnnotationsResolver", "Lorg/jetbrains/kotlin/resolve/ModuleAnnotationsResolver;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
    @SourceDebugExtension(value={"SMAP\nOptInUsageChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,553:1\n1360#2:554\n1446#2,2:555\n1549#2:557\n1620#2,3:558\n1448#2,3:561\n*S KotlinDebug\n*F\n+ 1 OptInUsageChecker.kt\norg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$Overrides\n*L\n527#1:554\n527#1:555,2\n529#1:557\n529#1:558,3\n527#1:561,3\n*E\n"})
    public static final class Overrides
    implements DeclarationChecker {
        @NotNull
        private final ModuleAnnotationsResolver moduleAnnotationsResolver;

        public Overrides(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            this.moduleAnnotationsResolver = ModuleAnnotationsResolver.Companion.getInstance(project);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return;
            }
            Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            Iterable $this$flatMap$iv = collection;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(overriddenMember);
                DeclarationDescriptor declarationDescriptor = overriddenMember;
                BindingContext bindingContext2 = context.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue(bindingContext2, "getBindingContext(...)");
                Iterable iterable2 = org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker$Companion.loadOptIns$default(Companion, declarationDescriptor, this.moduleAnnotationsResolver, bindingContext2, context.getLanguageVersionSettings(), null, false, false, false, 120, null);
                boolean $i$f$map = false;
                void var16_18 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void description2;
                    OptInDescription optInDescription = (OptInDescription)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to(description2, overriddenMember));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Map optInOverriddenDescriptorMap = MapsKt.toMap((List)destination$iv$iv);
            for (Map.Entry entry : optInOverriddenDescriptorMap.entrySet()) {
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair;
                OptInDescription description3 = (OptInDescription)entry.getKey();
                CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)entry.getValue();
                if (Companion.isOptInAllowed(declaration, description3.getAnnotationFqName(), context, description3.getSubclassesOnly())) continue;
                PsiElement psiElement = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
                if (psiElement == null || (psiElement = psiElement.getNameIdentifier()) == null) {
                    psiElement = declaration;
                }
                PsiElement reportOn = psiElement;
                switch (WhenMappings.$EnumSwitchMapping$0[description3.getSeverity().ordinal()]) {
                    case 1: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE, "should");
                        break;
                    }
                    case 2: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    case 3: {
                        pair = TuplesKt.to(Errors.OPT_IN_OVERRIDE_ERROR, "must");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair<DiagnosticFactory2<PsiElement, FqName, String>, String> pair2 = pair;
                DiagnosticFactory2 diagnostic = (DiagnosticFactory2)pair2.component1();
                String defaultMessageVerb = (String)pair2.component2();
                String string2 = overriddenMember.getContainingDeclaration().getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                String string3 = description3.getMessage();
                String string4 = description3.getAnnotationFqName().asString();
                Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
                String message2 = OptInNames.INSTANCE.buildOverrideMessage(string2, string3, defaultMessageVerb, string4);
                context.getTrace().report(diagnostic.on(reportOn, description3.getAnnotationFqName(), message2));
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OptInDescription.Severity.values().length];
                try {
                    nArray[OptInDescription.Severity.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OptInDescription.Severity.FUTURE_ERROR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

