/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.PropertyGetterAndSetterUsageCheckKt;

@Rule(key="S6512")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/sonarsource/kotlin/checks/PropertyGetterAndSetterUsageCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "checkProperty", "", "prop", "Lorg/jetbrains/kotlin/psi/KtProperty;", "javaAccessors", "", "", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "bindingCtx", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nPropertyGetterAndSetterUsageCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyGetterAndSetterUsageCheck.kt\norg/sonarsource/kotlin/checks/PropertyGetterAndSetterUsageCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n766#2:135\n857#2,2:136\n1477#2:138\n1502#2,3:139\n1505#2,3:149\n766#2:152\n857#2,2:153\n1855#2,2:155\n372#3,7:142\n1#4:157\n*S KotlinDebug\n*F\n+ 1 PropertyGetterAndSetterUsageCheck.kt\norg/sonarsource/kotlin/checks/PropertyGetterAndSetterUsageCheck\n*L\n53#1:135\n53#1:136,2\n54#1:138\n54#1:139,3\n54#1:149,3\n59#1:152\n59#1:153,2\n60#1:155,2\n54#1:142,7\n*E\n"})
public final class PropertyGetterAndSetterUsageCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext ctx) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        KtNamedFunction it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        KtClassBody ktClassBody = klass.getBody();
        if (ktClassBody == null) {
            return;
        }
        KtClassBody classBody = ktClassBody;
        Iterable iterable = classBody.getFunctions();
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv2;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (KtNamedFunction)element$iv$iv;
            boolean bl = false;
            int n = it.getValueParameters().size();
            String string2 = it.getName();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            Intrinsics.checkNotNull(string3);
            if (!PropertyGetterAndSetterUsageCheckKt.access$isGetterOrSetter(n, string3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$groupBy22 = false;
        $this$filterTo$iv$iv2 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (KtNamedFunction)element$iv$iv;
            boolean bl = false;
            String string4 = it.getName();
            if (string4 == null) {
                string4 = "";
            }
            String key$iv$iv = string4;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object javaAccessors = destination$iv$iv;
        if (javaAccessors.isEmpty()) {
            return;
        }
        BindingContext bindingCtx = ctx.getBindingContext();
        Iterable $i$f$groupBy22 = classBody.getProperties();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtProperty it2 = (KtProperty)element$iv$iv;
            boolean bl = false;
            if (!PropertyGetterAndSetterUsageCheckKt.access$isReadyForAccessorsConversion(it2)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtProperty it3 = (KtProperty)element$iv;
            boolean bl = false;
            this.checkProperty(it3, (Map<String, ? extends List<? extends KtNamedFunction>>)javaAccessors, ctx, bindingCtx);
        }
    }

    private final void checkProperty(KtProperty prop, Map<String, ? extends List<? extends KtNamedFunction>> javaAccessors, KotlinFileContext ctx, BindingContext bindingCtx) {
        block6: {
            PsiElement psiElement = prop.getNameIdentifier();
            if (psiElement == null) break block6;
            PsiElement propIdentifier = psiElement;
            boolean bl = false;
            Object object = prop.getTypeReference();
            if (object != null) {
                KtTypeReference it = object;
                boolean bl2 = false;
                KotlinType kotlinType = (KotlinType)bindingCtx.get(BindingContext.TYPE, it);
                object = kotlinType;
                if (kotlinType != null) {
                    PsiElement getterName;
                    KtNamedFunction getterFunc;
                    Object propType = object;
                    boolean bl3 = false;
                    String string2 = prop.getName();
                    Intrinsics.checkNotNull(string2);
                    String propName = string2;
                    Intrinsics.checkNotNull(propType);
                    KtNamedFunction ktNamedFunction = getterFunc = PropertyGetterAndSetterUsageCheckKt.access$findJavaStyleGetterFunc(propName, (KotlinType)propType, javaAccessors, bindingCtx);
                    PsiElement psiElement2 = getterName = ktNamedFunction != null ? ktNamedFunction.getNameIdentifier() : null;
                    if (getterName == null || PropertyGetterAndSetterUsageCheckKt.access$isIncompatiblePropertyAccessor(getterFunc)) {
                        return;
                    }
                    SecondaryLocation[] secondaryLocationArray = new SecondaryLocation[]{KotlinFileContextKt.secondaryOf(ctx, propIdentifier, "Property \"" + propName + "\"")};
                    List<SecondaryLocation> secondaries = CollectionsKt.mutableListOf(secondaryLocationArray);
                    KtNamedFunction setterFunc = PropertyGetterAndSetterUsageCheckKt.access$findJavaStyleSetterFunc(propName, (KotlinType)propType, javaAccessors, bindingCtx);
                    if (setterFunc != null) {
                        if (PropertyGetterAndSetterUsageCheckKt.access$isIncompatiblePropertyAccessor(setterFunc) || PropertyGetterAndSetterUsageCheckKt.access$isLessVisibleThan(getterFunc, setterFunc)) {
                            return;
                        }
                        PsiElement psiElement3 = setterFunc.getNameIdentifier();
                        if (psiElement3 != null) {
                            PsiElement it2 = psiElement3;
                            boolean bl4 = false;
                            Collection collection = secondaries;
                            Intrinsics.checkNotNull(it2);
                            collection.add(KotlinFileContextKt.secondaryOf(ctx, it2, "Setter to convert to a \"set(value)\""));
                        }
                    }
                    AbstractCheck.reportIssue$default((AbstractCheck)this, ctx, getterName, "Convert this getter to a \"get()\" on the property \"" + propName + "\".", secondaries, null, 8, null);
                }
            }
        }
    }
}

