/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.dotnet.resource.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public enum ESolutionFormatVersion {
    VERSION_8,
    VERSION_9;

    private static final String SOLUTION_HEADER_12;
    private static final String SOLUTION_HEADER_11;
    private static final String SOLUTION_HEADER_10;
    private static final String SOLUTION_HEADER_9;
    private static final String SOLUTION_HEADER_8;
    private static final Pattern TOOLS_VERSION_PATTERN;
    private static final Pattern SDK_STYLE_PATTERN;
    private static final Pattern PRODUCT_VERSION_PATTERN;

    private static String defaultSolutionHeader(String version) {
        return "Microsoft Visual Studio Solution File, Format Version " + version;
    }

    public static ESolutionFormatVersion determineProjectFormat(String projectFileContent) throws UnsupportedFormatException {
        if (SDK_STYLE_PATTERN.matcher(projectFileContent).find()) {
            return VERSION_9;
        }
        Matcher toolsVersionMatcher = TOOLS_VERSION_PATTERN.matcher(projectFileContent);
        if (toolsVersionMatcher.find()) {
            return VERSION_9;
        }
        Matcher productVersionMatcher = PRODUCT_VERSION_PATTERN.matcher(projectFileContent);
        if (productVersionMatcher.find()) {
            String majorVersionString = productVersionMatcher.group(1);
            int major = Integer.parseInt(majorVersionString);
            if (major == 7) {
                return VERSION_8;
            }
            if (major > 7) {
                return VERSION_9;
            }
        }
        throw new UnsupportedFormatException("Unable to determine format version for project file: " + StringUtils.truncateWithEllipsis((String)projectFileContent, (int)200));
    }

    public static void checkValidSolutionFormat(String solutionElement) throws ConQATException {
        String[] lines = StringUtils.splitLines((String)solutionElement);
        CCSMAssert.isTrue((lines.length >= 2 ? 1 : 0) != 0, (String)"Solution file shorter than expected");
        if (!ESolutionFormatVersion.startsWithAnyOf(lines, SOLUTION_HEADER_8, SOLUTION_HEADER_9, SOLUTION_HEADER_10, SOLUTION_HEADER_11, SOLUTION_HEADER_12)) {
            throw new ConQATException("Format of solution \"" + lines[0] + "[...]\" unknown.");
        }
    }

    private static boolean startsWithAnyOf(String[] lines, String ... prefixes) {
        return StringUtils.startsWithOneOf((String)lines[0], (String[])prefixes) || StringUtils.startsWithOneOf((String)lines[1], (String[])prefixes);
    }

    static {
        SOLUTION_HEADER_12 = ESolutionFormatVersion.defaultSolutionHeader("12.00");
        SOLUTION_HEADER_11 = ESolutionFormatVersion.defaultSolutionHeader("11.00");
        SOLUTION_HEADER_10 = ESolutionFormatVersion.defaultSolutionHeader("10.00");
        SOLUTION_HEADER_9 = ESolutionFormatVersion.defaultSolutionHeader("9.00");
        SOLUTION_HEADER_8 = ESolutionFormatVersion.defaultSolutionHeader("8.00");
        TOOLS_VERSION_PATTERN = Pattern.compile("<Project[^>]*ToolsVersion=\"(\\d+).\\d+\"");
        SDK_STYLE_PATTERN = Pattern.compile("<Project[^>]*Sdk=");
        PRODUCT_VERSION_PATTERN = Pattern.compile("<?ProductVersion>?\\s*=?\\s*\"?(\\d+)\\.\\d+\\.\\d+\"?");
    }

    public static class UnsupportedFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedFormatException(String message) {
            super(message);
        }
    }
}

