/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.teamscale.index.admin.instance_comparison.comparison.FindingInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonDetailContribution;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

public class FindingsInstanceComparisonValue
implements IInstanceComparisonValue {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String category;
    private final int normalFindingsCount;
    private final int toleratedCategoriesValue;
    private final int falsePositiveCategoriesValue;
    private final FindingsComparisonDetailContribution detail;
    private final int linesOfCode;
    private final int totalFindingsCount;

    public FindingsInstanceComparisonValue(String category, int normalFindingsCount, int toleratedCategoriesValue, int falsePositiveCategoriesValue, @Nullable FindingsComparisonDetailContribution detail, int linesOfCode, int totalFindingsCount) {
        this.category = category;
        this.normalFindingsCount = normalFindingsCount;
        this.toleratedCategoriesValue = toleratedCategoriesValue;
        this.falsePositiveCategoriesValue = falsePositiveCategoriesValue;
        this.detail = detail;
        this.linesOfCode = linesOfCode;
        this.totalFindingsCount = totalFindingsCount;
    }

    public FindingsInstanceComparisonValue(String category, CounterSet<String> normalFindingCounts, CounterSet<String> toleratedFindingCounts, CounterSet<String> falsePositiveFindingCounts, @Nullable FindingsComparisonDetailContribution detail, int linesOfCode, int totalFindingsCount) {
        this(category, normalFindingCounts.getValue((Object)category), toleratedFindingCounts.getValue((Object)category), falsePositiveFindingCounts.getValue((Object)category), detail, linesOfCode, totalFindingsCount);
    }

    public Optional<FindingInstanceComparisonDiffEntry> computeDifference(@Nullable IInstanceComparisonValue other, boolean selfIsLocal, InstanceComparisonContributionBase.ComparisonContext context) {
        FindingsInstanceComparisonValue remote;
        FindingsInstanceComparisonValue local;
        if (other != null && !(other instanceof FindingsInstanceComparisonValue)) {
            LOGGER.warn("Received unsupported other instance ({}: {}) for findings, that cannot be compared with this instance.", other.getClass(), (Object)other);
            return Optional.empty();
        }
        FindingsInstanceComparisonValue otherFindingsDifference = (FindingsInstanceComparisonValue)other;
        if (selfIsLocal) {
            local = this;
            remote = otherFindingsDifference;
        } else {
            local = otherFindingsDifference;
            remote = this;
        }
        return FindingsInstanceComparisonValue.computeDifference(local, remote, this.category, context);
    }

    @Override
    public @Nullable IDetailedInstanceComparisonContribution getDetails() {
        return this.detail;
    }

    @Override
    public String getValueHumanReadable() {
        return String.format("%d/%d/%d", this.normalFindingsCount, this.toleratedCategoriesValue, this.falsePositiveCategoriesValue);
    }

    private static Optional<FindingInstanceComparisonDiffEntry> computeDifference(FindingsInstanceComparisonValue local, FindingsInstanceComparisonValue remote, String category, InstanceComparisonContributionBase.ComparisonContext context) {
        if (local == null) {
            local = FindingsInstanceComparisonValue.buildEmptyComparisonValue(category, context.getLocalContribution(FindingsComparisonContribution.class).orElseThrow());
        } else if (remote == null) {
            remote = FindingsInstanceComparisonValue.buildEmptyComparisonValue(category, context.getRemoteContribution(FindingsComparisonContribution.class).orElseThrow());
        }
        FindingInstanceComparisonDiffEntry.DetailedFindingInstanceComparisonDiff detailedDiff = FindingsInstanceComparisonValue.computeDetailedDiff(local, remote, category);
        return Optional.of(new FindingInstanceComparisonDiffEntry(category, local.getFindingsCount(), remote.getFindingsCount(), detailedDiff, IInstanceComparisonValue.computeExamples(category, local, remote), FindingsInstanceComparisonValue.isWithinAcceptedDeviations(local, remote, context.getAcceptedComparisonDeviation(category), detailedDiff))).filter(FindingInstanceComparisonDiffEntry::hasRealDifference);
    }

    private static boolean isWithinAcceptedDeviations(FindingsInstanceComparisonValue local, FindingsInstanceComparisonValue remote, double acceptedDeviation, @Nullable FindingInstanceComparisonDiffEntry.DetailedFindingInstanceComparisonDiff detailedDiff) {
        boolean isWithinAcceptedDeviation;
        FindingInstanceComparisonDiffEntry.FindingsCount localCount = local.getFindingsCount();
        FindingInstanceComparisonDiffEntry.FindingsCount remoteCount = remote.getFindingsCount();
        boolean bl = isWithinAcceptedDeviation = IInstanceComparisonValue.isWithinAcceptedDeviation(localCount.normal(), remoteCount.normal(), acceptedDeviation) && IInstanceComparisonValue.isWithinAcceptedDeviation(localCount.tolerated(), remoteCount.tolerated(), acceptedDeviation) && (double)localCount.falsePositive() <= (1.0 + acceptedDeviation) * (double)remoteCount.falsePositive();
        if (detailedDiff != null) {
            isWithinAcceptedDeviation &= FindingsInstanceComparisonValue.detailedDiffIsWithinAcceptedDeviations(detailedDiff.newLocalFindings, localCount, acceptedDeviation, false) && FindingsInstanceComparisonValue.detailedDiffIsWithinAcceptedDeviations(detailedDiff.disappearedRemoteFindings, remoteCount, acceptedDeviation, true);
        }
        return isWithinAcceptedDeviation;
    }

    private static boolean detailedDiffIsWithinAcceptedDeviations(FindingInstanceComparisonDiffEntry.FindingsCount changedFindings, FindingInstanceComparisonDiffEntry.FindingsCount allFindings, double acceptedDeviation, boolean disappearedFindings) {
        return (double)changedFindings.normal() <= (double)allFindings.normal() * acceptedDeviation && (double)changedFindings.tolerated() <= (double)allFindings.tolerated() * acceptedDeviation && (disappearedFindings || (double)changedFindings.falsePositive() <= acceptedDeviation);
    }

    private static @NonNull FindingsInstanceComparisonValue buildEmptyComparisonValue(String category, FindingsComparisonContribution findingsContribution) {
        return new FindingsInstanceComparisonValue(category, 0, 0, 0, new FindingsComparisonDetailContribution(), findingsContribution.getLinesOfCode(), findingsContribution.getUnflaggedFindingsCount());
    }

    private static @Nullable FindingInstanceComparisonDiffEntry.DetailedFindingInstanceComparisonDiff computeDetailedDiff(FindingsInstanceComparisonValue local, FindingsInstanceComparisonValue remote, String category) {
        if (local.detail == null || remote.detail == null) {
            return null;
        }
        Pair<Integer, Integer> nonBlacklistedDifference = FindingsInstanceComparisonValue.getDifference(local.detail.getNonBlacklistedFindings(category), remote.detail.getNonBlacklistedFindings(category));
        Pair<Integer, Integer> toleratedDifference = FindingsInstanceComparisonValue.getDifference(local.detail.getToleratedFindings(category), remote.detail.getToleratedFindings(category));
        Pair<Integer, Integer> falsePositiveDifference = FindingsInstanceComparisonValue.getDifference(local.detail.getFalsePositiveFindings(category), remote.detail.getFalsePositiveFindings(category));
        FindingInstanceComparisonDiffEntry.FindingsCount newLocalFindings = new FindingInstanceComparisonDiffEntry.FindingsCount((Integer)nonBlacklistedDifference.getFirst(), (Integer)toleratedDifference.getFirst(), (Integer)falsePositiveDifference.getFirst());
        FindingInstanceComparisonDiffEntry.FindingsCount disappearedRemoteFindings = new FindingInstanceComparisonDiffEntry.FindingsCount((Integer)nonBlacklistedDifference.getSecond(), (Integer)toleratedDifference.getSecond(), (Integer)falsePositiveDifference.getSecond());
        double relativeChangeForCheck = FindingsInstanceComparisonValue.calculateRelativeChangeForCheck(local.normalFindingsCount, remote.normalFindingsCount);
        double relativeChangeForAllFindings = FindingsInstanceComparisonValue.calculateRelativeChangeForAllFindings(local.normalFindingsCount, remote.normalFindingsCount, remote.totalFindingsCount);
        double influenceOnFindingsDensity = FindingsInstanceComparisonValue.calculateInfluenceOnFindingsDensity(local.normalFindingsCount, remote.normalFindingsCount, remote.totalFindingsCount, local.linesOfCode, remote.linesOfCode);
        return new FindingInstanceComparisonDiffEntry.DetailedFindingInstanceComparisonDiff(newLocalFindings, disappearedRemoteFindings, relativeChangeForCheck, relativeChangeForAllFindings, influenceOnFindingsDensity);
    }

    private static Pair<Integer, Integer> getDifference(Set<FindingsComparisonDetailContribution.Finding> localFindings, Set<FindingsComparisonDetailContribution.Finding> remoteFindings) {
        Set localIdentifier = localFindings.stream().map(finding -> FindingsComparisonDetailContribution.toComparableKey(finding, null)).collect(Collectors.toSet());
        Set remoteIdentifier = remoteFindings.stream().map(finding -> FindingsComparisonDetailContribution.toComparableKey(finding, null)).collect(Collectors.toSet());
        int newCount = (int)localIdentifier.stream().filter(Predicate.not(remoteIdentifier::contains)).count();
        int disappearedCount = (int)remoteIdentifier.stream().filter(Predicate.not(localIdentifier::contains)).count();
        return new Pair((Object)newCount, (Object)disappearedCount);
    }

    private static double calculateRelativeChangeForCheck(int localFindingsCount, int remoteFindingsCount) {
        if (remoteFindingsCount == 0) {
            return Double.NaN;
        }
        return (double)(localFindingsCount - remoteFindingsCount) / (double)remoteFindingsCount;
    }

    private static double calculateRelativeChangeForAllFindings(int localFindingsCountOfCheck, int remoteFindingsCountOfCheck, int completeRemoteFindingsCount) {
        if (completeRemoteFindingsCount == 0) {
            return Double.NaN;
        }
        return (double)(localFindingsCountOfCheck - remoteFindingsCountOfCheck) / (double)completeRemoteFindingsCount;
    }

    private static double calculateInfluenceOnFindingsDensity(int localFindingsCount, int remoteFindingsCount, int completeRemoteFindingsCount, int localLinesOfCode, int remoteLinesOfCode) {
        if (localLinesOfCode == 0 || remoteLinesOfCode == 0) {
            return Double.NaN;
        }
        double remoteFindingsDensity = FindingsInstanceComparisonValue.calculateFindingsDensity(completeRemoteFindingsCount, remoteLinesOfCode);
        double newFindingsDensity = FindingsInstanceComparisonValue.calculateFindingsDensity(completeRemoteFindingsCount - remoteFindingsCount + localFindingsCount, localLinesOfCode);
        return (newFindingsDensity - remoteFindingsDensity) / remoteFindingsDensity;
    }

    private static double calculateFindingsDensity(int findingsCount, double linesOfCode) {
        return (double)findingsCount / linesOfCode * 1000.0;
    }

    private FindingInstanceComparisonDiffEntry.FindingsCount getFindingsCount() {
        return new FindingInstanceComparisonDiffEntry.FindingsCount(this.normalFindingsCount, this.toleratedCategoriesValue, this.falsePositiveCategoriesValue);
    }
}

