/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.architecture.incremental.ArchitectureMappingIndex;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

class ArchitectureComponentMappingUpdater {
    private final ArchitectureMappingIndex mappingIndex;
    private final Set<String> deletedTypes = new HashSet<String>();
    private final Set<String> deletedFiles = new HashSet<String>();
    private final Set<String> addedTypes = new HashSet<String>();
    private final Set<String> addedFiles = new HashSet<String>();
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final TokenElementIndex contentIndex;
    private final Set<String> affectedTypes = new HashSet<String>();
    private final Set<String> affectedFiles = new HashSet<String>();
    private final TypeDependencyIndex typeDependencyIndex;
    private final TypeDependencyIndex previousTypeDependencyIndex;
    private final Set<String> knownTypes = new HashSet<String>();

    public ArchitectureComponentMappingUpdater(KeyDelta typeDelta, KeyDelta typeDependencyDelta, TokenElementIndex previousContentIndex, TokenElementIndex contentIndex, TypeIndex previousTypeIndex, TypeIndex typeIndex, TypeDependencyIndex previousTypeDependencyIndex, TypeDependencyIndex typeDependencyIndex, ArchitectureMappingIndex mappingIndex, IParallelTaskExecutor parallelTaskExecutor) throws StorageException {
        this.contentIndex = contentIndex;
        this.mappingIndex = mappingIndex;
        this.typeDependencyIndex = typeDependencyIndex;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.previousTypeDependencyIndex = previousTypeDependencyIndex;
        List addedOrChangedTypes = typeDelta.getAddedOrChangedKeysAsStrings();
        this.addedFiles.addAll(ArchitectureComponentMappingUpdater.getAddedFiles(List.of(ArchitectureComponentMappingUpdater.filterKeys(addedOrChangedTypes, "file:"), typeDependencyDelta.getAddedOrChangedKeysAsStrings()), previousContentIndex));
        this.deletedFiles.addAll(ArchitectureComponentMappingUpdater.filterKeys(typeDelta.getDeletedKeysAsStrings(), "file:"));
        this.addedTypes.addAll(ArchitectureComponentMappingUpdater.getAddedTypes(ArchitectureComponentMappingUpdater.filterKeys(addedOrChangedTypes, "type:"), previousTypeIndex));
        this.deletedTypes.addAll(ArchitectureComponentMappingUpdater.filterKeys(typeDelta.getDeletedKeysAsStrings(), "type:"));
        this.affectedFiles.addAll(this.addedFiles);
        this.affectedFiles.addAll(typeDependencyDelta.getAddedOrChangedKeysAsStrings());
        this.affectedFiles.addAll(this.deletedFiles);
        this.affectedTypes.addAll(this.addedTypes);
        this.affectedTypes.addAll(this.deletedTypes);
        this.affectedTypes.addAll(typeIndex.getTypeNamesForFiles(typeDependencyDelta.getAddedOrChangedKeysAsStrings()).stream().flatMap(Collection::stream).toList());
        this.knownTypes.addAll(typeIndex.getAllTypeNames());
    }

    private static Set<String> getAddedFiles(Collection<? extends Collection<String>> addedOrChanged, TokenElementIndex previousContentIndex) throws StorageException {
        List<String> list = addedOrChanged.stream().flatMap(Collection::stream).distinct().toList();
        List<TokenElementInfo> tokenElements = previousContentIndex.getTokenElements(list);
        return CollectionUtils.zipAsStream(list, tokenElements).filter(p -> p.getSecond() == null).map(ImmutablePair::getFirst).collect(Collectors.toSet());
    }

    private static Set<String> getAddedTypes(Collection<String> addedOrChanged, TypeIndex previousTypeIndex) throws StorageException {
        List<List<String>> filesForTypes = previousTypeIndex.getFilesForTypes(addedOrChanged);
        return CollectionUtils.zipAsStream(addedOrChanged, filesForTypes).filter(p -> ((List)p.getSecond()).isEmpty()).map(ImmutablePair::getFirst).collect(Collectors.toSet());
    }

    public Optional<TypeComponentMapping> updateComponentMapping(String architecturePath) throws ConQATException {
        TokenElementInfo tokenElement = this.contentIndex.getTokenElement(Objects.requireNonNull(architecturePath));
        ArchitectureDefinition architectureDefinition = ArchitectureAnalysisUtils.getArchitectureDefinition(tokenElement);
        if (ArchitectureComponentMappingUpdater.isUnaffected(architectureDefinition, this.affectedFiles, this.affectedTypes)) {
            return Optional.empty();
        }
        TypeComponentMapping metaInfo = this.mappingIndex.getMapping(architecturePath);
        if (metaInfo == null) {
            return Optional.empty();
        }
        Set<String> deletedKeys = architectureDefinition.isFileBased() ? this.deletedFiles : this.deletedTypes;
        Set<String> addedKeys = architectureDefinition.isFileBased() ? this.addedFiles : this.addedTypes;
        TypeToComponentMapper typeToComponentMapper = new TypeToComponentMapper(architectureDefinition, this.parallelTaskExecutor);
        this.removeDeletedKeys(metaInfo, typeToComponentMapper, deletedKeys);
        this.updateThirdPartyDependencies(metaInfo, typeToComponentMapper);
        ArchitectureComponentMappingUpdater.mapAddedKeys(typeToComponentMapper, addedKeys, metaInfo);
        return Optional.of(metaInfo);
    }

    private void updateThirdPartyDependencies(TypeComponentMapping metaInfo, TypeToComponentMapper typeToComponentMapper) throws StorageException {
        PairList<String, List<String>> currentDependencies = this.currentThirdPartyDependencies(this.addedFiles);
        PairList<String, List<String>> previousDependencies = this.previousThirdPartyDependencies(this.addedFiles);
        HashSet<String> addedThirdPartyDependencies = new HashSet<String>();
        for (int i = 0; i < currentDependencies.size(); ++i) {
            List current3rdPartyDependencies = (List)currentDependencies.getSecond(i);
            List previous3rdPartyDependencies = (List)previousDependencies.getSecond(i);
            HashSet newThirdPartyDependencies = CollectionUtils.differenceSet((Collection)current3rdPartyDependencies, (Collection[])new Collection[]{previous3rdPartyDependencies});
            HashSet deletedThirdPartyDependencies = CollectionUtils.differenceSet((Collection)previous3rdPartyDependencies, (Collection[])new Collection[]{current3rdPartyDependencies});
            ArchitectureComponentMappingUpdater.removeThirdPartyDependencies(metaInfo, deletedThirdPartyDependencies, typeToComponentMapper);
            metaInfo.addThirdPartyDependency(newThirdPartyDependencies);
            addedThirdPartyDependencies.addAll(newThirdPartyDependencies);
        }
        TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(addedThirdPartyDependencies);
        metaInfo.addTypes(mappingResult);
    }

    private static void mapAddedKeys(TypeToComponentMapper typeToComponentMapper, Set<String> addedKeys, TypeComponentMapping metaInfo) {
        TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(addedKeys);
        metaInfo.addTypes(mappingResult);
    }

    private void removeDeletedKeys(TypeComponentMapping metaInfo, TypeToComponentMapper typeToComponentMapper, Set<String> deletedKeys) throws StorageException {
        List<String> list = this.previousThirdPartyDependencies(this.deletedFiles).getSecondList().stream().flatMap(Collection::stream).toList();
        ArchitectureComponentMappingUpdater.removeThirdPartyDependencies(metaInfo, list, typeToComponentMapper);
        TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(deletedKeys);
        metaInfo.removeType(deletedKeys, mappingResult.numberOfMatches());
    }

    private static void removeThirdPartyDependencies(TypeComponentMapping metaInfo, Collection<String> thirdPartyTypes, TypeToComponentMapper typeToComponentMapper) {
        Set<String> removableTypes = metaInfo.removeThirdPartyDependency(thirdPartyTypes);
        TypeToComponentMapper.MappingResult mappingResult = typeToComponentMapper.map(removableTypes);
        metaInfo.removeType(removableTypes, mappingResult.numberOfMatches());
    }

    private static boolean isUnaffected(ArchitectureDefinition architectureDefinition, Set<String> affectedFiles, Set<String> affectedTypes) {
        if (architectureDefinition.isFileBased()) {
            return affectedFiles.stream().noneMatch(architectureDefinition::isIncludedInScope);
        }
        return affectedTypes.stream().noneMatch(architectureDefinition::isIncludedInScope);
    }

    private static List<String> filterKeys(List<String> keys, String prefix) {
        return new ArrayList<String>(keys.stream().filter(t -> t.startsWith(prefix)).map(key -> StringUtils.stripPrefix((String)key, (String)prefix)).toList());
    }

    private PairList<String, List<String>> currentThirdPartyDependencies(Set<String> types) throws StorageException {
        return this.getThirdPartyDependencies(this.typeDependencyIndex, types);
    }

    private PairList<String, List<String>> previousThirdPartyDependencies(Set<String> types) throws StorageException {
        return this.getThirdPartyDependencies(this.previousTypeDependencyIndex, types);
    }

    private PairList<String, List<String>> getThirdPartyDependencies(TypeDependencyIndex typeDependencyIndex, Collection<String> types) throws StorageException {
        PairList<String, ArrayList<TypeDependencies>> typeDependencies = typeDependencyIndex.getTypeDependenciesPerUniformPath(new ArrayList<String>(types));
        PairList current3rdPartyDependencies = new PairList();
        for (Pair dependencies : typeDependencies) {
            List<String> list = ((ArrayList)dependencies.getSecond()).stream().map(TypeDependencies::getDependencies).flatMap(Collection::stream).filter(t -> !this.knownTypes.contains(t)).toList();
            current3rdPartyDependencies.add((Object)((String)dependencies.getFirst()), list);
        }
        return current3rdPartyDependencies;
    }
}

