/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.code_change.ChangeRegion;
import com.teamscale.index.code_change.MatchRegionContent;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass(containedInBackup=true)
public class MatchRegion
extends ChangeRegion {
    private static final long serialVersionUID = 1L;
    protected static final String ENTIRE_FILE_ID = "entire file";
    private final String uniformPath;
    private transient @Nullable UniformPath parsedUniformPath;
    private final String originPath;
    private final ELanguage language;
    protected final String id;
    private final String contentHash;
    protected transient MatchRegion match;
    protected transient MatchRegionContent content;

    protected MatchRegion(int startOffset, int endOffset, long lastChangeTimestamp, TokenElementInfo elementInfo, String originPath, String id, MatchRegionContent content) {
        super(startOffset, endOffset, lastChangeTimestamp);
        this.id = id;
        this.uniformPath = elementInfo.getUniformPath();
        this.originPath = originPath;
        this.language = elementInfo.getLanguage();
        this.content = content;
        this.contentHash = content.calculateContentHash();
    }

    public MatchRegion(long lastChangeTimestamp, TokenElementInfo elementInfo, String originPath) {
        this(0, MatchRegion.getRegionEnd(elementInfo), lastChangeTimestamp, elementInfo, originPath, ENTIRE_FILE_ID, new MatchRegionContent((List<IToken>)elementInfo.getTokens(), elementInfo.getLanguage()));
    }

    private static int getRegionEnd(TokenElementInfo elementInfo) {
        int elementLength = elementInfo.getText().length();
        if (elementLength == 0) {
            return 0;
        }
        return elementLength - 1;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public UniformPath getParsedUniformPath() {
        UniformPath tmp = this.parsedUniformPath;
        if (tmp == null) {
            this.parsedUniformPath = tmp = UniformPathCompatibilityUtil.convert((String)this.uniformPath);
        }
        return tmp;
    }

    public String getSimpleName() {
        return ENTIRE_FILE_ID;
    }

    public String getParentName() {
        return ENTIRE_FILE_ID;
    }

    public String getId() {
        return this.id;
    }

    public String getQualifiedId() {
        return UniformPathUtils.concatenate((String[])new String[]{this.getUniformPath(), this.id});
    }

    public String getQualifiedSimpleName() {
        return UniformPathUtils.concatenate((String[])new String[]{this.getUniformPath(), this.getSimpleName()});
    }

    public String getOriginQualifiedId() {
        CCSMAssert.isNotNull((Object)this.originPath);
        return UniformPathUtils.concatenate((String[])new String[]{this.originPath, this.id});
    }

    public boolean hasOriginInformation() {
        return this.originPath != null;
    }

    public boolean isMatched() {
        return this.match != null;
    }

    public void match(MatchRegion other) {
        CCSMAssert.isTrue((!this.isMatched() && !other.isMatched() ? 1 : 0) != 0, (String)"Both regions must be unmatched!");
        this.match = other;
        other.match = this;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public MatchRegionContent getContent() {
        return this.content;
    }

    public long getLastChangeTimestampOfMatch() {
        CCSMAssert.isNotNull((Object)((Object)this.match));
        return this.match.getLastChangeTimestamp();
    }

    public MatchRegion getMatch() {
        return this.match;
    }

    public ELanguage getLanguage() {
        return this.language;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MatchRegion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchRegion)) {
            return false;
        }
        MatchRegion that = (MatchRegion)((Object)o);
        return that.canEqual((Object)this) && Objects.equals(this.getUniformPath(), that.getUniformPath()) && Objects.equals(this.id, that.id) && Objects.equals(this.contentHash, that.contentHash);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getUniformPath(), this.id, this.contentHash);
    }

    @Override
    public String toString() {
        return this.getUniformPath() + "#" + this.getSimpleName() + " : " + super.toString();
    }
}

