/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change.refactoring_detection;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.pattern.EnumPatternMatcher;
import org.conqat.engine.sourcecode.pattern.TokenTypePattern;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class TypeAwareTokenListIterator {
    private final List<IToken> tokens;
    private int tokenPos = 0;
    private final ScopedTypeLookup typeLookup;

    public TypeAwareTokenListIterator(List<IToken> tokens, ScopedTypeLookup typeLookup) {
        this.tokens = tokens;
        this.typeLookup = typeLookup;
    }

    public IToken getCurrentToken() {
        return this.getToken(this.tokenPos);
    }

    public IToken getToken(int index) throws AssertionError {
        CCSMAssert.isTrue((index >= 0 && index < this.tokens.size() ? 1 : 0) != 0, (String)"Token position is out of bounds!");
        return this.tokens.get(index);
    }

    public boolean isOfType(int offset, ETokenType ... tokenTypes) {
        return TokenStreamUtils.hasTokenTypeSequence(this.tokens, (int)(this.tokenPos + offset), (ETokenType[])tokenTypes);
    }

    public boolean isOfAnyType(int offset, Set<ETokenType> tokenTypes) {
        return tokenTypes.contains(this.getToken(this.tokenPos + offset).getType());
    }

    public boolean hasCurrentToken() {
        return this.tokenPos < this.tokens.size();
    }

    public TypedVariable getTypeInfo(String variableName) {
        if (this.typeLookup == null) {
            return null;
        }
        return this.typeLookup.getTypeInfo(variableName);
    }

    public boolean isSubList(List<IToken> subList) {
        int endIndex = this.tokenPos + subList.size();
        if (endIndex < 0 || endIndex >= this.tokens.size()) {
            return false;
        }
        for (int j = 0; j < subList.size(); ++j) {
            if (TypeAwareTokenListIterator.tokenNameAndTypesEqual(subList.get(j), this.tokens.get(this.tokenPos + j))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesFollowing(int offset, TokenTypePattern tokenTypePattern) {
        int offsetTokenPos = this.tokenPos + offset;
        if (offsetTokenPos < 0 || offsetTokenPos >= this.tokens.size()) {
            return false;
        }
        List<IToken> subList = this.tokens.subList(offsetTokenPos, this.tokens.size());
        return tokenTypePattern.matcher(subList).lookingAt();
    }

    public boolean matchesFollowing(TokenTypePattern tokenTypePattern) {
        return this.matchesFollowing(0, tokenTypePattern);
    }

    public void skip(TokenTypePattern tokenTypePattern) {
        List<IToken> subList = this.tokens.subList(this.tokenPos, this.tokens.size());
        EnumPatternMatcher matcher = tokenTypePattern.matcher(subList);
        if (matcher.lookingAt()) {
            this.incTokenPos(matcher.end());
        }
    }

    public boolean skipTokens(Set<ETokenType> ignoredTokenTypes) {
        boolean hasSkipped = false;
        while (this.hasCurrentToken() && this.isOfAnyType(0, ignoredTokenTypes)) {
            this.incTokenPos(1);
            hasSkipped = true;
        }
        return hasSkipped;
    }

    private static boolean tokenNameAndTypesEqual(IToken token1, IToken token2) {
        if (token1.getType() != token2.getType()) {
            return false;
        }
        if (token1.getLanguage().isCaseSensitive() || TokenUtils.ALWAYS_CASE_SENSITIVE_TOKEN_TYPES.contains((Object)token1.getType())) {
            return token1.getText().equals(token2.getText());
        }
        return token1.getText().equalsIgnoreCase(token2.getText());
    }

    public boolean currentTokenNameAndTypesEqual(TypeAwareTokenListIterator other) {
        return TypeAwareTokenListIterator.tokenNameAndTypesEqual(this.getCurrentToken(), other.getCurrentToken());
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        int start = Math.max(this.tokenPos - 10, 0);
        int end = Math.min(this.tokenPos + 10, this.tokens.size());
        for (int i = start; i < end; ++i) {
            if (i == this.tokenPos) {
                text.append(" >>").append(this.tokens.get(i).getText()).append("<<");
                continue;
            }
            text.append(" ").append(this.tokens.get(i).getText());
        }
        return text.toString();
    }

    public int getTokenPos() {
        return this.tokenPos;
    }

    public void incTokenPos(int offset) {
        this.tokenPos += offset;
    }

    public void setTokenPos(int tokenPos) {
        this.tokenPos = tokenPos;
    }

    public int size() {
        return this.tokens.size();
    }
}

