/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.core;

public abstract class Unit {
    private final String elementUniformPath;
    private int indexInElement;
    private final String content;
    private final String unnormalizedContent;
    private final int filteredStartOffset;
    private final int filteredEndOffset;

    protected Unit(int filteredStartOffset, int filteredEndOffset, String elementUniformPath, String content, int indexInElement) {
        this(filteredStartOffset, filteredEndOffset, elementUniformPath, content, content, indexInElement);
    }

    protected Unit(int filteredStartOffset, int filteredEndOffset, String elementUniformPath, String content, String unnormalizedContent, int indexInElement) {
        this.filteredStartOffset = filteredStartOffset;
        this.filteredEndOffset = filteredEndOffset;
        this.elementUniformPath = elementUniformPath;
        this.content = content;
        this.unnormalizedContent = unnormalizedContent;
        this.indexInElement = indexInElement;
    }

    public String getElementUniformPath() {
        return this.elementUniformPath;
    }

    public int getFilteredStartOffset() {
        return this.filteredStartOffset;
    }

    public int getFilteredEndOffset() {
        return this.filteredEndOffset;
    }

    public int getIndexInElement() {
        return this.indexInElement;
    }

    public void setIndexInElement(int newIndex) {
        this.indexInElement = newIndex;
    }

    public String getContent() {
        return this.content;
    }

    public String getUnnormalizedContent() {
        return this.unnormalizedContent;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Unit)) {
            return false;
        }
        return this.content.equals(((Unit)other).content);
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean inSameElement(Unit other) {
        return this.getElementUniformPath().equals(other.getElementUniformPath());
    }

    public String toString() {
        return "Unit{class=" + this.getClass().getSimpleName() + ", path='" + this.elementUniformPath + "', indexInElement=" + this.indexInElement + ", content='" + this.content + "', unnormalizedContent='" + this.unnormalizedContent + "', offsets=" + this.filteredStartOffset + "-" + this.filteredEndOffset + "}";
    }
}

