/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.index.configuration.SimulinkAnalysisConfigurationBase;
import com.teamscale.index.simulink.analysis.SimulinkAnalysisRunner;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.SimulinkMetricAnalysisBase;
import com.teamscale.index.simulink.analysis.finding.LibraryLinkCountFinding;
import com.teamscale.index.simulink.analysis.finding.LoopCountFinding;
import com.teamscale.index.simulink.analysis.finding.MatlabFunctionCountFinding;
import com.teamscale.index.simulink.analysis.finding.MaximumBlocksInSubsystemFinding;
import com.teamscale.index.simulink.analysis.finding.NestingDepthFinding;
import com.teamscale.index.simulink.analysis.finding.SFunctionCountFinding;
import com.teamscale.index.simulink.analysis.finding.StateflowChartCountFinding;
import com.teamscale.index.simulink.analysis.finding.SubsystemCountFinding;
import com.teamscale.index.simulink.analysis.finding.ThresholdFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.metric.BlockCountMetric;
import com.teamscale.index.simulink.analysis.metric.LibraryLinkCountMetric;
import com.teamscale.index.simulink.analysis.metric.LoopCountMetric;
import com.teamscale.index.simulink.analysis.metric.MatlabFunctionCountMetric;
import com.teamscale.index.simulink.analysis.metric.MaximumBlocksInSubsystemMetric;
import com.teamscale.index.simulink.analysis.metric.NestingDepthMetric;
import com.teamscale.index.simulink.analysis.metric.SFunctionCountMetric;
import com.teamscale.index.simulink.analysis.metric.StateCountMetric;
import com.teamscale.index.simulink.analysis.metric.StateflowChartCountMetric;
import com.teamscale.index.simulink.analysis.metric.SubsystemCountMetric;
import java.util.Base64;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.PairList;

public class SimulinkAnalysisConfiguration
extends SimulinkAnalysisConfigurationBase {
    @ConfigExposed(name="Nesting Depth Thresholds", description="Thresholds for nesting depth.")
    private NumericThresholds nestingDepthThresholds = new NumericThresholds(3, 5);
    @ConfigExposed(name="Library Link Count Thresholds", description="Thresholds for library links.")
    private NumericThresholds libraryLinksThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="Loop Thresholds", description="Thresholds for loops.")
    private NumericThresholds loopThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="MATLAB Function Thresholds", description="Thresholds for MATLAB functions.")
    private NumericThresholds matlabFunctionThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="Maximum Blocks in Subsystem Thresholds", description="Thresholds for maximum blocks in subsystem.")
    private NumericThresholds maximumBlocksInSubsystemThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="S-Function Thresholds", description="Thresholds for S-functions.")
    private NumericThresholds sFunctionThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="Stateflow Charts Thresholds", description="Thresholds for stateflow charts.")
    private NumericThresholds stateflowChartsThresholds = new NumericThresholds(10, 20);
    @ConfigExposed(name="Subystem Thresholds", description="Thresholds for subsystems.")
    private NumericThresholds subsystemThresholds = new NumericThresholds(10, 20);
    public static final String SIMULINK_CHECK_CATEGORY = "Simulink Internal Checks";
    private static final Class<? extends SimulinkMetricAnalysisBase>[] AVAILABLE_METRICS = new Class[]{BlockCountMetric.class, StateCountMetric.class, MatlabFunctionCountMetric.class, MaximumBlocksInSubsystemMetric.class, NestingDepthMetric.class, SubsystemCountMetric.class, LibraryLinkCountMetric.class, LoopCountMetric.class, SFunctionCountMetric.class, StateflowChartCountMetric.class};
    private static final Class<? extends SimulinkFindingAnalysisBase>[] AVAILABLE_FINDINGS = new Class[]{NestingDepthFinding.class, LibraryLinkCountFinding.class, LoopCountFinding.class, MatlabFunctionCountFinding.class, MaximumBlocksInSubsystemFinding.class, SFunctionCountFinding.class, StateflowChartCountFinding.class, SubsystemCountFinding.class};
    public static final String RED_THRESHOLD_PROPERTY_NAME = "Red Threshold";
    public static final String YELLOW_THRESHOLD_PROPERTY_NAME = "Yellow Threshold";

    public SimulinkAnalysisConfiguration() {
        this.createMetricDescriptors(AVAILABLE_METRICS);
        this.createFindingDescriptors(AVAILABLE_FINDINGS);
        this.autoExpose();
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(SimulinkAnalysisRunner.class);
        this.configureMetrics(proxy, trigger);
        this.configureFindings(proxy, trigger, SIMULINK_CHECK_CATEGORY);
        HashMap<String, NumericThresholds> thresholdsMap = this.buildThresholdParametersMap();
        try {
            trigger.setTriggerParameter("metricThresholds.serializedThresholds", Base64.getEncoder().encodeToString(StorageUtils.serialize(thresholdsMap)));
        }
        catch (StorageException e) {
            throw new ProjectConfigurationException("IO Exception while serializing threshold parameters to pass them to analysis.", (Throwable)e);
        }
        proxy.createTrigger(trigger);
    }

    private HashMap<String, NumericThresholds> buildThresholdParametersMap() {
        HashMap<String, NumericThresholds> thresholdsMap = new HashMap<String, NumericThresholds>();
        Set enabledThresholdAnalyses = this.findingAnalyses.stream().filter(pair -> ((FindingDescriptor)pair.getSecond()).getEnablement().isEnabled()).filter(pair -> ThresholdFindingAnalysisBase.class.isAssignableFrom((Class)pair.getFirst())).map(ImmutablePair::getFirst).collect(Collectors.toSet());
        for (Class analysisClass : enabledThresholdAnalyses) {
            NumericThresholds thresholds = this.getThresholdsConfigurationForAnalysis(analysisClass.getSimpleName());
            if (thresholds == null) continue;
            thresholdsMap.put(analysisClass.getSimpleName(), thresholds);
        }
        return thresholdsMap;
    }

    @Override
    protected PairList<String, String> getFindingPropertyDescriptions(Class<? extends SimulinkFindingAnalysisBase> findingClass) {
        PairList<String, String> descriptions = super.getFindingPropertyDescriptions(findingClass);
        NumericThresholds thresholds = this.getThresholdsConfigurationForAnalysis(findingClass.getSimpleName());
        if (thresholds == null) {
            return descriptions;
        }
        descriptions.add((Object)YELLOW_THRESHOLD_PROPERTY_NAME, (Object)"The threshold for yellow findings of this type.");
        descriptions.add((Object)RED_THRESHOLD_PROPERTY_NAME, (Object)"The threshold for red findings of this type.");
        return descriptions;
    }

    private NumericThresholds getThresholdsConfigurationForAnalysis(String simpleName) {
        if (simpleName.equals(NestingDepthFinding.class.getSimpleName())) {
            return this.nestingDepthThresholds;
        }
        if (simpleName.equals(LibraryLinkCountFinding.class.getSimpleName())) {
            return this.libraryLinksThresholds;
        }
        if (simpleName.equals(LoopCountFinding.class.getSimpleName())) {
            return this.loopThresholds;
        }
        if (simpleName.equals(MatlabFunctionCountFinding.class.getSimpleName())) {
            return this.matlabFunctionThresholds;
        }
        if (simpleName.equals(MaximumBlocksInSubsystemFinding.class.getSimpleName())) {
            return this.maximumBlocksInSubsystemThresholds;
        }
        if (simpleName.equals(SFunctionCountFinding.class.getSimpleName())) {
            return this.sFunctionThresholds;
        }
        if (simpleName.equals(StateflowChartCountFinding.class.getSimpleName())) {
            return this.stateflowChartsThresholds;
        }
        if (simpleName.equals(SubsystemCountFinding.class.getSimpleName())) {
            return this.subsystemThresholds;
        }
        return null;
    }
}

