/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.c;

import com.teamscale.index.dataflow.FilterUnpreprocessedTokenUtils;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PragmaUnusedParameterFilter
implements IFalsePositiveFilter {
    private static final String PRAGMA_UNUSED_LPAREN = "#pragma unused(";

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo element) throws ConQATException {
        if (cfg.getEntities().isEmpty()) {
            return false;
        }
        ShallowEntity preprocessedMethodEntity = cfg.getEntities().get(0);
        UnmodifiableList<IToken> unpreprocessedTokens = element.getTokens();
        List<IToken> methodTokensUnpreprocessed = FilterUnpreprocessedTokenUtils.getUnpreprocessedMethodTokens(preprocessedMethodEntity, unpreprocessedTokens);
        for (IToken token : methodTokensUnpreprocessed) {
            Set<String> unusedParametersDeclared;
            if (token.getType() != ETokenType.PRAGMA_DIRECTIVE || !token.getText().startsWith(PRAGMA_UNUSED_LPAREN) || !(unusedParametersDeclared = PragmaUnusedParameterFilter.extractUnusedVariablesFromPragma(token.getText())).contains(variable)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> extractUnusedVariablesFromPragma(String pragmaTokenText) {
        String unusedParametersDeclaredSeparated = pragmaTokenText.substring(PRAGMA_UNUSED_LPAREN.length(), pragmaTokenText.length() - 1).replace(" ", "");
        return Set.of(unusedParametersDeclaredSeparated.split(","));
    }
}

