/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.DependencyExtractionIndexes;
import com.teamscale.index.dependencies.DependencyExtractionSettings;
import com.teamscale.index.dependencies.IDependencyExtractor;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public abstract class DependencyExtractorBase
implements IDependencyExtractor {
    protected final EnumSet<ETokenType> namespaceSeparators;
    protected ITypeLookupEnvironment typeLookupEnvironment;
    protected final PairList<String, TextRegionLocation> identifiers = new PairList();
    protected ETokenType previousTokenType;
    protected final List<IToken> currentIdentifierTokens = new ArrayList<IToken>();
    protected boolean inIdentifier;
    protected String uniformPath;
    protected DependencyExtractionSettings settings;
    protected DependencyExtractionIndexes dependencyExtractionIndexes;

    protected DependencyExtractorBase() {
        this(ETokenType.DOT);
    }

    protected DependencyExtractorBase(ETokenType ... namespaceSeparators) {
        this.namespaceSeparators = EnumSet.copyOf(Arrays.asList(namespaceSeparators));
    }

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo, DependencyExtractionIndexes dependencyExtractionIndexes, ITypeLookupEnvironment typeLookupEnvironment, DependencyExtractionSettings dependencyExtractionSettings) throws ConQATException {
        this.typeLookupEnvironment = typeLookupEnvironment;
        this.dependencyExtractionIndexes = dependencyExtractionIndexes;
        this.uniformPath = tokenElementInfo.getUniformPath();
        this.settings = dependencyExtractionSettings;
        this.identifiers.clear();
        this.currentIdentifierTokens.clear();
        this.inIdentifier = false;
        this.previousTokenType = null;
        return this.extractDependencies(tokenElementInfo);
    }

    public static TextRegionLocation createLocation(String uniformPath, List<IToken> tokens) {
        return DependencyExtractorBase.createLocation(uniformPath, tokens, 0);
    }

    public static TextRegionLocation createLocation(String uniformPath, IToken ... tokens) {
        return DependencyExtractorBase.createLocation(uniformPath, Arrays.asList(tokens));
    }

    public static TextRegionLocation createLocation(String uniformPath, List<IToken> tokens, int startTokenIndex) {
        int rawStartLine = 1 + tokens.get(startTokenIndex).getLineNumber();
        int rawEndLine = 1 + ((IToken)CollectionUtils.getLast(tokens)).getLineNumber();
        return DependencyExtractorBase.createLocation(uniformPath, tokens, startTokenIndex, rawStartLine, rawEndLine);
    }

    public static TextRegionLocation createLocation(String uniformPath, List<IToken> tokens, int startTokenIndex, int rawStartLine, int rawEndLine) {
        CCSMAssert.isFalse((boolean)tokens.isEmpty(), (String)"Expected non-empty token list");
        int rawStartOffset = tokens.get(startTokenIndex).getOffset();
        int rawEndOffset = ((IToken)CollectionUtils.getLast(tokens)).getEndOffset();
        return new TextRegionLocation(uniformPath, rawStartOffset, rawEndOffset, rawStartLine, rawEndLine);
    }

    protected void addCurrentIdentifier(String uniformPath) {
        this.identifiers.add((Object)this.getCurrentIdentifierText(), (Object)DependencyExtractorBase.createLocation(uniformPath, this.currentIdentifierTokens));
    }

    protected void removeLastPartOfCurrentIdentifier(ETokenType tokenType) {
        int index = TokenStreamUtils.lastTokenMatching(this.currentIdentifierTokens, (ITokenMatcher)tokenType);
        CCSMAssert.isFalse((index == -1 ? 1 : 0) != 0, (String)("No token with type " + String.valueOf(tokenType) + " found"));
        ArrayList<IToken> newIdentifierTokens = new ArrayList<IToken>(this.currentIdentifierTokens.subList(0, index));
        this.currentIdentifierTokens.clear();
        this.currentIdentifierTokens.addAll(newIdentifierTokens);
    }

    protected String getCurrentIdentifierText() {
        return TokenStreamTextUtils.concatTokenTexts(this.currentIdentifierTokens);
    }

    protected void addNamespaceSeparatorIfInIdentifier(IToken token) {
        if (this.inIdentifier) {
            this.currentIdentifierTokens.add(token);
        }
    }

    protected void handleIdentifier(IToken identifierToken) {
        if (this.previousTokenType == ETokenType.IDENTIFIER) {
            this.addCurrentIdentifier(this.uniformPath);
            this.currentIdentifierTokens.clear();
            this.currentIdentifierTokens.add(identifierToken);
        } else if (this.namespaceSeparators.contains(this.previousTokenType)) {
            this.currentIdentifierTokens.add(identifierToken);
        } else {
            this.currentIdentifierTokens.clear();
            this.currentIdentifierTokens.add(identifierToken);
        }
        this.inIdentifier = true;
    }

    protected static List<IToken> getRawTokensWithoutComments(TokenElementInfo tokenElementInfo) {
        Predicate<IToken> isCommentPredicate = token -> token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT;
        return CollectionUtils.filter(tokenElementInfo.getRawTokens(), isCommentPredicate);
    }

    protected abstract List<TypeDependencies> extractDependencies(TokenElementInfo var1) throws ConQATException;

    protected String resolveImportedType(String importedType, boolean includeThirdPartyDependencies) {
        if (this.typeLookupEnvironment.isKnownType(importedType)) {
            return importedType;
        }
        String containingModuleOrClass = importedType;
        while (containingModuleOrClass.indexOf(46) != -1) {
            if (!this.typeLookupEnvironment.isKnownType(containingModuleOrClass = StringUtils.removeLastPart((String)containingModuleOrClass, (char)'.'))) continue;
            return containingModuleOrClass;
        }
        if (includeThirdPartyDependencies) {
            return importedType;
        }
        return null;
    }
}

